/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Blocks.Basin;

import com.cobbs.lordcraft.Blocks.ModTileEntity;
import com.cobbs.lordcraft.Entries.TileEntities;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.EObjective;
import com.cobbs.lordcraft.Util.Helpers.DataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import com.cobbs.lordcraft.Util.Recipes.BasinRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class BasinTE
extends ModTileEntity {
    public List<ItemStack> stacks = new ArrayList<ItemStack>();
    public int color;
    public int fluidHeight;
    public static final int MAX_FLUID = 64;

    public BasinTE() {
        super(TileEntities.ARCANE_BASIN_TE);
    }

    public boolean fill(PlayerEntity player) {
        if (this.fluidHeight != 0) {
            return false;
        }
        this.fluidHeight = 64;
        this.color = 0;
        this.stacks = new ArrayList<ItemStack>();
        SoundHelper.fill_fluid(player, 0.75f);
        return true;
    }

    public boolean empty(PlayerEntity player) {
        if (this.fluidHeight == 0) {
            return false;
        }
        this.setFluidHeight(0);
        SoundHelper.empty_fluid(player, 0.75f);
        return true;
    }

    public boolean addStack(PlayerEntity player, ItemStack stack) {
        if (this.fluidHeight == 64) {
            boolean val;
            int i;
            List<BasinRecipe> recipes = this.field_145850_b.func_199532_z().func_241447_a_(BasinRecipe.BASIN_RECIPE_TYPE);
            for (i = 0; i < this.stacks.size(); ++i) {
                recipes = BasinRecipe.getSubset(recipes, i, this.stacks.get(i));
            }
            boolean bl = val = !(recipes = BasinRecipe.getSubset(recipes, i, stack)).isEmpty();
            if (val) {
                this.color = recipes.get((int)0).color.get(i);
                ItemStack stk = stack.func_77946_l();
                stk.func_190920_e(1);
                this.stacks.add(stk);
                SoundHelper.mix_reagent(player, 0.75f);
            }
            return val;
        }
        return false;
    }

    public ItemStack attemptCollection(PlayerEntity player, ItemStack stack) {
        List<BasinRecipe> recipes = this.field_145850_b.func_199532_z().func_241447_a_(BasinRecipe.BASIN_RECIPE_TYPE);
        for (int i = 0; i < this.stacks.size(); ++i) {
            recipes = BasinRecipe.getSubset(recipes, i, this.stacks.get(i));
        }
        if (recipes.isEmpty() || this.stacks.size() == 0) {
            return ItemStack.field_190927_a;
        }
        for (BasinRecipe recipe : recipes) {
            int needed;
            if (!recipe.collector.test(stack) || this.fluidHeight < (needed = 64 / recipe.amount) || !DataStorageHelper.hasResearch(player, recipe.research)) continue;
            this.setFluidHeight(this.fluidHeight - needed);
            if (recipe.func_199560_c().toString().contains("crystallization")) {
                DataStorageHelper.incrementObjective(player, EObjective.BASIN_USAGE1);
            }
            return recipe.func_77571_b();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public CompoundNBT writeSynced(CompoundNBT tag) {
        tag = super.writeSynced(tag);
        tag.func_74768_a("fluid_height", this.fluidHeight);
        tag.func_74768_a("color", this.color);
        tag.func_74768_a("stacks", this.stacks.size());
        for (int i = 0; i < this.stacks.size(); ++i) {
            tag.func_218657_a(ModHelper.concat("stk", i), (INBT)this.stacks.get(i).serializeNBT());
        }
        return tag;
    }

    @Override
    public void readSynced(CompoundNBT tag) {
        super.readSynced(tag);
        this.fluidHeight = tag.func_74762_e("fluid_height");
        this.color = tag.func_74762_e("color");
        int size = tag.func_74762_e("stacks");
        this.stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(ModHelper.concat("stk", i)));
            this.stacks.add(stack);
        }
    }

    public void setFluidHeight(int height) {
        this.fluidHeight = height;
        if (height == 0) {
            this.stacks.clear();
            this.color = 0;
        }
    }
}

