/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Blocks.BlockTransmuter;

import com.cobbs.lordcraft.Blocks.BlockTransmuter.TransmuterContainer;
import com.cobbs.lordcraft.Blocks.ModTileEntity;
import com.cobbs.lordcraft.Blocks.MulticolouredBlocks.ECBlockType;
import com.cobbs.lordcraft.Blocks.TEModules.Items.ItemHandlerModule;
import com.cobbs.lordcraft.Entries.TileEntities;
import com.cobbs.lordcraft.UI.IModNamedContainerProvider;
import com.cobbs.lordcraft.Util.Crafting.InitCrafting;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;

public class TransmuterTE
extends ModTileEntity
implements IModNamedContainerProvider {
    private int colour = 0;
    private int index = 0;
    public boolean shifting = false;
    private ECBlockType template = null;
    private int maxIndex = 0;
    private Item cache = null;

    public TransmuterTE() {
        super(TileEntities.BLOCK_TRANSMUTER_TE);
        new ItemHandlerModule((ModTileEntity)this, 2);
    }

    @Override
    public void readSynced(CompoundNBT tag) {
        super.readSynced(tag);
        this.colour = tag.func_74762_e("colour");
        this.index = tag.func_74762_e("index");
        this.shifting = tag.func_74767_n("shifting");
        int val = tag.func_74762_e("template");
        this.template = val == -1 ? null : ECBlockType.values()[tag.func_74762_e("template")];
        this.maxIndex = tag.func_74762_e("max_index");
    }

    @Override
    public CompoundNBT writeSynced(CompoundNBT tag) {
        tag = super.writeSynced(tag);
        tag.func_74768_a("colour", this.colour);
        tag.func_74768_a("index", this.index);
        tag.func_74757_a("shifting", this.shifting);
        tag.func_74768_a("max_index", this.maxIndex);
        if (this.template == null) {
            tag.func_74768_a("template", -1);
        } else {
            tag.func_74768_a("template", this.template.ordinal());
        }
        return tag;
    }

    public void setTemplate(int template) {
        ECBlockType old = this.template;
        if (template == -1) {
            this.template = null;
            this.maxIndex = 0;
        } else {
            this.template = ECBlockType.values()[template];
            this.maxIndex = InitCrafting.transmuterMap.get((Object)this.template).size();
        }
        if (this.template != old) {
            this.index = 0;
            this.cache = null;
        }
    }

    public ECBlockType getTemplate() {
        return this.template;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public void setColour(int value) {
        int old = this.colour;
        this.colour = value < 0 ? 16 : (value > 16 ? 0 : value);
        if (this.colour != old) {
            this.cache = null;
        }
    }

    public int getColour() {
        return this.colour;
    }

    public void setIndex(int value) {
        int old = this.index;
        this.index = value < 0 ? this.maxIndex - 1 : (value >= this.maxIndex ? 0 : value);
        if (this.index != old) {
            this.cache = null;
        }
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public Object[] handleNetworkMessage(String id, String ... data) {
        super.handleNetworkMessage(id, data);
        if (id.equals("-1")) {
            this.setColour(Integer.parseInt(data[0]));
        } else if (id.equals("-2")) {
            this.setIndex(Integer.parseInt(data[0]));
        } else if (id.equals("-3")) {
            this.setTemplate(Integer.parseInt(data[0]));
        } else if (id.equals("-4")) {
            this.shifting = Integer.parseInt(data[0]) == 1;
        }
        return data;
    }

    public Item getOutput() {
        if (this.template == null) {
            return null;
        }
        if (this.cache == null) {
            this.cache = InitCrafting.transmuterMap.get((Object)this.template).get(this.index).get(this.colour);
        }
        return this.cache;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ItemHandlerModule module = this.getModule(ItemHandlerModule.class);
        ItemStack convert = module.getStackInSlot(0);
        if (!convert.func_190926_b()) {
            Item i = convert.func_77973_b();
            boolean templateFound = false;
            for (ECBlockType types : InitCrafting.transmuterMap.keySet()) {
                boolean foundMatch = false;
                List<List<Item>> lists = InitCrafting.transmuterMap.get((Object)types);
                for (List<Item> list : lists) {
                    if (!list.contains(i)) continue;
                    this.setTemplate(types.ordinal());
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) continue;
                templateFound = true;
                break;
            }
            if (!templateFound) {
                this.setTemplate(-1);
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && !convert.func_190926_b() && this.template != null) {
            Item out = this.getOutput();
            module.setStackInSlot(0, new ItemStack((IItemProvider)out, convert.func_190916_E()));
            if (this.shifting) {
                int amt;
                ItemStack inSlot = module.getStackInSlot(0);
                ItemStack outSlot = module.getStackInSlot(1);
                if (outSlot.func_190926_b()) {
                    module.setStackInSlot(1, inSlot);
                    module.setStackInSlot(0, ItemStack.field_190927_a);
                } else if (outSlot.func_77973_b() == inSlot.func_77973_b() && (amt = Math.min(outSlot.func_77976_d() - outSlot.func_190916_E(), inSlot.func_190916_E())) > 0) {
                    inSlot.func_190918_g(amt);
                    outSlot.func_190917_f(amt);
                }
            }
        }
    }

    @Nullable
    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        return new TransmuterContainer(p_createMenu_1_, p_createMenu_2_, this);
    }

    @Override
    public boolean canExtractInvStack(int var1, Direction var3) {
        return var1 == 1;
    }

    @Override
    public boolean canInsertInvStack(int var1, Direction var3) {
        return var1 == 0;
    }
}

