/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Blocks;

import com.cobbs.lordcraft.Blocks.INeedsInitFromStack;
import com.cobbs.lordcraft.Blocks.TEModules.ITickingModule;
import com.cobbs.lordcraft.Blocks.TEModules.Items.ItemHandlerModule;
import com.cobbs.lordcraft.Blocks.TEModules.Items.ItemHandlerWrapper;
import com.cobbs.lordcraft.Blocks.TEModules.Modules;
import com.cobbs.lordcraft.Blocks.TEModules.TEModule;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.NetworkHelper;
import com.cobbs.lordcraft.Util.Helpers.WorldHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class ModTileEntity
extends TileEntity
implements ITickableTileEntity {
    private Map<Class<? extends TEModule>, TEModule> modules = new HashMap<Class<? extends TEModule>, TEModule>();

    public ModTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public void readSynced(CompoundNBT tag) {
        try {
            for (String s : Modules.modules.keySet()) {
                if (!tag.func_74764_b(s)) continue;
                Modules.modules.get(s).getConstructor(ModTileEntity.class, CompoundNBT.class).newInstance(new Object[]{this, tag});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompoundNBT writeSynced(CompoundNBT tag) {
        for (TEModule m : this.modules.values()) {
            m.serialize(tag);
        }
        return tag;
    }

    public Map<Class<? extends TEModule>, TEModule> getModules() {
        return this.modules;
    }

    public boolean hasModule(Class<? extends TEModule> type) {
        return this.modules.containsKey(type);
    }

    public <T> T getModule(Class<? extends T> type) {
        return (T)this.getModules().get(type);
    }

    public void attachModule(TEModule module) {
        this.modules.put(module.getClass(), module);
    }

    public void func_73660_a() {
        for (TEModule t : this.modules.values()) {
            if (!(t instanceof ITickingModule)) continue;
            ((ITickingModule)((Object)t)).onTick();
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        super.func_189518_D_();
        this.writeSynced(this.getTileData());
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.getTileData());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readSynced(pkt.func_148857_g());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound = this.writeSynced(compound);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readSynced(compound);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.equals(cap)) {
            ItemHandlerModule module = this.getModule(ItemHandlerModule.class);
            if (module == null) {
                return LazyOptional.empty();
            }
            return LazyOptional.of(() -> new ItemHandlerWrapper(module, this::canInsertInvStack, this::canExtractInvStack, this::isItemValid, side));
        }
        return super.getCapability(cap, side);
    }

    public boolean canInsertInvStack(int var1, Direction var3) {
        return true;
    }

    public boolean canExtractInvStack(int var1, Direction var3) {
        return true;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public Object[] handleNetworkMessage(String id, String ... data) {
        if (this.field_145850_b.field_72995_K && id.equals("-s")) {
            try {
                ((INeedsInitFromStack)((Object)this)).initFromStack(ItemStack.func_199557_a((CompoundNBT)JsonToNBT.func_180713_a((String)data[0])));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.func_70296_d();
            WorldHelper.updateBlock(this.field_145850_b, this.field_174879_c);
        }
        return data;
    }

    public void handleNetworkMessageServer(String id, String ... data) {
        this.passOn(id, this.handleNetworkMessage(id, data));
    }

    public void passOn(String id, Object ... data) {
        NetworkHelper.dataToDimension(this.field_145850_b, id, ModHelper.flatten(this.field_174879_c), ModHelper.flatten(data));
    }

    public void onInventoryChanged() {
    }
}

