/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Blocks.MulticolouredBlocks;

import com.cobbs.lordcraft.Blocks.BasicBlock;
import com.cobbs.lordcraft.Blocks.IColoredBlock;
import com.cobbs.lordcraft.Blocks.MulticolouredBlocks.ECBlock;
import com.cobbs.lordcraft.Blocks.MulticolouredBlocks.IMultiColouredBlock;
import com.cobbs.lordcraft.Blocks.MulticolouredBlocks.MultiColoredBlockItem;
import com.cobbs.lordcraft.Blocks.MulticolouredBlocks.MultiColouredSlabBlock;
import com.cobbs.lordcraft.Blocks.MulticolouredBlocks.MultiColouredStairBlock;
import com.cobbs.lordcraft.MainClass;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class MultiColoredBlock
extends BasicBlock
implements IColoredBlock,
IMultiColouredBlock {
    private ECBlock ecBlock;
    protected int index;

    public MultiColoredBlock(String block, ECBlock ecBlock, int index) {
        super(block, AbstractBlock.Properties.func_200945_a((Material)ecBlock.material).func_200947_a(ecBlock.sType).func_235838_a_(e -> ecBlock.lightValue).func_200948_a(1.0f, 10000.0f).harvestTool(ecBlock.type).harvestLevel(-1));
        this.index = index;
        this.ecBlock = ecBlock;
        this.ecBlock.blocks.add(this);
    }

    @Override
    public int getColor(BlockState state, IBlockReader blockView, BlockPos pos, int layer) {
        return ColorHelper.colorMultiplier(this.index);
    }

    public static void createColouredBlocks() {
        for (ECBlock b : ECBlock.values()) {
            MultiColoredBlock.createColouredBlocks(b);
        }
    }

    public static void createColouredBlocks(ECBlock block) {
        for (int j = 0; j < 16; ++j) {
            String name = ModHelper.concat(DyeColor.values()[j].func_176762_d(), "_", block.name, "b");
            MultiColoredBlock cBlock = new MultiColoredBlock(name, block, j);
            if (block.slabBlock) {
                String slab = ModHelper.concat(name, "_slab");
                new MultiColouredSlabBlock(block, slab, j);
            }
            if (!block.stairBlock) continue;
            String stair = ModHelper.concat(name, "_stair");
            new MultiColouredStairBlock(cBlock, block, stair, j);
        }
    }

    @Override
    public BlockItem getBlockItem() {
        return new MultiColoredBlockItem(this, new Item.Properties().func_200916_a((ItemGroup)MainClass.tabs[1]));
    }

    public String func_149739_a() {
        return ModHelper.concat("lord.", this.ecBlock.getName());
    }

    @Override
    public int getColorIndex() {
        return this.index;
    }
}

