/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Blocks.MulticolouredBlocks;

import com.cobbs.lordcraft.Blocks.IColoredBlock;
import com.cobbs.lordcraft.Blocks.IModBlock;
import com.cobbs.lordcraft.Blocks.MulticolouredBlocks.ECBlock;
import com.cobbs.lordcraft.Blocks.MulticolouredBlocks.IMultiColouredBlock;
import com.cobbs.lordcraft.Blocks.MulticolouredBlocks.MultiColoredSlabBlockItem;
import com.cobbs.lordcraft.Entries.ModBlocks;
import com.cobbs.lordcraft.MainClass;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MultiColouredSlabBlock
extends SlabBlock
implements IModBlock,
IMultiColouredBlock,
IColoredBlock {
    private int index;
    private ECBlock ecBlock;

    public MultiColouredSlabBlock(ECBlock ecBlock, String name, int index) {
        super(AbstractBlock.Properties.func_200945_a((Material)ecBlock.material).func_200947_a(ecBlock.sType).func_235838_a_(e -> ecBlock.lightValue).func_200948_a(1.0f, 10000.0f).harvestTool(ecBlock.type).harvestLevel(-1));
        this.setRegistryName(new ResourceLocation("lordcraft", name));
        ModBlocks.toRegister.add((Block)this);
        this.index = index;
        this.ecBlock = ecBlock;
    }

    @Override
    public BlockItem getBlockItem() {
        return new MultiColoredSlabBlockItem(this, new Item.Properties().func_200916_a((ItemGroup)MainClass.tabs[1]));
    }

    @Override
    public int getColorIndex() {
        return this.index;
    }

    public String func_149739_a() {
        return ModHelper.concat("sl.", this.ecBlock.getName());
    }

    @Override
    public int getColor(BlockState state, IBlockReader blockView, BlockPos pos, int layer) {
        return ColorHelper.colorMultiplier(this.index);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        Vector3d pos = (Vector3d)builder.func_216024_a(LootParameters.field_237457_g_);
        ItemStack stack = (ItemStack)builder.func_216024_a(LootParameters.field_216289_i);
        return this.getDropStacks(state, (World)builder.func_216018_a(), pos, stack);
    }

    public List<ItemStack> getDropStacks(BlockState state, World worldIn, Vector3d pos, ItemStack stack) {
        return ModHelper.wrap(new ItemStack((IItemProvider)this));
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.overrideHarvest() || super.canHarvestBlock(state, world, pos, player);
    }

    public boolean overrideHarvest() {
        return true;
    }
}

