/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Blocks.Ritual;

import com.cobbs.lordcraft.Blocks.Ritual.Ritual;
import com.cobbs.lordcraft.Blocks.Ritual.Rituals.AirRitual;
import com.cobbs.lordcraft.Blocks.Ritual.Rituals.DarkRitual;
import com.cobbs.lordcraft.Blocks.Ritual.Rituals.DefusionRitual;
import com.cobbs.lordcraft.Blocks.Ritual.Rituals.EarthRitual;
import com.cobbs.lordcraft.Blocks.Ritual.Rituals.FireRitual;
import com.cobbs.lordcraft.Blocks.Ritual.Rituals.FusionRitual;
import com.cobbs.lordcraft.Blocks.Ritual.Rituals.LightRitual;
import com.cobbs.lordcraft.Blocks.Ritual.Rituals.ManaRitual;
import com.cobbs.lordcraft.Blocks.Ritual.Rituals.VoidRitual;
import com.cobbs.lordcraft.Blocks.Ritual.Rituals.WaterRitual;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import java.util.function.Supplier;

public enum ERitual {
    FUSION("fusion", FusionRitual::new),
    DEFUSION("defusion", DefusionRitual::new),
    MANA("mana", ManaRitual::new),
    VOID("void", VoidRitual::new),
    WATER("water", WaterRitual::new, ColorHelper.ELEMENTALCOLOURS[1]),
    EARTH("earth", EarthRitual::new, ColorHelper.ELEMENTALCOLOURS[2]),
    FIRE("fire", FireRitual::new, ColorHelper.ELEMENTALCOLOURS[3]),
    AIR("air", AirRitual::new, ColorHelper.ELEMENTALCOLOURS[4]),
    LIGHT("light", LightRitual::new, ColorHelper.ELEMENTALCOLOURS[5]),
    DARK("dark", DarkRitual::new, ColorHelper.ELEMENTALCOLOURS[6]);

    public Supplier<Ritual> ritual;
    public String name;
    public int activeColor;

    private ERitual(String name, Supplier<Ritual> ritual, int activeColor) {
        this.name = name;
        this.ritual = ritual;
        this.activeColor = activeColor;
    }

    private ERitual(String name, Supplier<Ritual> ritual) {
        this(name, ritual, 0);
    }

    public Ritual getRitual() {
        return Ritual.getRitual(this);
    }

    public static void init() {
        for (ERitual e : ERitual.values()) {
            e.ritual.get();
        }
    }

    public static void init2() {
        for (ERitual e : ERitual.values()) {
            e.getRitual().init2();
        }
    }

    public static ERitual getRitual(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        for (ERitual ritual : ERitual.values()) {
            if (!ritual.name().toLowerCase().equals(name)) continue;
            return ritual;
        }
        return null;
    }
}

