/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Blocks.Ritual;

import com.cobbs.lordcraft.Blocks.ModTileEntity;
import com.cobbs.lordcraft.Blocks.Ritual.ERitual;
import com.cobbs.lordcraft.Blocks.Ritual.Ritual;
import com.cobbs.lordcraft.Blocks.Ritual.RitualRenderObject;
import com.cobbs.lordcraft.Entries.TileEntities;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class RitualTE
extends ModTileEntity {
    public List<ItemStack> stacks;
    public RitualRenderObject ring;
    public RitualRenderObject centre;
    public int stage;
    public int ticks;
    public ERitual ritual;
    public String playerID;
    public boolean running = false;
    public boolean fail = false;

    public RitualTE() {
        super(TileEntities.RITUAL_CIRCLE_TE);
        this.initValues();
    }

    public void initValues() {
        this.ring = new RitualRenderObject();
        this.centre = new RitualRenderObject();
        this.stage = 0;
        this.ticks = 0;
        this.running = false;
        this.fail = false;
        this.ritual = null;
        this.stacks = new LinkedList<ItemStack>();
        this.playerID = "";
    }

    @Override
    public void readSynced(CompoundNBT tag) {
        super.readSynced(tag);
        this.ring.deserialize(tag.func_74775_l("lord:ring"));
        this.centre.deserialize(tag.func_74775_l("lord:centre"));
        this.stage = tag.func_74762_e("lord:stage");
        this.ticks = tag.func_74762_e("lord:ticks");
        this.running = tag.func_74767_n("lord:run");
        this.fail = tag.func_74767_n("lord:fail");
        int val = tag.func_74762_e("lord:ritual");
        this.ritual = val == -1 ? null : ERitual.values()[val];
        this.stacks.clear();
        for (int i = 0; i < tag.func_74762_e("lord:s_size"); ++i) {
            String id = ModHelper.concat("lord:item", i);
            if (!tag.func_74764_b(id)) continue;
            this.stacks.add(ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(id)));
        }
        this.playerID = tag.func_74779_i("lord:player");
    }

    @Override
    public CompoundNBT writeSynced(CompoundNBT tag) {
        tag = super.writeSynced(tag);
        tag.func_218657_a("lord:ring", (INBT)this.ring.serialize());
        tag.func_218657_a("lord:centre", (INBT)this.centre.serialize());
        tag.func_74768_a("lord:stage", this.stage);
        tag.func_74768_a("lord:ticks", this.ticks);
        tag.func_74757_a("lord:run", this.running);
        tag.func_74757_a("lord:fail", this.fail);
        if (this.ritual != null) {
            tag.func_74768_a("lord:ritual", this.ritual.ordinal());
        } else {
            tag.func_74768_a("lord:ritual", -1);
        }
        tag.func_74768_a("lord:s_size", this.stacks.size());
        int i = 0;
        for (ItemStack s : this.stacks) {
            String id = ModHelper.concat("lord:item", i);
            tag.func_218657_a(id, (INBT)s.serializeNBT());
            ++i;
        }
        tag.func_74778_a("lord:player", this.playerID);
        return tag;
    }

    public void setRunning() {
        this.fail = false;
        this.running = true;
        this.ticks = 0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.fail) {
            ++this.ticks;
            if (this.ticks >= 5) {
                this.ticks = 0;
                this.fail = false;
            }
        }
        if (this.running && this.ritual != null) {
            Ritual r = this.ritual.getRitual();
            r.process(this);
        }
    }

    public void markFail() {
        if (!this.running) {
            this.fail = true;
            this.ticks = 0;
            ModHelper.updateBlockFromTE(this);
        }
    }
}

