/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Blocks.TEModules.Items;

import com.cobbs.lordcraft.Blocks.TEModules.Items.IItemHandlerTest;
import com.cobbs.lordcraft.Blocks.TEModules.Items.IItemHandlerTestSlot;
import com.cobbs.lordcraft.Blocks.TEModules.Items.ItemHandlerModule;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemHandlerWrapper
implements IItemHandlerModifiable {
    private ItemHandlerModule module;
    private IItemHandlerTest inputPredicate;
    private IItemHandlerTest outputPredicate;
    private IItemHandlerTestSlot validItemPredicate;
    private Direction dir;
    public static IItemHandlerTestSlot defaultPredicate = (i, s) -> true;

    public ItemHandlerWrapper(ItemHandlerModule module, IItemHandlerTest inputPredicate, IItemHandlerTest outputPredicate, IItemHandlerTestSlot validItemPredicate, Direction dir) {
        this.module = module;
        this.inputPredicate = inputPredicate;
        this.outputPredicate = outputPredicate;
        this.validItemPredicate = validItemPredicate;
        this.dir = dir;
    }

    public ItemHandlerWrapper(ItemHandlerModule module, IItemHandlerTest inputPredicate, IItemHandlerTest outputPredicate, Direction dir) {
        this(module, inputPredicate, outputPredicate, defaultPredicate, dir);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.module.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.module.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.module.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.inputPredicate.test(slot, this.dir) && this.validItemPredicate.test(slot, stack) ? this.module.insertItem(slot, stack, simulate) : stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.outputPredicate.test(slot, this.dir) ? this.module.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.module.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.module.isItemValid(slot, stack);
    }
}

