/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Items;

import com.cobbs.lordcraft.Entries.ModBlocks;
import com.cobbs.lordcraft.Items.Elemental.ElementalItem;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Util.Damage.DamageSourceElemental;
import com.cobbs.lordcraft.Util.EElement;
import com.cobbs.lordcraft.Util.EShadowKey;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.DataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.InputHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import com.cobbs.lordcraft.Util.SpecialWaterTank;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ArtifactItem
extends ElementalItem {
    public static final AxisAlignedBB bb = new AxisAlignedBB(new BlockPos(-16, -16, -16), new BlockPos(16, 16, 16));
    public EElement element;

    public ArtifactItem(String item, EElement element) {
        super(item, element.ordinal() + 1);
        this.element = element;
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        return ColorHelper.WHITE;
    }

    public String func_77658_a() {
        return "lordcraft.artifact";
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!ModHelper.isServerWorld(world)) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (this.element == null) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        switch (this.element) {
            case AIR: {
                if (!DataStorageHelper.hasResearch(player, EResearch.AIR_ARTIFACT)) {
                    ModHelper.missingResearch(player);
                    return ActionResult.func_226250_c_((Object)stack);
                }
                player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187511_aA, SoundCategory.BLOCKS, 1.0f, (ModHelper.rand.nextFloat() - ModHelper.rand.nextFloat()) * 0.2f + 0.2f);
                player.func_70024_g(player.func_70040_Z().field_72450_a * 1.25, player.func_70040_Z().field_72448_b * 1.25, player.func_70040_Z().field_72449_c * 1.25);
                if (player instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
                }
                player.func_184811_cZ().func_185145_a((Item)this, 40);
                break;
            }
            case LIGHT: {
                if (!EShadowKey.ALTERNATE_EFFECT.holdingKey(player)) break;
                if (!DataStorageHelper.hasResearch(player, EResearch.LIGHT_ARTIFACT)) {
                    ModHelper.missingResearch(player);
                    return ActionResult.func_226250_c_((Object)stack);
                }
                player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_191244_bn, SoundCategory.BLOCKS, 1.0f, (ModHelper.rand.nextFloat() - ModHelper.rand.nextFloat()) * 0.2f + 0.2f);
                List list = world.func_217357_a(LivingEntity.class, bb.func_191194_a(player.func_213303_ch()));
                for (LivingEntity e : list) {
                    if (player.equals((Object)e)) continue;
                    e.func_195064_c(new EffectInstance(Effects.field_188423_x, 100, 0));
                }
                player.func_184811_cZ().func_185145_a((Item)this, 40);
                break;
            }
            case DARK: {
                if (!DataStorageHelper.hasResearch(player, EResearch.DARK_ARTIFACT)) {
                    ModHelper.missingResearch(player);
                    return ActionResult.func_226250_c_((Object)stack);
                }
                if (!(player.func_110143_aJ() > 1.0f)) break;
                player.func_70097_a(DamageSource.field_76380_i, player.func_110143_aJ() * 0.25f);
                BlockRayTraceResult r = InputHelper.rayTrace(player, 24.0, 0.0f);
                BlockPos p = r.func_216350_a();
                if (r.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    p = p.func_177972_a(r.func_216354_b());
                }
                player.func_70634_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p());
                player.func_130014_f_().func_184133_a(null, p, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, (ModHelper.rand.nextFloat() - ModHelper.rand.nextFloat()) * 0.2f + 0.2f);
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 60);
                break;
            }
            case WATER: {
                if (!DataStorageHelper.hasResearch(player, EResearch.WATER_ARTIFACT)) {
                    ModHelper.missingResearch(player);
                    return ActionResult.func_226250_c_((Object)stack);
                }
                BlockRayTraceResult result = InputHelper.rayTrace(player, player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e(), 0.0f);
                if (result == null || result.func_216346_c() != RayTraceResult.Type.BLOCK) break;
                if (!FluidUtil.tryPlaceFluid((PlayerEntity)player, (World)world, (Hand)hand, (BlockPos)result.func_216350_a(), (IFluidHandler)new SpecialWaterTank(), (FluidStack)new FluidStack((Fluid)Fluids.field_204546_a, 1000))) {
                    FluidUtil.tryPlaceFluid((PlayerEntity)player, (World)world, (Hand)hand, (BlockPos)result.func_216350_a().func_177972_a(result.func_216354_b()), (IFluidHandler)new SpecialWaterTank(), (FluidStack)new FluidStack((Fluid)Fluids.field_204546_a, 1000));
                }
                SoundHelper.empty_fluid(player, 1.0f);
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 10);
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (this.element == null) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        if (!ModHelper.isServerWorld(world)) {
            return ActionResultType.PASS;
        }
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        Hand hand = context.func_221531_n();
        switch (this.element) {
            case EARTH: {
                String text;
                if (!DataStorageHelper.hasResearch(player, EResearch.EARTH_ARTIFACT)) {
                    ModHelper.missingResearch(player);
                    return ActionResultType.PASS;
                }
                Direction[] dirs = new Direction[2];
                if (facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH)) {
                    dirs[0] = Direction.UP;
                    dirs[1] = Direction.WEST;
                } else if (facing.equals((Object)Direction.WEST) || facing.equals((Object)Direction.EAST)) {
                    dirs[0] = Direction.UP;
                    dirs[1] = Direction.NORTH;
                } else if (facing.equals((Object)Direction.UP) || facing.equals((Object)Direction.DOWN)) {
                    dirs[0] = Direction.NORTH;
                    dirs[1] = Direction.WEST;
                }
                int[] values = new int[]{-1, -1, -1};
                BlockPos[] poses = new BlockPos[]{pos, pos.func_177972_a(dirs[0]), pos.func_177972_a(dirs[1]), pos.func_177972_a(dirs[0].func_176734_d()), pos.func_177972_a(dirs[1].func_176734_d()), pos.func_177972_a(dirs[0]).func_177972_a(dirs[1]), pos.func_177972_a(dirs[0]).func_177972_a(dirs[1].func_176734_d()), pos.func_177972_a(dirs[0].func_176734_d()).func_177972_a(dirs[1]), pos.func_177972_a(dirs[0].func_176734_d()).func_177972_a(dirs[1].func_176734_d())};
                Direction f = facing.func_176734_d();
                for (int i = 0; i < 48; ++i) {
                    int max = poses.length;
                    for (int j = 0; j < max; ++j) {
                        values = ModHelper.earthCheck(values, world.func_180495_p(poses[j].func_177967_a(f, i)));
                    }
                }
                if (values[0] == -1) {
                    text = "lord.earth.no.blocks";
                    player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 0.1f);
                } else {
                    player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 0.1f + 2.0f * (1.0f - (float)values[0] / (float)ModHelper.oreNames.length));
                    StringBuilder b = new StringBuilder();
                    b.append("\u00a7a");
                    b.append(ModHelper.capitaliseFirst(ModHelper.oreNames[values[0]]));
                    if (values[1] != -1) {
                        b.append("\u00a7r, \u00a7e").append(ModHelper.capitaliseFirst(ModHelper.oreNames[values[1]]));
                        if (values[2] != -1) {
                            b.append("\u00a7r, \u00a76").append(ModHelper.capitaliseFirst(ModHelper.oreNames[values[2]]));
                        }
                    }
                    text = b.toString();
                }
                ModHelper.actionBarMessage(player, text);
                break;
            }
            case FIRE: {
                if (!DataStorageHelper.hasResearch(player, EResearch.FIRE_ARTIFACT)) {
                    ModHelper.missingResearch(player);
                    return ActionResultType.PASS;
                }
                boolean canFirePlace = world.func_175623_d(pos.func_177972_a(facing));
                if (!canFirePlace) break;
                player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, (ModHelper.rand.nextFloat() - ModHelper.rand.nextFloat()) * 0.2f + 1.0f);
                world.func_180501_a(pos.func_177972_a(facing), Blocks.field_150480_ab.func_176223_P(), 11);
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
                break;
            }
            case LIGHT: {
                if (EShadowKey.ALTERNATE_EFFECT.holdingKey(player)) break;
                if (!DataStorageHelper.hasResearch(player, EResearch.LIGHT_ARTIFACT)) {
                    ModHelper.missingResearch(player);
                    return ActionResultType.PASS;
                }
                boolean canlightPlace = world.func_175623_d(pos.func_177972_a(facing));
                if (!canlightPlace) break;
                player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, (ModHelper.rand.nextFloat() - ModHelper.rand.nextFloat()) * 0.2f + 1.0f);
                world.func_180501_a(pos.func_177972_a(facing), ModBlocks.RUNIC_LAMP.func_176223_P(), 11);
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        if (this.element == null) {
            return ActionResultType.PASS;
        }
        if (!ModHelper.isServerWorld(player.field_70170_p)) {
            return ActionResultType.PASS;
        }
        switch (this.element) {
            case FIRE: {
                if (!DataStorageHelper.hasResearch(player, EResearch.FIRE_ARTIFACT)) {
                    ModHelper.missingResearch(player);
                    return ActionResultType.PASS;
                }
                Item fireItem = stack.func_77973_b();
                if (!(player.func_184811_cZ().func_185143_a(fireItem, 0.0f) <= 0.0f) || !target.func_70097_a((DamageSource)DamageSourceElemental.FIREDAMAGE.from((Entity)player), 0.0f)) break;
                player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, (ModHelper.rand.nextFloat() - ModHelper.rand.nextFloat()) * 0.2f + 1.0f);
                target.func_70015_d(10);
                player.func_184811_cZ().func_185145_a(fireItem, 20);
            }
        }
        return ActionResultType.PASS;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn != null && entityIn instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityIn;
            if ((isSelected || player.func_184586_b(Hand.OFF_HAND).equals(stack)) && this.element != null) {
                switch (this.element) {
                    case WATER: {
                        if (!DataStorageHelper.hasResearch(player, EResearch.WATER_ARTIFACT)) break;
                        player.func_195064_c(new EffectInstance(Effects.field_76427_o, 240, 0, false, false));
                        break;
                    }
                    case DARK: {
                        if (!DataStorageHelper.hasResearch(player, EResearch.DARK_ARTIFACT)) break;
                        player.func_195064_c(new EffectInstance(Effects.field_76439_r, 240, 0, false, false));
                    }
                }
            }
        }
    }
}

