/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Items.Artifacts;

import com.cobbs.lordcraft.Items.BasicItem;
import com.cobbs.lordcraft.MainClass;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SuperArtifactItem
extends BasicItem {
    public SuperArtifactItem(String name) {
        super(name, new Item.Properties().func_200917_a(1).func_200916_a((ItemGroup)MainClass.tabs[0]));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return SuperArtifactItem.getMaxCharges(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double maxCharge = SuperArtifactItem.getMaxCharges(stack);
        if (maxCharge == 0.0) {
            return 1.0;
        }
        double charge = SuperArtifactItem.getCharges(stack);
        return (maxCharge - charge) / maxCharge;
    }

    public int getMaxCharges() {
        return 0;
    }

    public static int getMaxCharges(ItemStack stack) {
        Item i = stack.func_77973_b();
        if (i instanceof SuperArtifactItem) {
            return ((SuperArtifactItem)i).getMaxCharges();
        }
        return 0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ColorHelper.MAGMITE;
    }

    public static int getCharges(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("lord:charge")) {
            return nbt.func_74762_e("lord:charge");
        }
        return 0;
    }

    public static void setCharges(ItemStack stack, int count) {
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74768_a("lord:charge", count);
        stack.func_77982_d(nbt);
    }

    public static boolean increaseCharge(ItemStack stack) {
        int current = SuperArtifactItem.getCharges(stack);
        if (current < SuperArtifactItem.getMaxCharges(stack)) {
            SuperArtifactItem.setCharges(stack, current + 1);
            return true;
        }
        return false;
    }

    public static boolean decreaseCharge(ItemStack stack) {
        int current = SuperArtifactItem.getCharges(stack);
        if (current > 0) {
            SuperArtifactItem.setCharges(stack, current - 1);
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int charge = SuperArtifactItem.getCharges(stack);
        int maxCharge = this.getMaxCharges();
        tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(I18n.func_135052_a((String)"lordcraft.casting.pip_cost", (Object[])new Object[0]), ": \u00a7b", charge + 1)));
        if (maxCharge > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.artifact.charge"));
            tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.artifact.discharge"));
        }
    }
}

