/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Items.Book;

import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Items.Book.BookContainer;
import com.cobbs.lordcraft.Items.Book.EBookMode;
import com.cobbs.lordcraft.Items.Elemental.ElementalItem;
import com.cobbs.lordcraft.MainClass;
import com.cobbs.lordcraft.Passives.EPassive;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Research.EResearchState;
import com.cobbs.lordcraft.Research.EResearchTab;
import com.cobbs.lordcraft.Research.ResearchInstance;
import com.cobbs.lordcraft.Spells.ESpell;
import com.cobbs.lordcraft.Spells.ESpellFocus;
import com.cobbs.lordcraft.UI.Elements.BookElements.BookMenuButton;
import com.cobbs.lordcraft.UI.Elements.BookElements.HudColorButton;
import com.cobbs.lordcraft.UI.Elements.BookElements.HudConfigButton;
import com.cobbs.lordcraft.UI.Elements.BookElements.LegacyBookMenuButton;
import com.cobbs.lordcraft.UI.Elements.BookElements.LookupButton;
import com.cobbs.lordcraft.UI.Elements.BookElements.LookupTextBox;
import com.cobbs.lordcraft.UI.Elements.BookElements.ObjectiveProgressBar;
import com.cobbs.lordcraft.UI.Elements.BookElements.PassiveButton;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchButton;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchButtonFocus;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchButtonSpell;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchTab;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchingGrid.ResearchingGrid;
import com.cobbs.lordcraft.UI.Elements.Buttons.LegacySelectButton;
import com.cobbs.lordcraft.UI.Elements.Buttons.SheetButton;
import com.cobbs.lordcraft.UI.Elements.Constellation;
import com.cobbs.lordcraft.UI.Elements.ResearchButtonChangeElement;
import com.cobbs.lordcraft.UI.Elements.StandardTextBox;
import com.cobbs.lordcraft.UI.Screens.StandardScreen;
import com.cobbs.lordcraft.Util.Client.ClientData;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.NetworkHelper;
import com.cobbs.lordcraft.Util.Helpers.RenderCore;
import com.cobbs.lordcraft.Util.Helpers.RenderHelper;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class BookScreen
extends StandardScreen<BookContainer> {
    private EBookMode mode = EBookMode.MAIN;
    public EBookMode previous_mode = null;
    public int page = 0;
    public int iterator = 0;
    public boolean iterator_up = false;
    public int textPage = 0;
    public int maxPages = 0;
    private final int linesPPage = 34;
    private static final int mainTxtColor = new Color(160, 80, 0).getRGB();
    private static final int titleTxtColor = new Color(255, 160, 0).getRGB();
    public EResearch target = null;
    public EPassive passiveTarget = null;
    public EResearchTab res_tab = EResearchTab.BASICS;
    public boolean transition = false;
    public int selectedConstellation = -1;
    public int transitionTime = 0;
    public boolean finishedSelectingElement = false;
    public boolean reverse = false;
    public final int maxTransition = 20;
    public ResearchingGrid researchGrid;
    public boolean displaying_objective;
    public static final int maxLookupButtons = 56;
    private LookupTextBox lookupTextBox;
    public int lookupPage = 0;
    public int maxLookupPage = 0;
    public NonNullList<ItemStack> lookupOptions;
    public ItemStack lookupStack = ItemStack.field_190927_a;
    public static ResourceLocation common0 = new ResourceLocation("lordcraft", "textures/gui/common0.png");
    private static ResourceLocation bookTexture = new ResourceLocation("lordcraft", "textures/gui/book.png");
    private static ResourceLocation back = new ResourceLocation("lordcraft", "textures/gui/res_back.png");
    private static ResourceLocation mid = new ResourceLocation("lordcraft", "textures/gui/res_mid.png");
    private static ResourceLocation mid_back = new ResourceLocation("lordcraft", "textures/gui/res_mid_back.png");
    private static ResourceLocation cutout = new ResourceLocation("lordcraft", "textures/gui/book_cutout.png");
    private LegacySelectButton[] legacies = new LegacySelectButton[4];
    private Constellation[] constellations = new Constellation[7];
    public HashMap<EResearch, ResearchButton> resButtons;

    public BookScreen(BookContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, 256, 256);
    }

    @Override
    public void func_231160_c_() {
        int j;
        int i;
        super.func_231160_c_();
        this.lookupOptions = NonNullList.func_191196_a();
        this.resButtons = new HashMap();
        for (i = 0; i < this.legacies.length; ++i) {
            this.legacies[i] = new LegacySelectButton(this, i);
        }
        for (i = 0; i < this.constellations.length; ++i) {
            this.constellations[i] = new Constellation(this, i);
        }
        this.mode = ClientData.lordicData.legacy == -1 ? EBookMode.LEGACY : EBookMode.MAIN;
        new StandardTextBox(this, 11, 3){

            @Override
            public String getText() {
                if (ClientData.lordicData.legacy == -1) {
                    return I18n.func_135052_a((String)"lordcraft.legacy_selection", (Object[])new Object[0]);
                }
                return I18n.func_135052_a((String)"lordcraft.legacy_change", (Object[])new Object[0]);
            }

            @Override
            public boolean canDraw() {
                return super.canDraw() && BookScreen.this.mode == EBookMode.LEGACY;
            }
        };
        new SheetButton(this, 219, 3, 26, 26, 162, 112, 0){

            @Override
            public void onClick(double mouseX, double mouseY, int mouseButton) {
                switch (BookScreen.this.mode) {
                    case RESEARCH: {
                        if (BookScreen.this.transition) break;
                        if (BookScreen.this.selectedConstellation != -1 && (BookScreen.this.isThelos() || BookScreen.this.selectingElement())) {
                            BookScreen.this.setFocusedElement(-1);
                            return;
                        }
                        BookScreen.this.textPage = 0;
                        BookScreen.this.setMode(EBookMode.MAIN);
                        break;
                    }
                    case RESEARCHING: {
                        BookScreen.this.textPage = 0;
                        BookScreen.this.setMode(EBookMode.RESEARCH);
                        break;
                    }
                    case SEARCH: {
                        ((BookScreen)BookScreen.this).lookupTextBox.widget.func_146195_b(false);
                    }
                    case ABILITY: 
                    case LEGACY: {
                        BookScreen.this.textPage = 0;
                        BookScreen.this.setMode(EBookMode.MAIN);
                        break;
                    }
                    default: {
                        BookScreen.this.textPage = 0;
                        BookScreen.this.setMode(BookScreen.this.previous_mode);
                    }
                }
                BookScreen.this.displaying_objective = false;
                SoundHelper.page_turn();
            }

            @Override
            public boolean canDraw() {
                return super.canDraw() && (BookScreen.this.mode == EBookMode.TEXT || BookScreen.this.mode == EBookMode.RESEARCHING || BookScreen.this.mode == EBookMode.SEARCH || BookScreen.this.mode == EBookMode.RESEARCH || BookScreen.this.mode == EBookMode.HUD || BookScreen.this.mode == EBookMode.LEGACY && ClientData.lordicData.legacy != -1 || BookScreen.this.mode == EBookMode.ABILITY);
            }

            @Override
            public List<IReorderingProcessor> getTooltip() {
                return ModHelper.wrap(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.tooltip.back", (Object[])new Object[0]), (Style)Style.field_240709_b_));
            }
        };
        new SheetButton(this, 12, 243, 18, 10, 220, 0, 0){

            @Override
            public void onClick(double mouseX, double mouseY, int mouseButton) {
                BookScreen.this.turnPageBck();
            }

            @Override
            public boolean canDraw() {
                return super.canDraw() && BookScreen.this.mode == EBookMode.TEXT && BookScreen.this.textPage > 0;
            }

            @Override
            public List<IReorderingProcessor> getTooltip() {
                return ModHelper.wrap(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.book_text.last_page", (Object[])new Object[0]), (Style)Style.field_240709_b_));
            }
        };
        new SheetButton(this, 226, 243, 18, 10, 220, 10, 0){

            @Override
            public void onClick(double mouseX, double mouseY, int mouseButton) {
                BookScreen.this.turnPageFwd();
            }

            @Override
            public boolean canDraw() {
                return super.canDraw() && BookScreen.this.mode == EBookMode.TEXT && BookScreen.this.textPage < BookScreen.this.maxPages;
            }

            @Override
            public List<IReorderingProcessor> getTooltip() {
                return ModHelper.wrap(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.book_text.next_page", (Object[])new Object[0]), (Style)Style.field_240709_b_));
            }
        };
        new SheetButton(this, 12, 243, 18, 10, 220, 0, 0){

            @Override
            public void onClick(double mouseX, double mouseY, int mouseButton) {
                BookScreen.this.turnLookupPageBck();
            }

            @Override
            public boolean canDraw() {
                return super.canDraw() && BookScreen.this.mode == EBookMode.SEARCH && BookScreen.this.lookupPage > 0;
            }

            @Override
            public List<IReorderingProcessor> getTooltip() {
                return ModHelper.wrap(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.book_text.last_page", (Object[])new Object[0]), (Style)Style.field_240709_b_));
            }
        };
        new SheetButton(this, 226, 243, 18, 10, 220, 10, 0){

            @Override
            public void onClick(double mouseX, double mouseY, int mouseButton) {
                BookScreen.this.turnLookupPageFwd();
            }

            @Override
            public boolean canDraw() {
                return super.canDraw() && BookScreen.this.mode == EBookMode.SEARCH && BookScreen.this.lookupPage < BookScreen.this.maxLookupPage;
            }

            @Override
            public List<IReorderingProcessor> getTooltip() {
                return ModHelper.wrap(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.book_text.next_page", (Object[])new Object[0]), (Style)Style.field_240709_b_));
            }
        };
        new SheetButton(this, 115, 115, 26, 26, 0, 138, 0){

            @Override
            public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
                super.draw(stack, currentSheet, mouseX, mouseY);
                ItemStack iStack = ItemStack.field_190927_a;
                switch (BookScreen.this.selectedConstellation) {
                    case 0: {
                        iStack = new ItemStack((IItemProvider)ModItems.CRYSTAL_WATER);
                        break;
                    }
                    case 1: {
                        iStack = new ItemStack((IItemProvider)ModItems.CRYSTAL_EARTH);
                        break;
                    }
                    case 2: {
                        iStack = new ItemStack((IItemProvider)ModItems.CRYSTAL_FIRE);
                        break;
                    }
                    case 3: {
                        iStack = new ItemStack((IItemProvider)ModItems.CRYSTAL_AIR);
                        break;
                    }
                    case 4: {
                        iStack = new ItemStack((IItemProvider)ModItems.CRYSTAL_LIGHT);
                        break;
                    }
                    case 5: {
                        iStack = new ItemStack((IItemProvider)ModItems.CRYSTAL_DARK);
                    }
                }
                RenderHelper.renderItemIntoGui(iStack, this.x + 5, this.y + 5);
                return this.setupSpriteSheet();
            }

            @Override
            public void onClick(double mouseX, double mouseY, int mouseButton) {
                NetworkHelper.dataToServer("bse", BookScreen.this.selectedConstellation);
                SoundHelper.sparkle_noise();
            }

            @Override
            public boolean canDraw() {
                return super.canDraw() && ClientData.lordicData.primaryElement == -1 && BookScreen.this.mode == EBookMode.RESEARCH && BookScreen.this.selectingElement() && BookScreen.this.selectedConstellation != -1 && BookScreen.this.finishedSelectingElement && !BookScreen.this.transition;
            }

            @Override
            public List<IReorderingProcessor> getTooltip() {
                Style s = ElementalItem.elementStyles[BookScreen.this.selectedConstellation + 1];
                return ModHelper.wrap(ModHelper.makeProcessor(I18n.func_135052_a((String)"lordcraft.element_selection0", (Object[])new Object[0]), TextFormatting.WHITE, I18n.func_135052_a((String)ModHelper.concat("lordcraft.element.", BookScreen.this.selectedConstellation), (Object[])new Object[0]), s), IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.element_selection1", (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240718_a_(net.minecraft.util.text.Color.func_240745_a_((String)"#00ff00"))), IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.element_selection2", (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240718_a_(net.minecraft.util.text.Color.func_240745_a_((String)"#ff0000"))));
            }
        };
        new BookMenuButton(this, 12, 3, EBookMode.RESEARCH);
        new BookMenuButton(this, 40, 3, EBookMode.ABILITY);
        new LegacyBookMenuButton(this, 68, 3, EBookMode.LEGACY);
        new BookMenuButton(this, 96, 3, EBookMode.SEARCH);
        new BookMenuButton(this, 12, 31, EBookMode.HUD);
        int max = EResearchTab.values().length;
        for (i = 0; i < max; ++i) {
            new ResearchTab(this, 14 + i * 22, 0, EResearchTab.values()[i]);
        }
        this.generateResearchButtons();
        this.researchGrid = new ResearchingGrid(this, 0, 0);
        this.lookupTextBox = new LookupTextBox(this, 11, 3);
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 7; ++j) {
                new LookupButton(this, 12 + 28 * i, 35 + 28 * j, i * 7 + j);
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 7; ++j) {
                new LookupButton(this, 134 + 28 * i, 35 + 28 * j, 28 + (i * 7 + j));
            }
        }
        new ObjectiveProgressBar(this, 132, 30);
        for (i = 0; i < ClientData.lordicData.hud_visibility.length; ++i) {
            new HudConfigButton(this, i);
        }
        new HudColorButton(this);
        this.generatePassiveButtons();
    }

    public void generateResearchButtons() {
        new ResearchButton(this, 115, 89, EResearch.BASICS);
        new ResearchButton(this, 115, 33, EResearch.THELOS);
        new ResearchButtonChangeElement(this, 115, 115, 0, EResearch.WATER);
        new ResearchButtonChangeElement(this, 115, 115, 1, EResearch.EARTH);
        new ResearchButtonChangeElement(this, 115, 115, 2, EResearch.FIRE);
        new ResearchButtonChangeElement(this, 115, 115, 3, EResearch.AIR);
        new ResearchButtonChangeElement(this, 115, 115, 4, EResearch.LIGHT);
        new ResearchButtonChangeElement(this, 115, 115, 5, EResearch.DARK);
        new ResearchButton(this, 115, 87, 6, EResearch.FAST_VOID_CRYSTALS);
        new ResearchButton(this, 115, 115, 6, EResearch.VOID_WORKBENCH);
        new ResearchButtonSpell(this, 115, 143, 6, EResearch.BOLT_SPELL, ESpell.BOLT);
        new ResearchButton(this, 143, 115, 6, EResearch.TRANSLOCATION_MATRIX);
        new ResearchButton(this, 87, 115, 6, EResearch.PLATE_CHANGE);
        new ResearchButton(this, 87, 87, 6, EResearch.PLAYER_INTERFACE);
        new ResearchButton(this, 31, 50, 6, EResearch.WATER_PASSIVE_III);
        new ResearchButton(this, 59, 50, 6, EResearch.EARTH_PASSIVE_III);
        new ResearchButton(this, 87, 50, 6, EResearch.FIRE_PASSIVE_III);
        new ResearchButton(this, 143, 50, 6, EResearch.AIR_PASSIVE_III);
        new ResearchButton(this, 171, 50, 6, EResearch.LIGHT_PASSIVE_III);
        new ResearchButton(this, 199, 50, 6, EResearch.DARK_PASSIVE_III);
        new ResearchButton(this, 115, 141, EResearch.ADVANCED_RESEARCH);
        new ResearchButton(this, 80, 54, EResearch.ARCANE_CHALK);
        new ResearchButton(this, 150, 54, EResearch.ARCANE_BASIN);
        new ResearchButton(this, 176, 80, EResearch.BASIN_CRAFTING1);
        new ResearchButton(this, 54, 80, EResearch.ADVANCED_ARCANE_CHALK);
        new ResearchButton(this, 80, 176, EResearch.LEGACY_I);
        new ResearchButton(this, 54, 202, EResearch.LEGACY_II);
        new ResearchButton(this, 150, 176, EResearch.ARCANE_BOW);
        new ResearchButton(this, 115, 141, EResearch.CRYSTALLIZATION);
        new ResearchButton(this, 89, 89, EResearch.VOID_ENERGY);
        new ResearchButton(this, 61, 89, EResearch.ARCANE_PLATES);
        new ResearchButton(this, 141, 89, EResearch.BLOCK_TRANSMUTATION);
        new ResearchButton(this, 89, 167, EResearch.ARCANE_METAL);
        new ResearchButton(this, 141, 167, EResearch.ARCANE_FABRIC);
        new ResearchButton(this, 115, 193, EResearch.CRYSTAL_TOOLS);
        new ResearchButton(this, 115, 61, EResearch.ARCANE_FURNACE);
        new ResearchButton(this, 89, 41, EResearch.ORE_PROCESSING);
        new ResearchButton(this, 141, 41, EResearch.FOOD_COOKER);
        new ResearchButton(this, 115, 115, EResearch.RITUALS);
        new ResearchButton(this, 115, 87, EResearch.MANA_RITUAL_I);
        new ResearchButton(this, 115, 59, EResearch.MANA_RITUAL_II);
        new ResearchButton(this, 115, 143, EResearch.ARCANE_FORGE);
        new ResearchButton(this, 89, 167, EResearch.FORGE_BASIN_I);
        new ResearchButton(this, 115, 169, EResearch.MANA_INTERFACE);
        new ResearchButton(this, 115, 197, EResearch.VOID_EYE);
        new ResearchButton(this, 115, 141, EResearch.SPELL_CRAFTING);
        new ResearchButton(this, 115, 99, EResearch.WANDS);
        new ResearchButton(this, 87, 113, EResearch.GOLD_CAPS);
        new ResearchButton(this, 87, 85, EResearch.MAGMITE_CAPS);
        new ResearchButton(this, 143, 113, EResearch.COMPLEX_STAFF);
        new ResearchButton(this, 143, 85, EResearch.ULTIMATE_STAFF);
        new ResearchButton(this, 115, 57, EResearch.RUNES);
        new ResearchButton(this, 115, 29, EResearch.ADVANCED_RUNES);
        new ResearchButtonFocus(this, 87, 141, EResearch.FOCUS_PROJECTILE, ESpellFocus.PROJECTILE);
        new ResearchButtonFocus(this, 61, 115, EResearch.FOCUS_TRINITY, ESpellFocus.TRINITY);
        new ResearchButtonFocus(this, 35, 89, EResearch.FOCUS_ARC, ESpellFocus.ARC);
        new ResearchButtonFocus(this, 35, 63, EResearch.FOCUS_SCATTER, ESpellFocus.SCATTER);
        new ResearchButtonFocus(this, 143, 141, EResearch.FOCUS_AOE, ESpellFocus.AOE);
        new ResearchButtonFocus(this, 169, 115, EResearch.FOCUS_CONE, ESpellFocus.CONE);
        new ResearchButtonFocus(this, 195, 89, EResearch.FOCUS_CHANNELING, ESpellFocus.CHANNELING);
        new ResearchButtonFocus(this, 195, 63, EResearch.FOCUS_CASCADE, ESpellFocus.CASCADE);
        new ResearchButtonSpell(this, 89, 89, 0, EResearch.WATER_SPELL_UTIL, ESpell.HEAL);
        new ResearchButtonSpell(this, 141, 89, 0, EResearch.WATER_SPELL_COMBAT, ESpell.FREEZE);
        new ResearchButtonSpell(this, 89, 89, 1, EResearch.EARTH_SPELL_UTIL, ESpell.DIG);
        new ResearchButtonSpell(this, 141, 89, 1, EResearch.EARTH_SPELL_COMBAT, ESpell.GRAVITY_WELL);
        new ResearchButtonSpell(this, 89, 89, 2, EResearch.FIRE_SPELL_UTIL, ESpell.REGEN);
        new ResearchButtonSpell(this, 141, 89, 2, EResearch.FIRE_SPELL_COMBAT, ESpell.FLAME);
        new ResearchButtonSpell(this, 89, 89, 3, EResearch.AIR_SPELL_UTIL, ESpell.IMPULSE);
        new ResearchButtonSpell(this, 141, 89, 3, EResearch.AIR_SPELL_COMBAT, ESpell.LIFT);
        new ResearchButtonSpell(this, 89, 89, 4, EResearch.LIGHT_SPELL_UTIL, ESpell.BLIND);
        new ResearchButtonSpell(this, 141, 89, 4, EResearch.LIGHT_SPELL_COMBAT, ESpell.FLASH);
        new ResearchButtonSpell(this, 89, 89, 5, EResearch.DARK_SPELL_UTIL, ESpell.BLINK);
        new ResearchButtonSpell(this, 141, 89, 5, EResearch.DARK_SPELL_COMBAT, ESpell.DARK_DAMAGE);
        new ResearchButton(this, 115, 141, 0, EResearch.WATER_INFUSION);
        new ResearchButton(this, 115, 141, 1, EResearch.EARTH_INFUSION);
        new ResearchButton(this, 115, 141, 2, EResearch.FIRE_INFUSION);
        new ResearchButton(this, 115, 141, 3, EResearch.AIR_INFUSION);
        new ResearchButton(this, 115, 141, 4, EResearch.LIGHT_INFUSION);
        new ResearchButton(this, 115, 141, 5, EResearch.DARK_INFUSION);
        new ResearchButton(this, 89, 167, 0, EResearch.WATER_ARTIFACT);
        new ResearchButton(this, 89, 167, 1, EResearch.EARTH_ARTIFACT);
        new ResearchButton(this, 89, 167, 2, EResearch.FIRE_ARTIFACT);
        new ResearchButton(this, 89, 167, 3, EResearch.AIR_ARTIFACT);
        new ResearchButton(this, 89, 167, 4, EResearch.LIGHT_ARTIFACT);
        new ResearchButton(this, 89, 167, 5, EResearch.DARK_ARTIFACT);
        new ResearchButton(this, 141, 167, 0, EResearch.WATER_PASSIVE_I);
        new ResearchButton(this, 141, 167, 1, EResearch.EARTH_PASSIVE_I);
        new ResearchButton(this, 141, 167, 2, EResearch.FIRE_PASSIVE_I);
        new ResearchButton(this, 141, 167, 3, EResearch.AIR_PASSIVE_I);
        new ResearchButton(this, 141, 167, 4, EResearch.LIGHT_PASSIVE_I);
        new ResearchButton(this, 141, 167, 5, EResearch.DARK_PASSIVE_I);
        new ResearchButton(this, 141, 195, 0, EResearch.WATER_PASSIVE_II);
        new ResearchButton(this, 141, 195, 1, EResearch.EARTH_PASSIVE_II);
        new ResearchButton(this, 141, 195, 2, EResearch.FIRE_PASSIVE_II);
        new ResearchButton(this, 141, 195, 3, EResearch.AIR_PASSIVE_II);
        new ResearchButton(this, 141, 195, 4, EResearch.LIGHT_PASSIVE_II);
        new ResearchButton(this, 141, 195, 5, EResearch.DARK_PASSIVE_II);
        new ResearchButton(this, 115, 54, 0, EResearch.WATER_MASTERY);
        new ResearchButton(this, 115, 54, 1, EResearch.EARTH_MASTERY);
        new ResearchButton(this, 115, 54, 2, EResearch.FIRE_MASTERY);
        new ResearchButton(this, 115, 54, 3, EResearch.AIR_MASTERY);
        new ResearchButton(this, 115, 54, 4, EResearch.LIGHT_MASTERY);
        new ResearchButton(this, 115, 54, 5, EResearch.DARK_MASTERY);
    }

    public void generatePassiveButtons() {
        new PassiveButton(this, 14, 40, EPassive.AQUA_AFFINITY);
        new PassiveButton(this, 54, 40, EPassive.POWER_FIST);
        new PassiveButton(this, 94, 40, EPassive.FLAME_TOUCH);
        new PassiveButton(this, 136, 40, EPassive.DOUBLE_JUMP);
        new PassiveButton(this, 176, 40, EPassive.HEALTH_BOOST_I);
        new PassiveButton(this, 216, 40, EPassive.DASH);
        new PassiveButton(this, 14, 68, EPassive.WATER_STRIKE);
        new PassiveButton(this, 54, 68, EPassive.SILK_TOUCH);
        new PassiveButton(this, 94, 68, EPassive.AUTO_SMELT);
        new PassiveButton(this, 136, 68, EPassive.FALL_RESIST);
        new PassiveButton(this, 176, 68, EPassive.HEALTH_BOOST_II);
        new PassiveButton(this, 216, 68, EPassive.DOUBLE_DASH);
        new PassiveButton(this, 14, 96, EPassive.BREATH_REGEN);
        new PassiveButton(this, 54, 96, EPassive.FORTUNE);
        new PassiveButton(this, 94, 96, EPassive.FIRE_PROOF);
        new PassiveButton(this, 136, 96, EPassive.FLURRY);
        new PassiveButton(this, 176, 96, EPassive.MENDING);
        new PassiveButton(this, 216, 96, EPassive.INCREASED_REACH);
        new PassiveButton(this, 14, 124, EPassive.FROST_TOUCH);
        new PassiveButton(this, 54, 124, EPassive.FORTUNE_II);
        new PassiveButton(this, 94, 124, EPassive.FLAME_RETALIATION);
        new PassiveButton(this, 136, 124, EPassive.FLURRY_II);
        new PassiveButton(this, 176, 124, EPassive.MANA_REGEN);
        new PassiveButton(this, 216, 124, EPassive.MINING);
    }

    @Override
    public void drawBack(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        this.iterator += this.iterator_up ? 2 : -2;
        if (this.iterator >= 255) {
            this.iterator = 255;
            this.iterator_up = false;
        } else if (this.iterator <= 0) {
            this.iterator = 0;
            this.iterator_up = true;
        }
        switch (this.mode) {
            case SEARCH: 
            case LEGACY: 
            case MAIN: {
                this.drawBook(stack);
                break;
            }
            case TEXT: {
                this.drawBook(stack);
                this.drawText(stack, mouseX, mouseY);
                break;
            }
            case RESEARCH: {
                this.drawResearchPage(stack, mouseX, mouseY);
                break;
            }
            case RESEARCHING: {
                this.drawResearchingPage(stack, mouseX, mouseY);
                break;
            }
            case ABILITY: 
            case HUD: {
                this.drawAbilityPage(stack, mouseX, mouseY);
            }
        }
    }

    public void drawText(MatrixStack stack, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(common0);
        this.func_238474_b_(stack, this.x + 11, this.y + 3, 0, 190, 212, 26);
        switch (this.previous_mode) {
            case LEGACY: {
                this.drawPartialRectScaled(this.x + 14, this.y + 6, 32 * this.page, 32.0f, 32.0f, 32.0f, 20, 20);
                break;
            }
            case RESEARCH: {
                if (this.target == null) break;
                RenderHelper.renderItemIntoGui(this.target.display, this.x + 16, this.y + 8);
                break;
            }
            case ABILITY: {
                if (this.passiveTarget == null) break;
                RenderHelper.renderItemIntoGui(this.passiveTarget.stack, this.x + 16, this.y + 8);
                break;
            }
            case SEARCH: {
                RenderHelper.renderItemIntoGui(this.lookupStack, this.x + 16, this.y + 8);
            }
        }
    }

    public void drawBook(MatrixStack stack) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(bookTexture);
        this.func_238474_b_(stack, this.x, this.y, 0, 0, 256, 256);
    }

    public void drawResearchingPage(MatrixStack stack, int mouseX, int mouseY) {
        this.drawStars(stack, mouseX, mouseY, new float[]{0.5f, 0.5f, 0.5f, 1.0f});
        Minecraft.func_71410_x().func_110434_K().func_110577_a(cutout);
        this.func_238474_b_(stack, this.x, this.y, 0, 0, 256, 256);
    }

    public void drawAbilityPage(MatrixStack stack, int mouseX, int mouseY) {
        this.drawStars(stack, mouseX, mouseY, new float[]{0.75f, 0.75f, 0.75f, 1.0f});
        Minecraft.func_71410_x().func_110434_K().func_110577_a(cutout);
        this.func_238474_b_(stack, this.x, this.y, 0, 0, 256, 256);
    }

    public void drawResearchPage(MatrixStack stack, int mouseX, int mouseY) {
        this.drawStars(stack, mouseX, mouseY, ColorHelper.tabColors[this.res_tab.ordinal()]);
        if (this.res_tab == EResearchTab.ELEMENTAL && this.selectedConstellation != -1) {
            float[] color = Constellation.constellation_colors[this.selectedConstellation];
            float[] star_color = Constellation.constellation_star_colors[this.selectedConstellation];
            RenderCore.color3f((float)color[0], (float)color[1], (float)color[2]);
            if (this.transition) {
                int offX = Constellation.positions[this.selectedConstellation][0];
                int offY = Constellation.positions[this.selectedConstellation][1];
                int finalX = 32;
                int finalY = 32;
                int posX = offX + (finalX - offX) * this.transitionTime / 20;
                int posY = offY + (finalY - offY) * this.transitionTime / 20;
                int sizeFinal = 48 + 144 * this.transitionTime / 20;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Constellation.constellations[this.selectedConstellation]);
                this.drawScaledRect(this.x + posX, this.y + posY, sizeFinal, sizeFinal);
                RenderCore.color3f((float)star_color[0], (float)star_color[1], (float)star_color[2]);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Constellation.constellations_stars[this.selectedConstellation]);
                this.drawScaledRect(this.x + posX, this.y + posY, sizeFinal, sizeFinal);
                if (this.reverse) {
                    --this.transitionTime;
                    if (this.transitionTime <= 0) {
                        this.transition = false;
                        this.finishedSelectingElement = false;
                        this.selectedConstellation = -1;
                    }
                } else {
                    ++this.transitionTime;
                    if (this.transitionTime >= 20) {
                        this.transition = false;
                        this.finishedSelectingElement = true;
                    }
                }
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Constellation.constellations[this.selectedConstellation]);
                this.drawScaledRect(this.x + 32, this.y + 32, 192.0, 192.0);
                RenderCore.color3f((float)star_color[0], (float)star_color[1], (float)star_color[2]);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Constellation.constellations_stars[this.selectedConstellation]);
                this.drawScaledRect(this.x + 32, this.y + 32, 192.0, 192.0);
            }
        }
        this.drawConnectingLines(stack);
        RenderCore.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(cutout);
        this.func_238474_b_(stack, this.x, this.y, 0, 0, 256, 256);
    }

    public void drawStars(MatrixStack stack, int mouseX, int mouseY, float[] backColor) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(back);
        GlStateManager.func_227702_d_((float)backColor[0], (float)backColor[1], (float)backColor[2], (float)1.0f);
        this.func_238474_b_(stack, this.x, this.y, 0, 0, 256, 256);
        int shiftX = mouseX - this.x;
        int shiftY = mouseY - this.y;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(mid_back);
        this.func_238474_b_(stack, this.x + shiftX / 256, this.y + shiftY / 256, 0, 0, 256, 256);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(mid);
        this.func_238474_b_(stack, this.x + shiftX / 128, this.y + shiftY / 128, 0, 0, 256, 256);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawConnectingLines(MatrixStack stack) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(common0);
        for (EResearch research : EResearch.values()) {
            if (!this.resButtons.get((Object)research).canDraw()) continue;
            ResearchInstance rI = research.instance;
            for (EResearch otherR : rI.requirements) {
                if (!this.resButtons.get((Object)otherR).canDraw() || !otherR.showsLinks) continue;
                this.drawLine(stack, research, otherR);
            }
        }
    }

    public void drawLine(MatrixStack stack, EResearch r1, EResearch r2) {
        ResearchButton b1 = this.resButtons.get((Object)r1);
        ResearchButton b2 = this.resButtons.get((Object)r2);
        EResearchState s1 = ClientData.researchData.getState(b1.research);
        EResearchState s2 = ClientData.researchData.getState(b2.research);
        if (s1 == EResearchState.NORMAL) {
            if (s2 == EResearchState.COMPLETE) {
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            } else if (s2 == EResearchState.NORMAL) {
                GlStateManager.func_227702_d_((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f);
            }
        } else if (s1 == EResearchState.COMPLETE) {
            if (s2 == EResearchState.COMPLETE) {
                GlStateManager.func_227702_d_((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            } else if (s2 == EResearchState.NORMAL) {
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            }
        } else if (s1 == EResearchState.REQUIRES) {
            GlStateManager.func_227702_d_((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (s2 == EResearchState.REQUIRES) {
            GlStateManager.func_227702_d_((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (s1 == EResearchState.LOCKED) {
            GlStateManager.func_227702_d_((float)0.5f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else if (s2 == EResearchState.LOCKED) {
            GlStateManager.func_227702_d_((float)0.5f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        RenderHelper.drawLine(this, stack, b1.getX() + 12, b2.getX() + 12, b1.getY() + 12, b2.getY() + 12, this.iterator);
    }

    @Override
    public void drawFront(MatrixStack stack, int mouseX, int mouseY) {
        super.drawFront(stack, mouseX, mouseY);
        switch (this.mode) {
            case TEXT: {
                if (this.previous_mode == EBookMode.RESEARCH) {
                    if (this.target != null) {
                        Minecraft.func_71410_x().field_71466_p.func_238422_b_(stack, IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)this.target.unlocalname(), (Object[])new Object[0]), (Style)Style.field_240709_b_), 38.0f, 12.0f, titleTxtColor);
                    }
                } else if (this.previous_mode == EBookMode.SEARCH) {
                    Minecraft.func_71410_x().field_71466_p.func_238422_b_(stack, IReorderingProcessor.func_242239_a((String)this.lookupStack.func_200301_q().getString(), (Style)Style.field_240709_b_), 38.0f, 12.0f, titleTxtColor);
                } else if (this.previous_mode == EBookMode.ABILITY) {
                    if (this.passiveTarget != null) {
                        Minecraft.func_71410_x().field_71466_p.func_238422_b_(stack, IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)this.passiveTarget.unlocalname(), (Object[])new Object[0]), (Style)Style.field_240709_b_), 38.0f, 12.0f, titleTxtColor);
                    }
                } else {
                    Minecraft.func_71410_x().field_71466_p.func_238422_b_(stack, IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)ModHelper.concat("lordcraft.book_text.", this.previous_mode.name().toLowerCase(), ".", this.page, ".title"), (Object[])new Object[0]), (Style)Style.field_240709_b_), 38.0f, 12.0f, titleTxtColor);
                }
                this.drawTextPages(stack, mouseX, mouseY);
            }
        }
    }

    public void drawTextPages(MatrixStack stack, int mouseX, int mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int useX = 12;
        int useY = 30;
        String text = this.previous_mode == EBookMode.SEARCH ? I18n.func_135052_a((String)ModHelper.concat(this.lookupStack.func_77977_a(), ".book_text"), (Object[])new Object[0]) : (this.displaying_objective ? I18n.func_135052_a((String)ModHelper.concat("lordcraft.book_text.", this.previous_mode.name().toLowerCase(), ".objective.", this.page), (Object[])new Object[0]) : I18n.func_135052_a((String)ModHelper.concat("lordcraft.book_text.", this.previous_mode.name().toLowerCase(), ".", this.page), (Object[])new Object[0]));
        List strings = fontRenderer.func_238425_b_(ITextProperties.func_240652_a_((String)text), 110);
        this.maxPages = strings.size() / 34;
        int pageCount = this.textPage * 34;
        for (int i = 0; i < Math.min(34, strings.size() - pageCount); ++i) {
            fontRenderer.func_238422_b_(stack, (IReorderingProcessor)strings.get(i + pageCount), (float)useX, (float)useY, mainTxtColor);
            fontRenderer.getClass();
            fontRenderer.getClass();
            if ((useY += 9 + 3) + 9 + 3 < 242) continue;
            useY = 30;
            useX += 120;
        }
    }

    public void displayTextPage(int page) {
        this.page = page;
        this.setMode(EBookMode.TEXT);
    }

    public void setFocusedElement(int index) {
        if (index == -1) {
            if (this.selectedConstellation != -1 && this.finishedSelectingElement) {
                this.reverse = true;
                this.finishedSelectingElement = false;
                this.transition = true;
            }
        } else {
            this.reverse = false;
            this.transition = true;
            this.selectedConstellation = index;
            this.transitionTime = 0;
            this.finishedSelectingElement = false;
        }
    }

    public void setMode(EBookMode mode) {
        this.previous_mode = this.mode;
        this.mode = mode;
        if (this.previous_mode == EBookMode.SEARCH) {
            this.lookupTextBox.widget.func_146195_b(false);
        }
        if (this.previous_mode == EBookMode.RESEARCHING && mode != EBookMode.TEXT) {
            this.researchGrid.exit();
            this.target = null;
            return;
        }
        if (mode == EBookMode.RESEARCHING && this.previous_mode != EBookMode.TEXT) {
            this.researchGrid.setup(this.target);
            return;
        }
        if (this.selectingElement() && mode == EBookMode.RESEARCH) {
            this.setResearchTab(EResearchTab.ELEMENTAL);
        }
        if (mode == EBookMode.SEARCH) {
            this.updateSearch();
        }
    }

    public EBookMode getMode() {
        return this.mode;
    }

    public boolean isThelos() {
        return ClientData.lordicData.thelos;
    }

    public boolean selectingElement() {
        return !ClientData.lordicData.hasElement();
    }

    public void setResearchTab(EResearchTab tab) {
        this.res_tab = tab;
        switch (tab) {
            case ELEMENTAL: {
                this.cancelTransition();
                if (ClientData.lordicData.hasElement() && !ClientData.lordicData.thelos) {
                    this.setFocusedElement(ClientData.lordicData.primaryElement);
                    this.transitionTime = 20;
                    this.finishedSelectingElement = true;
                    this.transition = false;
                    break;
                }
                this.setFocusedElement(this.selectedConstellation);
                break;
            }
        }
    }

    public void cancelTransition() {
        this.transition = false;
        this.transitionTime = 0;
        this.finishedSelectingElement = false;
        this.selectedConstellation = -1;
    }

    public void turnPageFwd() {
        int old = this.textPage++;
        if (this.textPage >= this.maxPages) {
            this.textPage = this.maxPages;
        }
        if (this.textPage != old) {
            SoundHelper.page_turn();
        }
    }

    public void turnLookupPageFwd() {
        int old = this.lookupPage++;
        if (this.lookupPage >= this.maxLookupPage) {
            this.lookupPage = this.maxLookupPage;
        }
        if (this.lookupPage != old) {
            SoundHelper.page_turn();
        }
    }

    public void turnPageBck() {
        int old = this.textPage--;
        if (this.textPage < 0) {
            this.textPage = 0;
        }
        if (this.textPage != old) {
            SoundHelper.page_turn();
        }
    }

    public void turnLookupPageBck() {
        int old = this.lookupPage--;
        if (this.lookupPage < 0) {
            this.lookupPage = 0;
        }
        if (this.lookupPage != old) {
            SoundHelper.page_turn();
        }
    }

    @Override
    public boolean func_231043_a_(double mouseX, double mouseY, double direction) {
        switch (this.mode) {
            case TEXT: {
                if (direction > 0.0) {
                    this.turnPageBck();
                } else {
                    this.turnPageFwd();
                }
                return true;
            }
            case SEARCH: {
                if (direction > 0.0) {
                    this.turnLookupPageBck();
                } else {
                    this.turnLookupPageFwd();
                }
                return true;
            }
        }
        return super.func_231043_a_(mouseX, mouseY, direction);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.lookupTextBox.canDraw()) {
            if (this.lookupTextBox.widget.func_231046_a_(keyCode, scanCode, modifiers)) {
                this.updateSearch();
            }
            if (this.lookupTextBox.widget.func_230999_j_()) {
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (this.lookupTextBox.canDraw() && this.lookupTextBox.widget.func_230999_j_()) {
            if (this.lookupTextBox.widget.func_231042_a_(codePoint, modifiers)) {
                this.updateSearch();
            }
            return true;
        }
        return super.func_231042_a_(codePoint, modifiers);
    }

    public void updateSearch() {
        this.lookupPage = 0;
        this.lookupOptions.clear();
        MainClass.tabs[0].func_78018_a(this.lookupOptions);
        this.lookupOptions.removeIf(s -> !s.func_200301_q().getString().toLowerCase().contains(this.lookupTextBox.widget.func_146179_b().toLowerCase()));
        this.maxLookupPage = this.lookupOptions.size() / 56;
    }
}

