/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Items.Elemental;

import com.cobbs.lordcraft.Entries.ModBlocks;
import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Items.BasicItem;
import com.cobbs.lordcraft.Items.Elemental.ElementalItem;
import com.cobbs.lordcraft.LordCraft;
import com.cobbs.lordcraft.Particles.Plate.ParticlePlateData;
import com.cobbs.lordcraft.Util.Helpers.DataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.NetworkHelper;
import com.cobbs.lordcraft.Util.Helpers.WorldHelper;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PlateItem
extends BasicItem {
    protected int index = cIndex++;
    public static List<Item> plates = new LinkedList<Item>();
    public static final String[] plateNames = new String[]{"lord.plate.neutral", "lord.plate.water", "lord.plate.earth", "lord.plate.fire", "lord.plate.air", "lord.plate.light", "lord.plate.dark", "lord.plate.pure"};
    private static int cIndex = 0;
    private static CompoundNBT activeTag = new CompoundNBT();

    public PlateItem(String item) {
        super(item, 1, 0);
        LordCraft.proxy.addPlate(this);
    }

    public String func_77658_a() {
        return "lordcraft.plate";
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new TranslationTextComponent(plateNames[this.index]).func_240702_b_(" ").func_230529_a_(super.func_200295_i(stack)).func_230530_a_(ElementalItem.elementStyles[this.index]);
    }

    public ActionResultType func_195939_a(ItemUseContext p_195939_1_) {
        ItemStack stack = p_195939_1_.func_195996_i();
        World world = p_195939_1_.func_195991_k();
        PlayerEntity player = p_195939_1_.func_195999_j();
        BlockPos pos = p_195939_1_.func_195995_a();
        Direction facing = p_195939_1_.func_196000_l();
        if (ModHelper.isServerWorld(world)) {
            if (this.index == 6 && !PlateItem.hasPosition(stack)) {
                BlockPos p = pos.func_177972_a(facing);
                stack.func_77966_a(Enchantments.field_185309_u, 0);
                PlateItem.applyPosition(stack, world, p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_193781_bp, player.func_184176_by(), 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
            if (this.index == 7 && PlateItem.canChangeBlock(world, pos) && DataStorageHelper.drainPips(player, 1, false)) {
                PlateItem.changeBlock(world, pos);
                this.activateEffect(player);
                stack.func_190918_g(1);
            }
        } else if (this.index == 6) {
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(p_195939_1_);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ModHelper.isServerWorld(world)) {
            int[] position;
            if (this.index == 6 && (position = PlateItem.getPosition(stack)) != null && DataStorageHelper.drainPips(player, 1, false)) {
                player.func_195064_c(new EffectInstance(Effects.field_76429_m, 20, 100));
                player.func_70634_a((double)position[0], (double)position[1], (double)position[2]);
                this.activateEffect(player);
                stack.func_190918_g(1);
            }
            if (this.index == 1 && DataStorageHelper.drainPips(player, 1, false)) {
                player.func_195064_c(new EffectInstance(Effects.field_76432_h, 1, 1));
                player.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
                this.activateEffect(player);
                stack.func_190918_g(1);
            }
            if (this.index == 2 && DataStorageHelper.drainPips(player, 1, false)) {
                player.func_195064_c(new EffectInstance(Effects.field_76429_m, 200, 1));
                this.activateEffect(player);
                stack.func_190918_g(1);
            }
            if (this.index == 4 && DataStorageHelper.drainPips(player, 1, false)) {
                player.func_195064_c(new EffectInstance(Effects.field_76424_c, 400, 1));
                player.func_195064_c(new EffectInstance(Effects.field_76430_j, 400, 1));
                this.activateEffect(player);
                stack.func_190918_g(1);
            }
            if (this.index == 3 && DataStorageHelper.drainPips(player, 1, false)) {
                player.func_195064_c(new EffectInstance(Effects.field_76420_g, 400, 1));
                player.func_195064_c(new EffectInstance(Effects.field_76422_e, 400, 1));
                this.activateEffect(player);
                stack.func_190918_g(1);
            }
            if (this.index == 5 && DataStorageHelper.drainPips(player, 1, false)) {
                player.func_195061_cb();
                this.activateEffect(player);
                stack.func_190918_g(1);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public static void activateEffectClient(PlayerEntity player, int index) {
        World world = player.func_130014_f_();
        Item i = null;
        switch (index) {
            case 0: {
                i = ModItems.PLATE_BASIC;
                break;
            }
            case 1: {
                i = ModItems.PLATE_WATER;
                break;
            }
            case 2: {
                i = ModItems.PLATE_EARTH;
                break;
            }
            case 3: {
                i = ModItems.PLATE_FIRE;
                break;
            }
            case 4: {
                i = ModItems.PLATE_AIR;
                break;
            }
            case 5: {
                i = ModItems.PLATE_LIGHT;
                break;
            }
            case 6: {
                i = ModItems.PLATE_DARK;
                break;
            }
            case 7: {
                i = ModItems.PLATE_PURE;
            }
        }
        ItemStack stk = new ItemStack((IItemProvider)i);
        stk.func_77982_d(activeTag);
        ParticlePlateData data = null;
        switch (index) {
            case 1: {
                data = LordCraft.proxy.healParticleData;
                break;
            }
            case 2: {
                data = LordCraft.proxy.defenceParticleData;
                break;
            }
            case 3: {
                data = LordCraft.proxy.combatParticleData;
                break;
            }
            case 4: {
                data = LordCraft.proxy.agilityParticleData;
                break;
            }
            case 5: {
                data = LordCraft.proxy.purifyParticleData;
                break;
            }
            case 6: {
                data = LordCraft.proxy.teleportParticleData;
                break;
            }
            case 7: {
                data = LordCraft.proxy.changeParticleData;
            }
        }
        Minecraft.func_71410_x().field_71452_i.func_199281_a((Entity)player, (IParticleData)data, 30);
        switch (index) {
            case 5: {
                world.func_184134_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_193782_bq, player.func_184176_by(), 0.25f, 1.0f, false);
                break;
            }
            case 6: {
                world.func_184134_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_191244_bn, player.func_184176_by(), 0.5f, 0.2f, false);
                break;
            }
            default: {
                world.func_184134_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_193781_bp, player.func_184176_by(), 1.0f, 1.0f, false);
            }
        }
        Minecraft.func_71410_x().field_71460_t.func_190565_a(stk);
    }

    public void activateEffect(PlayerEntity player) {
        NetworkHelper.dataToPlayer((ServerPlayerEntity)player, "pa", this.index);
    }

    public static boolean canChangeBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().equals(Blocks.field_150348_b);
    }

    public static void changeBlock(World world, BlockPos pos) {
        world.func_175656_a(pos, ModBlocks.LORDIC_STONE.getBlock().func_176223_P());
        WorldHelper.updateBlock(world, pos);
    }

    public static void applyPosition(ItemStack stack, World world, int x, int y, int z) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("dim", world.func_234923_W_().getRegistryName().toString());
        nbt.func_74768_a("x", x);
        nbt.func_74768_a("y", y);
        nbt.func_74768_a("z", z);
        tag.func_218657_a("lord:pos", (INBT)nbt);
        stack.func_77982_d(tag);
    }

    public static boolean hasPosition(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        return tag.func_74764_b("lord:pos");
    }

    public static int[] getPosition(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("lord:pos")) {
            CompoundNBT nbt = tag.func_74775_l("lord:pos");
            return new int[]{nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")};
        }
        return null;
    }

    public static String getDimension(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("lord:pos")) {
            CompoundNBT nbt = tag.func_74775_l("lord:pos");
            return nbt.func_74779_i("dim");
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag p_77624_4_) {
        super.func_77624_a(stack, world, tooltip, p_77624_4_);
        if (this.index == 6) {
            int[] position = PlateItem.getPosition(stack);
            if (position != null) {
                tooltip.add((ITextComponent)new StringTextComponent("X: " + position[0]));
                tooltip.add((ITextComponent)new StringTextComponent("Y: " + position[1]));
                tooltip.add((ITextComponent)new StringTextComponent("Z: " + position[2]));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("lord.tooltip.teleport_stone"));
            }
        } else if (this.index == 7) {
            tooltip.add((ITextComponent)new TranslationTextComponent("lord.tooltip.change_stone"));
        }
    }

    static {
        activeTag.func_74757_a("active", true);
    }
}

