/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Items.SpellCasting;

import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Items.IColoredItem;
import com.cobbs.lordcraft.Items.SpellCasting.SpellCrystal;
import com.cobbs.lordcraft.MainClass;
import com.cobbs.lordcraft.Spells.ESpellFocus;
import com.cobbs.lordcraft.Spells.SpellContainer;
import com.cobbs.lordcraft.Util.EElement;
import com.cobbs.lordcraft.Util.Entities.SpellArrow;
import com.cobbs.lordcraft.Util.Helpers.ClientDataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ArcaneBow
extends BowItem
implements IColoredItem {
    private TextFormatting formatting;

    public ArcaneBow(String name) {
        super(new Item.Properties().func_200916_a((ItemGroup)MainClass.tabs[0]).func_200917_a(1));
        this.setRegistryName(new ResourceLocation("lordcraft", name));
        ModItems.toRegister.add((Item)this);
        this.formatting = TextFormatting.AQUA;
    }

    public AbstractArrowEntity customArrow(AbstractArrowEntity arrow) {
        Entity e = arrow.func_234616_v_();
        SpellContainer container = null;
        for (ItemStack stack : e.func_184214_aD()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArcaneBow)) continue;
            container = ArcaneBow.getCachedSpell(stack);
            break;
        }
        if (e instanceof LivingEntity) {
            return new SpellArrow(arrow.field_70170_p, (LivingEntity)e, container);
        }
        return new SpellArrow(arrow.field_70170_p, arrow.func_226277_ct_(), arrow.func_226278_cu_(), arrow.func_226281_cx_(), container);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        SpellContainer container = ArcaneBow.getSpell(stack);
        if (container == null && this.attemptFocusLoad(playerIn, stack)) {
            return ActionResult.func_226248_a_((Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static boolean hasSpell(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        return nbt.func_74764_b("has_spell") && nbt.func_74767_n("has_spell");
    }

    public static void setSpell(ItemStack stack, SpellContainer container) {
        CompoundNBT nbt = stack.func_196082_o();
        if (container != null) {
            nbt.func_218657_a("spell", (INBT)container.serialise());
            nbt.func_74757_a("has_spell", true);
        } else {
            nbt.func_74757_a("has_spell", false);
        }
    }

    public static boolean loadSpellFromFocus(ItemStack stack, ItemStack focus) {
        SpellContainer container = SpellCrystal.getSpell(focus);
        if (container == null) {
            return false;
        }
        ArcaneBow.setSpell(stack, container);
        return true;
    }

    public boolean attemptFocusLoad(PlayerEntity playerIn, ItemStack stack) {
        for (ItemStack focus : playerIn.field_71071_by.field_70462_a) {
            if (focus.func_190926_b() || !(focus.func_77973_b() instanceof SpellCrystal) || !ArcaneBow.loadSpellFromFocus(stack, focus)) continue;
            focus.func_190918_g(1);
            return true;
        }
        return false;
    }

    public static SpellContainer getSpell(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("has_spell") && nbt.func_74767_n("has_spell")) {
            return SpellContainer.createFromNbt(nbt.func_74775_l("spell"));
        }
        return null;
    }

    public static SpellContainer getCachedSpell(ItemStack stack) {
        SpellContainer spell = ArcaneBow.getSpell(stack);
        if (spell == null) {
            return null;
        }
        return new SpellContainer("", ESpellFocus.ARROW, spell.spell, 1.0, false, false, false, spell.spellMod, 1.0);
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        SpellContainer cont;
        if (layer == 1 && (cont = ArcaneBow.getSpell(stack)) != null) {
            return cont.spell.getSpell().color.getRGB();
        }
        return ColorHelper.WHITE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_77645_m() {
        return false;
    }

    public ITextComponent func_200295_i(ItemStack p_200295_1_) {
        String s = super.func_200295_i(p_200295_1_).getString();
        StringTextComponent comp = new StringTextComponent(s);
        comp.func_230530_a_(Style.field_240709_b_.func_240712_a_(this.formatting));
        return comp;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        SpellContainer container = ArcaneBow.getCachedSpell(stack);
        if (container == null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.equip_focus"));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(I18n.func_135052_a((String)"lordcraft.casting.mana_cost", (Object[])new Object[0]), ": \u00a7b", ClientDataStorageHelper.getManaCost(container.manaCost(), container.spell.element))));
            if (Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_type", (Object[])new Object[0]), ": ", EElement.getTextColor(container.spell.element), I18n.func_135052_a((String)container.spell.getUnlocalName(), (Object[])new Object[0]))));
                if (container.spell.element != null) {
                    tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_element", (Object[])new Object[0]), ": ", container.spell.element.getTextColor(), I18n.func_135052_a((String)container.spell.element.getUnlocalName(), (Object[])new Object[0]))));
                }
                if (container.spellMod) {
                    tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_modifier", (Object[])new Object[0]), ": ", I18n.func_135052_a((String)container.spell.getSpell().getModifierName(), (Object[])new Object[0]))));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.spell.adv_tooltip"));
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.remove_focus"));
        }
    }
}

