/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Items.SpellCasting;

import com.cobbs.lordcraft.Items.BasicItem;
import com.cobbs.lordcraft.Items.IColoredItem;
import com.cobbs.lordcraft.Items.SpellCasting.RuneItem;
import com.cobbs.lordcraft.Items.SpellCasting.StaffItem;
import com.cobbs.lordcraft.Items.SpellCasting.WandItem;
import com.cobbs.lordcraft.LordCraft;
import com.cobbs.lordcraft.MainClass;
import com.cobbs.lordcraft.Spells.ESpellFocus;
import com.cobbs.lordcraft.Spells.SpellContainer;
import com.cobbs.lordcraft.Util.EElement;
import com.cobbs.lordcraft.Util.Helpers.ClientDataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class CastingTool
extends BasicItem
implements IColoredItem {
    public static final Supplier<Item.Properties>[] propSupplier = new Supplier[]{() -> new Item.Properties().func_200917_a(1), () -> new Item.Properties().func_200917_a(1).func_200916_a((ItemGroup)MainClass.tabs[0])};

    public CastingTool(String item) {
        super(item, 1, 0);
    }

    public CastingTool(String item, int val) {
        super(item, propSupplier[val].get());
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        Direction dir = context.func_196000_l();
        Hand h = context.func_221531_n();
        if (ModHelper.isPlayerReal(player)) {
            SpellContainer container;
            if (this.needsTwoHands()) {
                Hand otherH;
                switch (h) {
                    case OFF_HAND: {
                        otherH = Hand.MAIN_HAND;
                        break;
                    }
                    default: {
                        otherH = Hand.OFF_HAND;
                    }
                }
                ItemStack stack2 = player.func_184586_b(otherH);
                if (!stack2.func_190926_b()) {
                    ModHelper.twoHandsNeeded(player);
                    return super.func_195939_a(context);
                }
            }
            if ((container = CastingTool.getSpell(context.func_195996_i())) != null) {
                container.blockCast(player, pos, dir, this.isWand(), this.isPips(), this.getRodLevel());
            }
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (ModHelper.isPlayerReal(playerIn)) {
            SpellContainer container;
            if (this.needsTwoHands()) {
                Hand otherH;
                switch (handIn) {
                    case OFF_HAND: {
                        otherH = Hand.MAIN_HAND;
                        break;
                    }
                    default: {
                        otherH = Hand.OFF_HAND;
                    }
                }
                ItemStack stack2 = playerIn.func_184586_b(otherH);
                if (!stack2.func_190926_b()) {
                    ModHelper.twoHandsNeeded(playerIn);
                    return super.func_77659_a(worldIn, playerIn, handIn);
                }
            }
            if ((container = CastingTool.getSpell(stack)) != null) {
                if (container.focus == ESpellFocus.CHANNELING || container.charging) {
                    if (ModHelper.isServerWorld(worldIn) && container.canCast(playerIn, this.isPips())) {
                        playerIn.func_184598_c(handIn);
                        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
                    }
                } else {
                    container.airCast(playerIn, this.isWand(), this.isPips(), this.getRodLevel());
                }
            } else {
                this.attemptFocusLoad(playerIn, stack);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean isWand() {
        return false;
    }

    public boolean needsTwoHands() {
        return false;
    }

    public int getRodLevel() {
        return 3;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        SpellContainer container;
        super.onUsingTick(stack, player, count);
        if (count % 2 == 0 && (container = CastingTool.getSpell(stack)) != null) {
            if (container.focus == ESpellFocus.CHANNELING) {
                if (ModHelper.isServerWorld(player.field_70170_p)) {
                    container.airCast((PlayerEntity)player, this.isWand(), this.isPips(), this.getRodLevel());
                }
            } else if (container.charging) {
                LordCraft.proxy.addCharge(1);
            }
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        SpellContainer container = CastingTool.getSpell(stack);
        if (container != null && container.charging) {
            container.airCast((PlayerEntity)entityLiving, Math.min(72000 - timeLeft, 50), this.isWand(), this.isPips(), this.getRodLevel());
            LordCraft.proxy.resetCharge();
        }
    }

    public int func_77626_a(ItemStack stack) {
        SpellContainer s = CastingTool.getSpell(stack);
        if (s != null && (s.focus == ESpellFocus.CHANNELING || s.charging)) {
            return 72000;
        }
        return 0;
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (ModHelper.isPlayerReal(playerIn)) {
            SpellContainer container;
            if (this.needsTwoHands()) {
                Hand otherH;
                switch (hand) {
                    case OFF_HAND: {
                        otherH = Hand.MAIN_HAND;
                        break;
                    }
                    default: {
                        otherH = Hand.OFF_HAND;
                    }
                }
                ItemStack stack2 = playerIn.func_184586_b(otherH);
                if (!stack2.func_190926_b()) {
                    ModHelper.twoHandsNeeded(playerIn);
                    return super.func_111207_a(stack, playerIn, target, hand);
                }
            }
            if ((container = CastingTool.getSpell(stack)) != null) {
                container.entityCast(playerIn, target, this.isWand(), this.isPips(), this.getRodLevel());
            }
        }
        return super.func_111207_a(stack, playerIn, target, hand);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged || newStack.func_190926_b()) {
            LordCraft.proxy.resetCharge();
        } else {
            SpellContainer container = CastingTool.getSpell(newStack);
            if (container == null || !container.charging) {
                LordCraft.proxy.resetCharge();
            }
        }
        return false;
    }

    public static void setSpell(ItemStack stack, SpellContainer container) {
        Item i = stack.func_77973_b();
        if (i instanceof RuneItem) {
            int index = RuneItem.getIndex(stack);
            RuneItem.setSpell(stack, index, container);
        } else if (i instanceof StaffItem) {
            StaffItem.setSpell(stack, container);
        } else if (i instanceof WandItem) {
            WandItem.setSpell(stack, container);
        }
    }

    public static SpellContainer getSpell(ItemStack stack) {
        Item i = stack.func_77973_b();
        if (i instanceof RuneItem) {
            int index = RuneItem.getIndex(stack);
            return RuneItem.getSpell(stack, index);
        }
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("has_spell") && nbt.func_74767_n("has_spell")) {
            return SpellContainer.createFromNbt(nbt.func_74775_l("spell"));
        }
        return null;
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        SpellContainer cont = CastingTool.getSpell(stack);
        if (cont != null) {
            return cont.getSpell().color.getRGB();
        }
        return ColorHelper.WHITE;
    }

    public abstract boolean attemptFocusLoad(PlayerEntity var1, ItemStack var2);

    public boolean isPips() {
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        SpellContainer container = CastingTool.getSpell(stack);
        if (container == null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.equip_focus"));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(I18n.func_135052_a((String)"lordcraft.casting.spell", (Object[])new Object[0]), ": \u00a75", container.name)));
            if (this.isPips()) {
                tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(I18n.func_135052_a((String)"lordcraft.casting.pip_cost", (Object[])new Object[0]), ": \u00a7b", container.pipCost())));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(I18n.func_135052_a((String)"lordcraft.casting.mana_cost", (Object[])new Object[0]), ": \u00a7b", ClientDataStorageHelper.getManaCost(container.manaCost(), container.spell.element))));
            }
            if (Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_focus", (Object[])new Object[0]), ": \u00a75", I18n.func_135052_a((String)container.focus.getUnlocalName(), (Object[])new Object[0]))));
                tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_type", (Object[])new Object[0]), ": ", EElement.getTextColor(container.spell.element), I18n.func_135052_a((String)container.spell.getUnlocalName(), (Object[])new Object[0]))));
                if (container.spell.element != null) {
                    tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_element", (Object[])new Object[0]), ": ", container.spell.element.getTextColor(), I18n.func_135052_a((String)container.spell.element.getUnlocalName(), (Object[])new Object[0]))));
                }
                if (container.spellMod) {
                    tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_modifier", (Object[])new Object[0]), ": ", I18n.func_135052_a((String)container.spell.getSpell().getModifierName(), (Object[])new Object[0]))));
                }
                if (container.modifier) {
                    tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_modifier", (Object[])new Object[0]), ": ", I18n.func_135052_a((String)container.focus.getFocus().getModifierName(), (Object[])new Object[0]))));
                }
                if (container.charging) {
                    tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_charging", (Object[])new Object[0]))));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.spell.adv_tooltip"));
            }
        }
    }
}

