/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Items.SpellCasting;

import com.cobbs.lordcraft.Items.SpellCasting.CastingTool;
import com.cobbs.lordcraft.Items.SpellCasting.SpellCrystal;
import com.cobbs.lordcraft.Spells.SpellContainer;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class RuneItem
extends CastingTool {
    private int maxIndex;
    private static final String[] indexHas = new String[]{"has_spell_0", "has_spell_1", "has_spell_2", "has_spell_3", "has_spell_4", "has_spell_5"};
    private static final String[] indexSpell = new String[]{"spell_0", "spell_1", "spell_2", "spell_3", "spell_4", "spell_5"};

    public RuneItem(String item, int maxIndex) {
        super(item);
        this.maxIndex = maxIndex;
    }

    public static boolean hasSpell(ItemStack stack, int index) {
        CompoundNBT nbt = stack.func_196082_o();
        return nbt.func_74764_b(indexHas[index]) && nbt.func_74767_n(indexHas[index]);
    }

    public static void setSpell(ItemStack stack, int index, SpellContainer container) {
        CompoundNBT nbt = stack.func_196082_o();
        if (container != null) {
            nbt.func_218657_a(indexSpell[index], (INBT)container.serialise());
            nbt.func_74757_a(indexHas[index], true);
        } else {
            nbt.func_74757_a(indexHas[index], false);
        }
        stack.func_77982_d(nbt);
    }

    public static int getIndex(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("index")) {
            return nbt.func_74762_e("index");
        }
        return 0;
    }

    public static void nextIndex(ItemStack stack) {
        RuneItem.setIndex(stack, RuneItem.getIndex(stack) + 1);
    }

    public static void prevIndex(ItemStack stack) {
        RuneItem.setIndex(stack, RuneItem.getIndex(stack) - 1);
    }

    public static void setIndex(ItemStack stack, int index) {
        CompoundNBT nbt = stack.func_196082_o();
        int maxIndex = ((RuneItem)stack.func_77973_b()).maxIndex;
        if (index >= maxIndex) {
            index = 0;
        } else if (index < 0) {
            index = maxIndex - 1;
        }
        nbt.func_74768_a("index", index);
        stack.func_77982_d(nbt);
    }

    public static SpellContainer getSpell(ItemStack stack, int index) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b(indexHas[index]) && nbt.func_74767_n(indexHas[index])) {
            return SpellContainer.createFromNbt(nbt.func_74775_l(indexSpell[index]));
        }
        return null;
    }

    public static boolean loadSpellFromFocus(ItemStack stack, ItemStack focus, int index) {
        SpellContainer container = SpellCrystal.getSpell(focus);
        if (container == null) {
            return false;
        }
        RuneItem.setSpell(stack, index, container);
        return true;
    }

    @Override
    public boolean attemptFocusLoad(PlayerEntity playerIn, ItemStack stack) {
        int index = RuneItem.getIndex(stack);
        for (ItemStack focus : playerIn.field_71071_by.field_70462_a) {
            if (focus.func_190926_b() || !(focus.func_77973_b() instanceof SpellCrystal) || !RuneItem.loadSpellFromFocus(stack, focus, index)) continue;
            focus.func_190918_g(1);
            return true;
        }
        return false;
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        if (layer < this.maxIndex) {
            SpellContainer container = RuneItem.getSpell(stack, layer);
            if (container == null) {
                if (this.maxIndex == 3) {
                    return ColorHelper.RUNE_CRYSTAL_BASIC;
                }
                return ColorHelper.RUNE_CRYSTAL_ADVANCED;
            }
            return container.getSpell().color.getRGB();
        }
        if (layer - this.maxIndex == RuneItem.getIndex(stack)) {
            if (this.maxIndex == 3) {
                return ColorHelper.RUNE_CRYSTAL_SELECT_BASIC;
            }
            return ColorHelper.RUNE_CRYSTAL_SELECT_ADVANCED;
        }
        if (this.maxIndex == 3) {
            return ColorHelper.RUNE_CRYSTAL_BASIC;
        }
        return ColorHelper.RUNE_CRYSTAL_ADVANCED;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        SpellContainer container = RuneItem.getSpell(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.switch_focus"));
        if (container != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.remove_focus_rune"));
        }
    }
}

