/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Items.SpellCasting;

import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Items.BasicItem;
import com.cobbs.lordcraft.Items.IColoredItem;
import com.cobbs.lordcraft.Spells.SpellContainer;
import com.cobbs.lordcraft.Util.EElement;
import com.cobbs.lordcraft.Util.Helpers.ClientDataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SpellCrystal
extends BasicItem
implements IColoredItem {
    public SpellCrystal(String item) {
        super(item, 1, 0);
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        SpellContainer cont = SpellCrystal.getSpell(stack);
        if (cont == null) {
            return ColorHelper.WHITE;
        }
        return cont.spell.getSpell().color.getRGB();
    }

    public static boolean hasSpell(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        return nbt.func_186855_b("has_spell") && nbt.func_74767_n("has_spell");
    }

    public static void setSpell(ItemStack stack, SpellContainer container) {
        CompoundNBT nbt = stack.func_196082_o();
        if (container != null) {
            nbt.func_218657_a("spell", (INBT)container.serialise());
            nbt.func_74757_a("has_spell", true);
        } else {
            nbt.func_74757_a("has_spell", false);
        }
        stack.func_77982_d(nbt);
    }

    public static SpellContainer getSpell(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b("has_spell") && nbt.func_74767_n("has_spell")) {
            return SpellContainer.createFromNbt(nbt.func_74775_l("spell"));
        }
        return null;
    }

    public static ItemStack getCrystalWithSpell(SpellContainer container) {
        ItemStack toReturn = new ItemStack((IItemProvider)ModItems.SPELL_CRYSTAL);
        SpellCrystal.setSpell(toReturn, container);
        return toReturn;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        SpellContainer container = SpellCrystal.getSpell(stack);
        if (container == null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.blank_focus"));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(I18n.func_135052_a((String)"lordcraft.casting.spell", (Object[])new Object[0]), ": \u00a75", container.name)));
            tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(I18n.func_135052_a((String)"lordcraft.casting.mana_cost", (Object[])new Object[0]), ": \u00a7b", ClientDataStorageHelper.getManaCost(container.manaCost(), container.spell.element))));
            tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(I18n.func_135052_a((String)"lordcraft.casting.pip_cost", (Object[])new Object[0]), ": \u00a7b", container.pipCost())));
            if (Screen.func_231173_s_()) {
                tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_focus", (Object[])new Object[0]), ": \u00a75", I18n.func_135052_a((String)container.focus.getUnlocalName(), (Object[])new Object[0]))));
                tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_type", (Object[])new Object[0]), ": ", EElement.getTextColor(container.spell.element), I18n.func_135052_a((String)container.spell.getUnlocalName(), (Object[])new Object[0]))));
                if (container.spell.element != null) {
                    tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_element", (Object[])new Object[0]), ": ", container.spell.element.getTextColor(), I18n.func_135052_a((String)container.spell.element.getUnlocalName(), (Object[])new Object[0]))));
                }
                if (container.spellMod) {
                    tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_modifier", (Object[])new Object[0]), ": ", I18n.func_135052_a((String)container.spell.getSpell().getModifierName(), (Object[])new Object[0]))));
                }
                if (container.modifier) {
                    tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_modifier", (Object[])new Object[0]), ": ", I18n.func_135052_a((String)container.focus.getFocus().getModifierName(), (Object[])new Object[0]))));
                }
                if (container.charging) {
                    tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(" - ", I18n.func_135052_a((String)"lordcraft.spell.tooltip_charging", (Object[])new Object[0]))));
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.spell.adv_tooltip"));
            }
        }
    }
}

