/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Items.SpellCasting;

import com.cobbs.lordcraft.Items.SpellCasting.CastingTool;
import com.cobbs.lordcraft.Items.SpellCasting.IStaff;
import com.cobbs.lordcraft.Items.SpellCasting.SpellCrystal;
import com.cobbs.lordcraft.Items.SpellCasting.StaffItem;
import com.cobbs.lordcraft.LordCraft;
import com.cobbs.lordcraft.Spells.SpellContainer;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.EObjective;
import com.cobbs.lordcraft.Util.Helpers.DataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class WandItem
extends CastingTool
implements IStaff {
    public int wood;
    public int claw;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public WandItem(String item, int wood, int claw) {
        super(item, wood == 1 && claw == 1 ? 1 : 0);
        this.wood = wood;
        this.claw = claw;
        LordCraft.proxy.addStaff(this);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)(claw * 2), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.2, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    @Override
    public int getRodLevel() {
        return this.wood;
    }

    @Override
    public boolean isWand() {
        return true;
    }

    @Override
    public boolean attemptFocusLoad(PlayerEntity playerIn, ItemStack stack) {
        for (ItemStack focus : playerIn.field_71071_by.field_70462_a) {
            if (focus.func_190926_b() || !(focus.func_77973_b() instanceof SpellCrystal) || !StaffItem.loadSpellFromFocus(stack, focus)) continue;
            focus.func_190918_g(1);
            return true;
        }
        return false;
    }

    public static boolean hasSpell(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        return nbt.func_74764_b("has_spell") && nbt.func_74767_n("has_spell");
    }

    public static void setSpell(ItemStack stack, SpellContainer container) {
        CompoundNBT nbt = stack.func_196082_o();
        if (container != null) {
            nbt.func_218657_a("spell", (INBT)container.serialise());
            nbt.func_74757_a("has_spell", true);
        } else {
            nbt.func_74757_a("has_spell", false);
        }
        stack.func_77982_d(nbt);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        SpellContainer container = WandItem.getSpell(stack);
        if (container != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.remove_focus"));
        }
        if (this.wood < 3) {
            tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.casting.max_cost").func_240702_b_(": ").func_240702_b_("" + this.wood * 2000));
        }
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker != null && ModHelper.isServerWorld(attacker.field_70170_p) && attacker instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)attacker;
            DataStorageHelper.incrementObjective(player, EObjective.HIT_MOBS_FOR_GOLD);
            if (this.claw > 1) {
                DataStorageHelper.incrementObjective(player, EObjective.HIT_MOBS_FOR_MAGMITE);
            }
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.func_111205_h(equipmentSlot);
    }
}

