/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Items.Tools;

import com.cobbs.lordcraft.Entries.ModBlocks;
import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Items.IColoredItem;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Util.Damage.DamageSourceElemental;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.EObjective;
import com.cobbs.lordcraft.Util.EElement;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.DataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.InputHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import com.cobbs.lordcraft.Util.SpecialWaterTank;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface IElementalTool
extends IColoredItem {
    public static final IItemTier standardTier = new IItemTier(){

        public int func_200926_a() {
            return 500;
        }

        public float func_200928_b() {
            return 6.0f;
        }

        public float func_200929_c() {
            return 2.0f;
        }

        public int func_200925_d() {
            return 2;
        }

        public int func_200927_e() {
            return 16;
        }

        public Ingredient func_200924_f() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.CRYSTAL_BASIC});
        }
    };
    public static final IItemTier waterElementTier = new IItemTier(){

        public int func_200926_a() {
            return 750;
        }

        public float func_200928_b() {
            return 8.0f;
        }

        public float func_200929_c() {
            return 3.0f;
        }

        public int func_200925_d() {
            return 3;
        }

        public int func_200927_e() {
            return 20;
        }

        public Ingredient func_200924_f() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.CRYSTAL_WATER});
        }
    };
    public static final IItemTier earthElementTier = new IItemTier(){

        public int func_200926_a() {
            return 750;
        }

        public float func_200928_b() {
            return 8.0f;
        }

        public float func_200929_c() {
            return 3.0f;
        }

        public int func_200925_d() {
            return 3;
        }

        public int func_200927_e() {
            return 20;
        }

        public Ingredient func_200924_f() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.CRYSTAL_EARTH});
        }
    };
    public static final IItemTier fireElementTier = new IItemTier(){

        public int func_200926_a() {
            return 750;
        }

        public float func_200928_b() {
            return 8.0f;
        }

        public float func_200929_c() {
            return 3.0f;
        }

        public int func_200925_d() {
            return 3;
        }

        public int func_200927_e() {
            return 20;
        }

        public Ingredient func_200924_f() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.CRYSTAL_FIRE});
        }
    };
    public static final IItemTier airElementTier = new IItemTier(){

        public int func_200926_a() {
            return 750;
        }

        public float func_200928_b() {
            return 8.0f;
        }

        public float func_200929_c() {
            return 3.0f;
        }

        public int func_200925_d() {
            return 3;
        }

        public int func_200927_e() {
            return 20;
        }

        public Ingredient func_200924_f() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.CRYSTAL_AIR});
        }
    };
    public static final IItemTier lightElementTier = new IItemTier(){

        public int func_200926_a() {
            return 750;
        }

        public float func_200928_b() {
            return 8.0f;
        }

        public float func_200929_c() {
            return 3.0f;
        }

        public int func_200925_d() {
            return 3;
        }

        public int func_200927_e() {
            return 20;
        }

        public Ingredient func_200924_f() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.CRYSTAL_LIGHT});
        }
    };
    public static final IItemTier darkElementTier = new IItemTier(){

        public int func_200926_a() {
            return 750;
        }

        public float func_200928_b() {
            return 8.0f;
        }

        public float func_200929_c() {
            return 3.0f;
        }

        public int func_200925_d() {
            return 3;
        }

        public int func_200927_e() {
            return 20;
        }

        public Ingredient func_200924_f() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.CRYSTAL_DARK});
        }
    };
    public static final IItemTier pureElementTier = new IItemTier(){

        public int func_200926_a() {
            return 4000;
        }

        public float func_200928_b() {
            return 16.0f;
        }

        public float func_200929_c() {
            return 8.0f;
        }

        public int func_200925_d() {
            return 4;
        }

        public int func_200927_e() {
            return 30;
        }

        public Ingredient func_200924_f() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.CRYSTAL_PURE});
        }
    };
    public static final IItemTier magmiteTier = new IItemTier(){

        public int func_200926_a() {
            return 2000;
        }

        public float func_200928_b() {
            return 12.0f;
        }

        public float func_200929_c() {
            return 5.0f;
        }

        public int func_200925_d() {
            return 4;
        }

        public int func_200927_e() {
            return 24;
        }

        public Ingredient func_200924_f() {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.MAGMITE});
        }
    };

    public EElement getElement();

    public static IItemTier getTier(EElement element) {
        if (element == null) {
            return standardTier;
        }
        switch (element) {
            case WATER: {
                return waterElementTier;
            }
            case EARTH: {
                return earthElementTier;
            }
            case FIRE: {
                return fireElementTier;
            }
            case AIR: {
                return airElementTier;
            }
            case LIGHT: {
                return lightElementTier;
            }
            case DARK: {
                return darkElementTier;
            }
            case ENERGY: {
                return pureElementTier;
            }
        }
        return standardTier;
    }

    @Override
    default public int getColor(ItemStack stack, int layer) {
        if (layer == 0) {
            EElement element = this.getElement();
            int index = element == null ? 0 : element.ordinal() + 1;
            return ColorHelper.ELEMENTALCOLOURS[index];
        }
        return ColorHelper.WHITE;
    }

    public static ActionResult<ItemStack> onItemRightClick(World world, PlayerEntity player, Hand hand, EElement element) {
        ItemStack stack = player.func_184586_b(hand);
        if (!ModHelper.isServerWorld(world)) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (element == null) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (!DataStorageHelper.hasResearch(player, EResearch.CRYSTAL_TOOLS)) {
            ModHelper.missingResearch(player);
            return ActionResult.func_226250_c_((Object)stack);
        }
        switch (element) {
            case DARK: {
                if (!(player.func_110143_aJ() > 1.0f)) break;
                player.func_70097_a(DamageSource.field_76380_i, player.func_110143_aJ() * 0.5f);
                BlockRayTraceResult r = InputHelper.rayTrace(player, 8.0, 0.0f);
                BlockPos p = r.func_216350_a();
                if (r.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    p = p.func_177972_a(r.func_216354_b());
                }
                player.func_70634_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p());
                player.func_130014_f_().func_184133_a(null, p, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, (ModHelper.rand.nextFloat() - ModHelper.rand.nextFloat()) * 0.2f + 0.2f);
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 60);
                DataStorageHelper.incrementObjective(player, EObjective.DARK_TOOL);
                break;
            }
            case WATER: {
                BlockRayTraceResult result = InputHelper.rayTrace(player, player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e(), 0.0f);
                if (result == null || result.func_216346_c() != RayTraceResult.Type.BLOCK) break;
                if (!FluidUtil.tryPlaceFluid((PlayerEntity)player, (World)world, (Hand)hand, (BlockPos)result.func_216350_a(), (IFluidHandler)new SpecialWaterTank(), (FluidStack)new FluidStack((Fluid)Fluids.field_204546_a, 1000))) {
                    FluidUtil.tryPlaceFluid((PlayerEntity)player, (World)world, (Hand)hand, (BlockPos)result.func_216350_a().func_177972_a(result.func_216354_b()), (IFluidHandler)new SpecialWaterTank(), (FluidStack)new FluidStack((Fluid)Fluids.field_204546_a, 1000));
                }
                SoundHelper.empty_fluid(player, 1.0f);
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 10);
                DataStorageHelper.incrementObjective(player, EObjective.WATER_TOOL);
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public static ActionResultType onItemUse(ItemUseContext context, EElement element) {
        if (element == null) {
            return ActionResultType.PASS;
        }
        World world = context.func_195991_k();
        if (!ModHelper.isServerWorld(world)) {
            return ActionResultType.PASS;
        }
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        Hand hand = context.func_221531_n();
        if (!DataStorageHelper.hasResearch(player, EResearch.CRYSTAL_TOOLS)) {
            ModHelper.missingResearch(player);
            return ActionResultType.PASS;
        }
        switch (element) {
            case EARTH: {
                String text;
                Direction[] dirs = new Direction[2];
                if (facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH)) {
                    dirs[0] = Direction.UP;
                    dirs[1] = Direction.WEST;
                } else if (facing.equals((Object)Direction.WEST) || facing.equals((Object)Direction.EAST)) {
                    dirs[0] = Direction.UP;
                    dirs[1] = Direction.NORTH;
                } else if (facing.equals((Object)Direction.UP) || facing.equals((Object)Direction.DOWN)) {
                    dirs[0] = Direction.NORTH;
                    dirs[1] = Direction.WEST;
                }
                int[] values = new int[]{-1, -1, -1};
                BlockPos[] poses = new BlockPos[]{pos, pos.func_177972_a(dirs[0]), pos.func_177972_a(dirs[1]), pos.func_177972_a(dirs[0].func_176734_d()), pos.func_177972_a(dirs[1].func_176734_d()), pos.func_177972_a(dirs[0]).func_177972_a(dirs[1]), pos.func_177972_a(dirs[0]).func_177972_a(dirs[1].func_176734_d()), pos.func_177972_a(dirs[0].func_176734_d()).func_177972_a(dirs[1]), pos.func_177972_a(dirs[0].func_176734_d()).func_177972_a(dirs[1].func_176734_d())};
                Direction f = facing.func_176734_d();
                for (int i = 0; i < 3; ++i) {
                    int max = poses.length;
                    for (int j = 0; j < max; ++j) {
                        values = ModHelper.earthCheck(values, world.func_180495_p(poses[j].func_177967_a(f, i)));
                    }
                }
                if (values[0] == -1) {
                    text = "lord.earth.no.blocks";
                    player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 0.1f);
                } else {
                    player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, 0.1f + 2.0f * (1.0f - (float)values[0] / (float)ModHelper.oreNames.length));
                    StringBuilder b = new StringBuilder();
                    b.append("\u00a7a");
                    b.append(ModHelper.capitaliseFirst(ModHelper.oreNames[values[0]]));
                    if (values[1] != -1) {
                        b.append("\u00a7r, \u00a7e").append(ModHelper.capitaliseFirst(ModHelper.oreNames[values[1]]));
                        if (values[2] != -1) {
                            b.append("\u00a7r, \u00a76").append(ModHelper.capitaliseFirst(ModHelper.oreNames[values[2]]));
                        }
                    }
                    text = b.toString();
                }
                ModHelper.actionBarMessage(player, text);
                DataStorageHelper.incrementObjective(player, EObjective.EARTH_TOOL);
                break;
            }
            case FIRE: {
                boolean canFirePlace = world.func_175623_d(pos.func_177972_a(facing));
                if (!canFirePlace) break;
                player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, (ModHelper.rand.nextFloat() - ModHelper.rand.nextFloat()) * 0.2f + 1.0f);
                world.func_180501_a(pos.func_177972_a(facing), Blocks.field_150480_ab.func_176223_P(), 11);
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
                DataStorageHelper.incrementObjective(player, EObjective.FIRE_TOOL);
                break;
            }
            case LIGHT: {
                boolean canlightPlace = world.func_175623_d(pos.func_177972_a(facing));
                if (!canlightPlace) break;
                player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 1.0f, (ModHelper.rand.nextFloat() - ModHelper.rand.nextFloat()) * 0.2f + 1.0f);
                world.func_180501_a(pos.func_177972_a(facing), ModBlocks.RUNIC_LAMP.func_176223_P(), 11);
                DataStorageHelper.incrementObjective(player, EObjective.LIGHT_TOOL);
            }
        }
        return ActionResultType.PASS;
    }

    public static ActionResultType itemInteractionForEntity(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand, EElement element) {
        if (element == null) {
            return ActionResultType.PASS;
        }
        if (!ModHelper.isServerWorld(player.field_70170_p)) {
            return ActionResultType.PASS;
        }
        if (!DataStorageHelper.hasResearch(player, EResearch.CRYSTAL_TOOLS)) {
            ModHelper.missingResearch(player);
            return ActionResultType.PASS;
        }
        switch (element) {
            case FIRE: {
                Item fireItem = stack.func_77973_b();
                if (!(player.func_184811_cZ().func_185143_a(fireItem, 0.0f) <= 0.0f) || !target.func_70097_a((DamageSource)DamageSourceElemental.FIREDAMAGE.from((Entity)player), 0.0f)) break;
                player.func_130014_f_().func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, (ModHelper.rand.nextFloat() - ModHelper.rand.nextFloat()) * 0.2f + 1.0f);
                target.func_70015_d(10);
                player.func_184811_cZ().func_185145_a(fireItem, 20);
                DataStorageHelper.incrementObjective(player, EObjective.FIRE_TOOL);
            }
        }
        return ActionResultType.PASS;
    }
}

