/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Items;

import com.cobbs.lordcraft.Entries.ModBlocks;
import com.cobbs.lordcraft.Items.BasicItem;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TranslocationMarker
extends BasicItem {
    public TranslocationMarker(String name) {
        super(name, 1, 0);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (ModHelper.isServerWorld(world)) {
            BlockPos pos = context.func_195995_a();
            ItemStack stack = context.func_195996_i();
            PlayerEntity player = context.func_195999_j();
            if (ModHelper.isPlayerReal(player) && world.func_180495_p(pos).func_177230_c() != ModBlocks.TRANSLOCATOR) {
                TranslocationMarker.mark(stack, world, pos);
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_193781_bp, player.func_184176_by(), 1.0f, 0.5f);
                ModHelper.actionBarMessage(player, "lordcraft.marker.mark");
                return ActionResultType.SUCCESS;
            }
        } else {
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public static void mark(ItemStack stack, World world, BlockPos pos) {
        String id = world.func_234923_W_().func_240901_a_().toString();
        if (!stack.func_77948_v()) {
            stack.func_77966_a(Enchantments.field_185309_u, 0);
        }
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74778_a("lord:world", id);
        nbt.func_74768_a("lord:x", pos.func_177958_n());
        nbt.func_74768_a("lord:y", pos.func_177956_o());
        nbt.func_74768_a("lord:z", pos.func_177952_p());
        stack.func_77982_d(nbt);
    }

    public static boolean hasLoc(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        return nbt.func_74764_b("lord:x");
    }

    public static int getX(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        return nbt.func_74762_e("lord:x");
    }

    public static int getY(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        return nbt.func_74762_e("lord:y");
    }

    public static int getZ(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        return nbt.func_74762_e("lord:z");
    }

    public static String getWorld(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        return nbt.func_74779_i("lord:world");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (TranslocationMarker.hasLoc(stack)) {
            tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat("X: ", TranslocationMarker.getX(stack))));
            tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat("Y: ", TranslocationMarker.getY(stack))));
            tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat("Z: ", TranslocationMarker.getZ(stack))));
            tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat("DIM: ", TranslocationMarker.getWorld(stack))));
            tooltip.add((ITextComponent)new TranslationTextComponent("lord.tooltip.teleport_stone"));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("lord.tooltip.teleport_stone"));
        }
    }
}

