/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Items;

import com.cobbs.lordcraft.Items.BasicItem;
import com.cobbs.lordcraft.Items.IColoredItem;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicCollection;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicData;
import com.cobbs.lordcraft.Util.DataStorage.Lordic.LordicSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaCollection;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaData;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaSavedData;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.DataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VoidCrystal
extends BasicItem
implements IColoredItem {
    private static final String vcTag = "lord:vc";
    private static final int maxFill = 4;

    public VoidCrystal(String name) {
        super(name, 1, 0);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (ModHelper.isPlayerReal(playerIn) && worldIn != null && !worldIn.field_72995_K) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            DataStorageHelper.hasResearch(playerIn, EResearch.VOID_ENERGY);
            if (playerIn.func_225608_bj_()) {
                VoidCrystal.takeEnergy(playerIn, stack);
            } else {
                VoidCrystal.addEnergy(playerIn, stack);
            }
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        if (layer == 1) {
            CompoundNBT tag = VoidCrystal.getVCTag(stack);
            int type = tag.func_74762_e("type");
            int energy = tag.func_74762_e("pips");
            if (energy > 0) {
                return ColorHelper.interpolate(ColorHelper.CONSTELLATION_COLORS[0], ColorHelper.CONSTELLATION_COLORS[type], energy, 4);
            }
            return ColorHelper.ELEMENTALCOLOURS[0];
        }
        return ColorHelper.WHITE;
    }

    private static void initNBT(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74764_b(vcTag)) {
            return;
        }
        nbt.func_218657_a(vcTag, (INBT)VoidCrystal.baseVCTag());
        stack.func_77982_d(nbt);
    }

    private static CompoundNBT baseVCTag() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("pips", 0);
        nbt.func_74768_a("type", 0);
        nbt.func_74778_a("id", "");
        return nbt;
    }

    private static CompoundNBT getVCTag(ItemStack stack) {
        VoidCrystal.initNBT(stack);
        return stack.func_196082_o().func_74775_l(vcTag);
    }

    public static void addEnergy(PlayerEntity player, ItemStack stack) {
        int energy;
        CompoundNBT tag = VoidCrystal.getVCTag(stack);
        String id = tag.func_74779_i("id");
        if ((id.equals("") || id.equals(player.func_110124_au().toString())) && (energy = tag.func_74762_e("pips")) < 4) {
            ManaSavedData savedData = ManaSavedData.get(player);
            ManaData data = (ManaData)((ManaCollection)savedData.data).get(player);
            if (data.maxPips > 0) {
                --data.maxPips;
                data.pips = Math.max(0, data.pips - 1);
                LordicSavedData lordicSavedData = LordicSavedData.get(player);
                LordicData lData = (LordicData)((LordicCollection)lordicSavedData.data).get(player);
                tag.func_74768_a("pips", ++energy);
                tag.func_74768_a("type", lData.primaryElement + 1);
                tag.func_74778_a("id", player.func_110124_au().toString());
                savedData.func_76185_a();
                ((ManaCollection)savedData.data).syncToClient((ServerPlayerEntity)player);
                CompoundNBT nbt = stack.func_196082_o();
                nbt.func_218657_a(vcTag, (INBT)tag);
                stack.func_77982_d(nbt);
            }
        }
    }

    public static void takeEnergy(PlayerEntity player, ItemStack stack) {
        int energy;
        CompoundNBT tag = VoidCrystal.getVCTag(stack);
        String id = tag.func_74779_i("id");
        if (id.equals(player.func_110124_au().toString()) && (energy = tag.func_74762_e("pips")) > 0) {
            ManaSavedData savedData = ManaSavedData.get(player);
            ManaData data = (ManaData)((ManaCollection)savedData.data).get(player);
            ++data.maxPips;
            String nId = "";
            if (--energy > 0) {
                nId = player.func_110124_au().toString();
            }
            LordicSavedData lordicSavedData = LordicSavedData.get(player);
            LordicData lData = (LordicData)((LordicCollection)lordicSavedData.data).get(player);
            tag.func_74768_a("pips", energy);
            tag.func_74768_a("type", lData.primaryElement + 1);
            tag.func_74778_a("id", nId);
            savedData.func_76185_a();
            ((ManaCollection)savedData.data).syncToClient((ServerPlayerEntity)player);
            CompoundNBT nbt = stack.func_196082_o();
            nbt.func_218657_a(vcTag, (INBT)tag);
            stack.func_77982_d(nbt);
        }
    }

    public static int getEnergy(ItemStack stack) {
        CompoundNBT tag = VoidCrystal.getVCTag(stack);
        return tag.func_74762_e("pips");
    }

    public static String getOwner(ItemStack stack) {
        CompoundNBT tag = VoidCrystal.getVCTag(stack);
        return tag.func_74779_i("id");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack != null && !stack.func_190926_b()) {
            CompoundNBT tag = VoidCrystal.getVCTag(stack);
            int energy = tag.func_74762_e("pips");
            String id = tag.func_74779_i("id");
            tooltip.add((ITextComponent)new StringTextComponent(ModHelper.concat(I18n.func_135052_a((String)"lordcraft.void_crystal.pips", (Object[])new Object[0]), " \u00a7b", energy)));
            if (!id.equals("")) {
                if (id.equals(Minecraft.func_71410_x().field_71439_g.func_110124_au().toString())) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.void_crystal.owner"));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.void_crystal.not_owner"));
                }
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.void_crystal.use1"));
            tooltip.add((ITextComponent)new TranslationTextComponent("lordcraft.void_crystal.use2"));
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 360000;
    }
}

