/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Research;

import com.cobbs.lordcraft.Entries.ModBlocks;
import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Passives.EPassive;
import com.cobbs.lordcraft.Research.EResearchState;
import com.cobbs.lordcraft.Research.EResearchTab;
import com.cobbs.lordcraft.Research.ResearchInstance;
import com.cobbs.lordcraft.Util.CustomRunnable;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.EObjective;
import com.cobbs.lordcraft.Util.EElement;
import com.cobbs.lordcraft.Util.Entities.WanderingSpirit;
import com.cobbs.lordcraft.Util.Helpers.DataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

public enum EResearch {
    BASICS(EResearchTab.BASICS),
    WATER(EResearchTab.ELEMENTAL),
    EARTH(EResearchTab.ELEMENTAL),
    FIRE(EResearchTab.ELEMENTAL),
    AIR(EResearchTab.ELEMENTAL),
    LIGHT(EResearchTab.ELEMENTAL),
    DARK(EResearchTab.ELEMENTAL),
    ADVANCED_RESEARCH(EResearchTab.BASICS),
    ARCANE_CHALK(EResearchTab.BASICS),
    ARCANE_BASIN(EResearchTab.BASICS),
    CRYSTALLIZATION(EResearchTab.ALCHEMY, 5),
    BASIN_CRAFTING1(EResearchTab.BASICS),
    VOID_ENERGY(EResearchTab.ALCHEMY, 5),
    ADVANCED_ARCANE_CHALK(EResearchTab.BASICS),
    RITUALS(EResearchTab.RITUAl),
    MANA_INTERFACE(EResearchTab.ARCANA),
    VOID_EYE(EResearchTab.ARCANA, 5),
    SPELL_CRAFTING(EResearchTab.ARCANA),
    WANDS(EResearchTab.ARCANA, 4),
    GOLD_CAPS(EResearchTab.ARCANA),
    MAGMITE_CAPS(EResearchTab.ARCANA),
    COMPLEX_STAFF(EResearchTab.ARCANA),
    ULTIMATE_STAFF(EResearchTab.ARCANA),
    RUNES(EResearchTab.ARCANA, 6),
    ADVANCED_RUNES(EResearchTab.ARCANA, 8),
    LEGACY_I(EResearchTab.BASICS),
    LEGACY_II(EResearchTab.BASICS),
    WATER_SPELL_UTIL(EResearchTab.ELEMENTAL, 4),
    WATER_SPELL_COMBAT(EResearchTab.ELEMENTAL, 4),
    EARTH_SPELL_UTIL(EResearchTab.ELEMENTAL, 4),
    EARTH_SPELL_COMBAT(EResearchTab.ELEMENTAL, 4),
    FIRE_SPELL_UTIL(EResearchTab.ELEMENTAL, 4),
    FIRE_SPELL_COMBAT(EResearchTab.ELEMENTAL, 4),
    AIR_SPELL_UTIL(EResearchTab.ELEMENTAL, 4),
    AIR_SPELL_COMBAT(EResearchTab.ELEMENTAL, 4),
    LIGHT_SPELL_UTIL(EResearchTab.ELEMENTAL, 4),
    LIGHT_SPELL_COMBAT(EResearchTab.ELEMENTAL, 4),
    DARK_SPELL_UTIL(EResearchTab.ELEMENTAL, 4),
    DARK_SPELL_COMBAT(EResearchTab.ELEMENTAL, 4),
    FOCUS_AOE(EResearchTab.ARCANA, 5),
    FOCUS_ARC(EResearchTab.ARCANA, 5),
    FOCUS_CASCADE(EResearchTab.ARCANA, 8),
    FOCUS_CHANNELING(EResearchTab.ARCANA, 6),
    FOCUS_CONE(EResearchTab.ARCANA, 4),
    FOCUS_PROJECTILE(EResearchTab.ARCANA),
    FOCUS_SCATTER(EResearchTab.ARCANA, 6),
    FOCUS_TRINITY(EResearchTab.ARCANA, 4),
    WATER_INFUSION(EResearchTab.ELEMENTAL),
    EARTH_INFUSION(EResearchTab.ELEMENTAL),
    FIRE_INFUSION(EResearchTab.ELEMENTAL),
    AIR_INFUSION(EResearchTab.ELEMENTAL),
    LIGHT_INFUSION(EResearchTab.ELEMENTAL),
    DARK_INFUSION(EResearchTab.ELEMENTAL),
    ARCANE_FABRIC(EResearchTab.ALCHEMY),
    ARCANE_METAL(EResearchTab.ALCHEMY),
    CRYSTAL_TOOLS(EResearchTab.ALCHEMY),
    BLOCK_TRANSMUTATION(EResearchTab.ALCHEMY),
    WATER_ARTIFACT(EResearchTab.ELEMENTAL),
    EARTH_ARTIFACT(EResearchTab.ELEMENTAL),
    FIRE_ARTIFACT(EResearchTab.ELEMENTAL),
    AIR_ARTIFACT(EResearchTab.ELEMENTAL),
    LIGHT_ARTIFACT(EResearchTab.ELEMENTAL),
    DARK_ARTIFACT(EResearchTab.ELEMENTAL),
    MANA_RITUAL_I(EResearchTab.RITUAl),
    MANA_RITUAL_II(EResearchTab.RITUAl),
    WATER_PASSIVE_I(EResearchTab.ELEMENTAL, 4),
    EARTH_PASSIVE_I(EResearchTab.ELEMENTAL, 4),
    FIRE_PASSIVE_I(EResearchTab.ELEMENTAL, 4),
    AIR_PASSIVE_I(EResearchTab.ELEMENTAL, 4),
    LIGHT_PASSIVE_I(EResearchTab.ELEMENTAL, 4),
    DARK_PASSIVE_I(EResearchTab.ELEMENTAL, 4),
    WATER_PASSIVE_II(EResearchTab.ELEMENTAL),
    EARTH_PASSIVE_II(EResearchTab.ELEMENTAL),
    FIRE_PASSIVE_II(EResearchTab.ELEMENTAL),
    AIR_PASSIVE_II(EResearchTab.ELEMENTAL),
    LIGHT_PASSIVE_II(EResearchTab.ELEMENTAL),
    DARK_PASSIVE_II(EResearchTab.ELEMENTAL),
    ARCANE_FURNACE(EResearchTab.ALCHEMY),
    ORE_PROCESSING(EResearchTab.ALCHEMY, 5),
    FOOD_COOKER(EResearchTab.ALCHEMY, 5),
    ARCANE_FORGE(EResearchTab.RITUAl, 6),
    WATER_MASTERY(EResearchTab.ELEMENTAL, 6),
    EARTH_MASTERY(EResearchTab.ELEMENTAL, 6),
    FIRE_MASTERY(EResearchTab.ELEMENTAL, 6),
    AIR_MASTERY(EResearchTab.ELEMENTAL, 6),
    LIGHT_MASTERY(EResearchTab.ELEMENTAL, 6),
    DARK_MASTERY(EResearchTab.ELEMENTAL, 6),
    THELOS(EResearchTab.BASICS, EResearchState.VERY_HIDDEN, 10),
    FAST_VOID_CRYSTALS(EResearchTab.ELEMENTAL, 6),
    BOLT_SPELL(EResearchTab.ELEMENTAL, 6),
    VOID_WORKBENCH(EResearchTab.ELEMENTAL, 8),
    PLATE_CHANGE(EResearchTab.ELEMENTAL),
    TRANSLOCATION_MATRIX(EResearchTab.ELEMENTAL),
    ARCANE_PLATES(EResearchTab.ALCHEMY),
    WATER_PASSIVE_III(EResearchTab.ELEMENTAL, 5),
    EARTH_PASSIVE_III(EResearchTab.ELEMENTAL, 5),
    FIRE_PASSIVE_III(EResearchTab.ELEMENTAL, 5),
    AIR_PASSIVE_III(EResearchTab.ELEMENTAL, 5),
    LIGHT_PASSIVE_III(EResearchTab.ELEMENTAL, 5),
    DARK_PASSIVE_III(EResearchTab.ELEMENTAL, 5),
    FORGE_BASIN_I(EResearchTab.RITUAl, 6),
    ARCANE_BOW(EResearchTab.BASICS),
    PLAYER_INTERFACE(EResearchTab.ELEMENTAL);

    public ItemStack display = ItemStack.field_190927_a;
    private String unlocalname = null;
    public ResearchInstance instance;
    private CustomRunnable<PlayerEntity> unlock = null;
    public final int difficulty;
    public final EResearchState defaultState;
    public final EResearchTab tab;
    public boolean showsLinks = true;

    private EResearch(EResearchTab tab, EResearchState state, int difficulty) {
        this.tab = tab;
        this.defaultState = state;
        this.difficulty = difficulty;
    }

    private EResearch(EResearchTab tab, EResearchState state) {
        this(tab, state, 3);
    }

    private EResearch(EResearchTab tab, int difficulty) {
        this(tab, EResearchState.HIDDEN, difficulty);
    }

    private EResearch(EResearchTab tab) {
        this(tab, 3);
    }

    public String unlocalname() {
        if (this.unlocalname == null) {
            this.unlocalname = ModHelper.concat("lordcraft.res.", this.toString().toLowerCase());
        }
        return this.unlocalname;
    }

    public static void init() {
        EResearch.VOID_EYE.showsLinks = false;
        new ResearchInstance(BASICS, new Object[0]);
        new ResearchInstance(WATER, new Object[]{THELOS});
        new ResearchInstance(EARTH, new Object[]{THELOS});
        new ResearchInstance(FIRE, new Object[]{THELOS});
        new ResearchInstance(AIR, new Object[]{THELOS});
        new ResearchInstance(LIGHT, new Object[]{THELOS});
        new ResearchInstance(DARK, new Object[]{THELOS});
        new ResearchInstance(ADVANCED_RESEARCH, new Object[]{BASICS});
        new ResearchInstance(ARCANE_CHALK, new Object[]{BASICS});
        new ResearchInstance(ARCANE_BASIN, new Object[]{BASICS});
        new ResearchInstance(CRYSTALLIZATION, new Object[]{ARCANE_BASIN});
        new ResearchInstance(BASIN_CRAFTING1, new Object[]{false, ARCANE_BASIN, CRYSTALLIZATION, EObjective.BASIN_USAGE1});
        new ResearchInstance(VOID_ENERGY, new Object[]{CRYSTALLIZATION});
        new ResearchInstance(ADVANCED_ARCANE_CHALK, new Object[]{false, ARCANE_CHALK, EObjective.ADVANCED_CHALK});
        new ResearchInstance(RITUALS, new Object[]{false, ARCANE_CHALK, EObjective.RITUALS});
        new ResearchInstance(MANA_INTERFACE, new Object[]{VOID_ENERGY});
        new ResearchInstance(VOID_EYE, new Object[]{MANA_INTERFACE, RITUALS});
        new ResearchInstance(SPELL_CRAFTING, new Object[]{false, MANA_INTERFACE, RITUALS, EObjective.MANA});
        new ResearchInstance(WANDS, new Object[]{SPELL_CRAFTING});
        new ResearchInstance(GOLD_CAPS, new Object[]{false, SPELL_CRAFTING, EObjective.HIT_MOBS_FOR_GOLD});
        new ResearchInstance(COMPLEX_STAFF, new Object[]{false, SPELL_CRAFTING, EObjective.CAST_SPELLS_FOR_COMPLEX});
        new ResearchInstance(MAGMITE_CAPS, new Object[]{false, GOLD_CAPS, EObjective.HIT_MOBS_FOR_MAGMITE});
        new ResearchInstance(ULTIMATE_STAFF, new Object[]{false, COMPLEX_STAFF, EObjective.CAST_SPELLS_FOR_ULTIMATE});
        new ResearchInstance(RUNES, new Object[]{MAGMITE_CAPS, ULTIMATE_STAFF, WANDS, VOID_EYE});
        new ResearchInstance(ADVANCED_RUNES, new Object[]{RUNES, THELOS});
        new ResearchInstance(LEGACY_I, new Object[]{false, ADVANCED_RESEARCH, EObjective.READ_HISTORY_I});
        new ResearchInstance(LEGACY_II, new Object[]{false, LEGACY_I, EObjective.READ_HISTORY_II});
        new ResearchInstance(WATER_SPELL_UTIL, new Object[]{WATER, SPELL_CRAFTING});
        new ResearchInstance(WATER_SPELL_COMBAT, new Object[]{WATER, SPELL_CRAFTING});
        new ResearchInstance(EARTH_SPELL_UTIL, new Object[]{EARTH, SPELL_CRAFTING});
        new ResearchInstance(EARTH_SPELL_COMBAT, new Object[]{EARTH, SPELL_CRAFTING});
        new ResearchInstance(FIRE_SPELL_UTIL, new Object[]{FIRE, SPELL_CRAFTING});
        new ResearchInstance(FIRE_SPELL_COMBAT, new Object[]{FIRE, SPELL_CRAFTING});
        new ResearchInstance(AIR_SPELL_UTIL, new Object[]{AIR, SPELL_CRAFTING});
        new ResearchInstance(AIR_SPELL_COMBAT, new Object[]{AIR, SPELL_CRAFTING});
        new ResearchInstance(LIGHT_SPELL_UTIL, new Object[]{LIGHT, SPELL_CRAFTING});
        new ResearchInstance(LIGHT_SPELL_COMBAT, new Object[]{LIGHT, SPELL_CRAFTING});
        new ResearchInstance(DARK_SPELL_UTIL, new Object[]{DARK, SPELL_CRAFTING});
        new ResearchInstance(DARK_SPELL_COMBAT, new Object[]{DARK, SPELL_CRAFTING});
        new ResearchInstance(FOCUS_PROJECTILE, new Object[]{SPELL_CRAFTING});
        new ResearchInstance(FOCUS_AOE, new Object[]{SPELL_CRAFTING});
        new ResearchInstance(FOCUS_TRINITY, new Object[]{FOCUS_PROJECTILE});
        new ResearchInstance(FOCUS_CONE, new Object[]{FOCUS_AOE});
        new ResearchInstance(FOCUS_ARC, new Object[]{FOCUS_TRINITY});
        new ResearchInstance(FOCUS_CHANNELING, new Object[]{FOCUS_CONE});
        new ResearchInstance(FOCUS_SCATTER, new Object[]{FOCUS_ARC});
        new ResearchInstance(FOCUS_CASCADE, new Object[]{FOCUS_CHANNELING});
        new ResearchInstance(WATER_INFUSION, new Object[]{WATER, RITUALS});
        new ResearchInstance(EARTH_INFUSION, new Object[]{EARTH, RITUALS});
        new ResearchInstance(FIRE_INFUSION, new Object[]{FIRE, RITUALS});
        new ResearchInstance(AIR_INFUSION, new Object[]{AIR, RITUALS});
        new ResearchInstance(LIGHT_INFUSION, new Object[]{LIGHT, RITUALS});
        new ResearchInstance(DARK_INFUSION, new Object[]{DARK, RITUALS});
        new ResearchInstance(ARCANE_FABRIC, new Object[]{CRYSTALLIZATION, RITUALS});
        new ResearchInstance(ARCANE_METAL, new Object[]{CRYSTALLIZATION, RITUALS});
        new ResearchInstance(CRYSTAL_TOOLS, new Object[]{CRYSTALLIZATION});
        new ResearchInstance(BLOCK_TRANSMUTATION, new Object[]{CRYSTALLIZATION});
        new ResearchInstance(WATER_ARTIFACT, new Object[]{CRYSTAL_TOOLS, WATER_INFUSION, false, EObjective.WATER_TOOL});
        new ResearchInstance(EARTH_ARTIFACT, new Object[]{CRYSTAL_TOOLS, EARTH_INFUSION, false, EObjective.EARTH_TOOL});
        new ResearchInstance(FIRE_ARTIFACT, new Object[]{CRYSTAL_TOOLS, FIRE_INFUSION, false, EObjective.FIRE_TOOL});
        new ResearchInstance(AIR_ARTIFACT, new Object[]{CRYSTAL_TOOLS, AIR_INFUSION, false, EObjective.AIR_TOOL});
        new ResearchInstance(LIGHT_ARTIFACT, new Object[]{CRYSTAL_TOOLS, LIGHT_INFUSION, false, EObjective.LIGHT_TOOL});
        new ResearchInstance(DARK_ARTIFACT, new Object[]{CRYSTAL_TOOLS, DARK_INFUSION, false, EObjective.DARK_TOOL});
        new ResearchInstance(MANA_RITUAL_I, new Object[]{VOID_ENERGY, RITUALS});
        new ResearchInstance(MANA_RITUAL_II, new Object[]{MANA_RITUAL_I, false, EObjective.MANA_GAIN});
        new ResearchInstance(WATER_PASSIVE_I, new Object[]{WATER_INFUSION, VOID_ENERGY});
        new ResearchInstance(EARTH_PASSIVE_I, new Object[]{EARTH_INFUSION, VOID_ENERGY});
        new ResearchInstance(FIRE_PASSIVE_I, new Object[]{FIRE_INFUSION, VOID_ENERGY});
        new ResearchInstance(AIR_PASSIVE_I, new Object[]{AIR_INFUSION, VOID_ENERGY});
        new ResearchInstance(LIGHT_PASSIVE_I, new Object[]{LIGHT_INFUSION, VOID_ENERGY});
        new ResearchInstance(DARK_PASSIVE_I, new Object[]{DARK_INFUSION, VOID_ENERGY});
        new ResearchInstance(WATER_PASSIVE_II, new Object[]{WATER_PASSIVE_I, false, EObjective.WATER_RITUAL});
        new ResearchInstance(EARTH_PASSIVE_II, new Object[]{EARTH_PASSIVE_I, false, EObjective.EARTH_RITUAL});
        new ResearchInstance(FIRE_PASSIVE_II, new Object[]{FIRE_PASSIVE_I, false, EObjective.FIRE_RITUAL});
        new ResearchInstance(AIR_PASSIVE_II, new Object[]{AIR_PASSIVE_I, false, EObjective.AIR_RITUAL});
        new ResearchInstance(LIGHT_PASSIVE_II, new Object[]{LIGHT_PASSIVE_I, false, EObjective.LIGHT_RITUAL});
        new ResearchInstance(DARK_PASSIVE_II, new Object[]{DARK_PASSIVE_I, false, EObjective.DARK_RITUAL});
        new ResearchInstance(ARCANE_FURNACE, new Object[]{VOID_ENERGY});
        new ResearchInstance(ORE_PROCESSING, new Object[]{ARCANE_FURNACE});
        new ResearchInstance(FOOD_COOKER, new Object[]{ARCANE_FURNACE});
        new ResearchInstance(ARCANE_FORGE, new Object[]{VOID_ENERGY, RITUALS});
        new ResearchInstance(WATER_MASTERY, new Object[]{WATER_PASSIVE_II, WATER_ARTIFACT, WATER_SPELL_COMBAT, WATER_SPELL_UTIL});
        new ResearchInstance(EARTH_MASTERY, new Object[]{EARTH_PASSIVE_II, EARTH_ARTIFACT, EARTH_SPELL_COMBAT, EARTH_SPELL_UTIL});
        new ResearchInstance(FIRE_MASTERY, new Object[]{FIRE_PASSIVE_II, FIRE_ARTIFACT, FIRE_SPELL_COMBAT, FIRE_SPELL_UTIL});
        new ResearchInstance(AIR_MASTERY, new Object[]{AIR_PASSIVE_II, AIR_ARTIFACT, AIR_SPELL_COMBAT, AIR_SPELL_UTIL});
        new ResearchInstance(LIGHT_MASTERY, new Object[]{LIGHT_PASSIVE_II, LIGHT_ARTIFACT, LIGHT_SPELL_COMBAT, LIGHT_SPELL_UTIL});
        new ResearchInstance(DARK_MASTERY, new Object[]{DARK_PASSIVE_II, DARK_ARTIFACT, DARK_SPELL_COMBAT, DARK_SPELL_UTIL});
        new ResearchInstance(THELOS, new Object[]{BASICS, WANDS, ARCANE_FABRIC, ARCANE_METAL, ARCANE_FORGE, VOID_EYE, ARCANE_PLATES});
        new ResearchInstance(FAST_VOID_CRYSTALS, new Object[]{THELOS});
        new ResearchInstance(BOLT_SPELL, new Object[]{THELOS, WATER_SPELL_COMBAT, EARTH_SPELL_COMBAT, FIRE_SPELL_COMBAT, AIR_SPELL_COMBAT, LIGHT_SPELL_COMBAT, DARK_SPELL_COMBAT});
        new ResearchInstance(VOID_WORKBENCH, new Object[]{THELOS, WATER_INFUSION, EARTH_INFUSION, FIRE_INFUSION, AIR_INFUSION, LIGHT_INFUSION, DARK_INFUSION});
        new ResearchInstance(TRANSLOCATION_MATRIX, new Object[]{VOID_WORKBENCH});
        new ResearchInstance(PLATE_CHANGE, new Object[]{VOID_WORKBENCH});
        new ResearchInstance(ARCANE_PLATES, new Object[]{VOID_ENERGY});
        new ResearchInstance(WATER_PASSIVE_III, new Object[]{WATER_MASTERY, FAST_VOID_CRYSTALS});
        new ResearchInstance(EARTH_PASSIVE_III, new Object[]{EARTH_MASTERY, FAST_VOID_CRYSTALS});
        new ResearchInstance(FIRE_PASSIVE_III, new Object[]{FIRE_MASTERY, FAST_VOID_CRYSTALS});
        new ResearchInstance(AIR_PASSIVE_III, new Object[]{AIR_MASTERY, FAST_VOID_CRYSTALS});
        new ResearchInstance(LIGHT_PASSIVE_III, new Object[]{LIGHT_MASTERY, FAST_VOID_CRYSTALS});
        new ResearchInstance(DARK_PASSIVE_III, new Object[]{DARK_MASTERY, FAST_VOID_CRYSTALS});
        new ResearchInstance(FORGE_BASIN_I, new Object[]{ARCANE_METAL, ARCANE_FABRIC, ARCANE_FORGE});
        new ResearchInstance(ARCANE_BOW, new Object[]{ADVANCED_RESEARCH, SPELL_CRAFTING, ARCANE_METAL, ARCANE_FABRIC});
        new ResearchInstance(PLAYER_INTERFACE, new Object[]{MANA_INTERFACE, VOID_WORKBENCH});
        EResearch.VOID_ENERGY.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.AQUA_AFFINITY, EPassive.POWER_FIST, EPassive.FLAME_TOUCH, EPassive.DOUBLE_JUMP, EPassive.HEALTH_BOOST_I, EPassive.DASH);
        EResearch.LEGACY_I.unlock = p -> DataStorageHelper.setLegacyLevel(p, 1);
        EResearch.LEGACY_II.unlock = p -> DataStorageHelper.setLegacyLevel(p, 2);
        EResearch.WATER_PASSIVE_I.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.WATER_STRIKE);
        EResearch.EARTH_PASSIVE_I.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.SILK_TOUCH);
        EResearch.FIRE_PASSIVE_I.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.AUTO_SMELT);
        EResearch.AIR_PASSIVE_I.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.FALL_RESIST);
        EResearch.LIGHT_PASSIVE_I.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.HEALTH_BOOST_II);
        EResearch.DARK_PASSIVE_I.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.DOUBLE_DASH);
        EResearch.WATER_PASSIVE_II.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.BREATH_REGEN);
        EResearch.EARTH_PASSIVE_II.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.FORTUNE);
        EResearch.FIRE_PASSIVE_II.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.FIRE_PROOF);
        EResearch.AIR_PASSIVE_II.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.FLURRY);
        EResearch.LIGHT_PASSIVE_II.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.MENDING);
        EResearch.DARK_PASSIVE_II.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.INCREASED_REACH);
        EResearch.WATER_PASSIVE_III.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.FROST_TOUCH);
        EResearch.EARTH_PASSIVE_III.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.FORTUNE_II);
        EResearch.FIRE_PASSIVE_III.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.FLAME_RETALIATION);
        EResearch.AIR_PASSIVE_III.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.FLURRY_II);
        EResearch.LIGHT_PASSIVE_III.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.MANA_REGEN);
        EResearch.DARK_PASSIVE_III.unlock = p -> DataStorageHelper.revealPassives(p, EPassive.MINING);
        EResearch.WATER_MASTERY.unlock = p -> {
            DataStorageHelper.revealResearch(p, THELOS);
            DataStorageHelper.setMastery(p, EElement.WATER);
        };
        EResearch.EARTH_MASTERY.unlock = p -> {
            DataStorageHelper.revealResearch(p, THELOS);
            DataStorageHelper.setMastery(p, EElement.EARTH);
        };
        EResearch.FIRE_MASTERY.unlock = p -> {
            DataStorageHelper.revealResearch(p, THELOS);
            DataStorageHelper.setMastery(p, EElement.FIRE);
        };
        EResearch.AIR_MASTERY.unlock = p -> {
            DataStorageHelper.revealResearch(p, THELOS);
            DataStorageHelper.setMastery(p, EElement.AIR);
        };
        EResearch.LIGHT_MASTERY.unlock = p -> {
            DataStorageHelper.revealResearch(p, THELOS);
            DataStorageHelper.setMastery(p, EElement.LIGHT);
        };
        EResearch.DARK_MASTERY.unlock = p -> {
            DataStorageHelper.revealResearch(p, THELOS);
            DataStorageHelper.setMastery(p, EElement.DARK);
        };
        EResearch.THELOS.unlock = p -> {
            DataStorageHelper.setThelos(p);
            World world = p.func_130014_f_();
            WanderingSpirit spirit = new WanderingSpirit(world);
            spirit.func_70107_b(p.func_226277_ct_() - p.func_70040_Z().field_72450_a * 4.0, p.func_226278_cu_() + 1.0, p.func_226281_cx_() - p.func_70040_Z().field_72449_c * 4.0);
            world.func_217376_c((Entity)spirit);
        };
    }

    public static void initClient() {
        EResearch.BASICS.display = new ItemStack((IItemProvider)ModItems.BOOK);
        EResearch.WATER.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_WATER);
        EResearch.EARTH.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_EARTH);
        EResearch.FIRE.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_FIRE);
        EResearch.AIR.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_AIR);
        EResearch.LIGHT.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_LIGHT);
        EResearch.DARK.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_DARK);
        EResearch.ADVANCED_RESEARCH.display = new ItemStack((IItemProvider)ModItems.INSCRIPTION_TILE);
        EResearch.ARCANE_CHALK.display = new ItemStack((IItemProvider)ModItems.CHALK);
        EResearch.ARCANE_BASIN.display = new ItemStack((IItemProvider)ModBlocks.ARCANE_BASIN);
        EResearch.CRYSTALLIZATION.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_BASIC);
        EResearch.BASIN_CRAFTING1.display = new ItemStack((IItemProvider)ModBlocks.WORKBENCH_BASIC);
        EResearch.VOID_ENERGY.display = new ItemStack((IItemProvider)ModItems.VOID_CRYSTAL);
        EResearch.ADVANCED_ARCANE_CHALK.display = new ItemStack((IItemProvider)ModItems.CHALK_ARCANA);
        EResearch.RITUALS.display = new ItemStack((IItemProvider)ModBlocks.RITUAL_CIRCLE);
        EResearch.MANA_INTERFACE.display = new ItemStack((IItemProvider)ModBlocks.VOID_INTERFACE);
        EResearch.VOID_EYE.display = new ItemStack((IItemProvider)ModItems.VOID_EYE);
        EResearch.SPELL_CRAFTING.display = new ItemStack((IItemProvider)ModBlocks.SPELL_CRAFTER);
        EResearch.WANDS.display = new ItemStack((IItemProvider)ModItems.WAND_1_1);
        EResearch.GOLD_CAPS.display = new ItemStack((IItemProvider)Items.field_151043_k);
        EResearch.MAGMITE_CAPS.display = new ItemStack((IItemProvider)ModItems.MAGMITE);
        EResearch.COMPLEX_STAFF.display = new ItemStack((IItemProvider)ModItems.AMPLIFICATION_ROD_2);
        EResearch.ULTIMATE_STAFF.display = new ItemStack((IItemProvider)ModItems.AMPLIFICATION_ROD_3);
        EResearch.RUNES.display = new ItemStack((IItemProvider)ModItems.RUNESTONE);
        EResearch.ADVANCED_RUNES.display = new ItemStack((IItemProvider)ModItems.RUNESTONE_ADVANCED);
        EResearch.LEGACY_I.display = new ItemStack((IItemProvider)Items.field_151122_aG);
        EResearch.LEGACY_II.display = new ItemStack((IItemProvider)Items.field_151134_bR);
        EResearch.WATER_INFUSION.display = new ItemStack((IItemProvider)ModItems.DUST_WATER);
        EResearch.EARTH_INFUSION.display = new ItemStack((IItemProvider)ModItems.DUST_EARTH);
        EResearch.FIRE_INFUSION.display = new ItemStack((IItemProvider)ModItems.DUST_FIRE);
        EResearch.AIR_INFUSION.display = new ItemStack((IItemProvider)ModItems.DUST_AIR);
        EResearch.LIGHT_INFUSION.display = new ItemStack((IItemProvider)ModItems.DUST_LIGHT);
        EResearch.DARK_INFUSION.display = new ItemStack((IItemProvider)ModItems.DUST_DARK);
        EResearch.ARCANE_FABRIC.display = new ItemStack((IItemProvider)ModItems.FABRIC);
        EResearch.ARCANE_METAL.display = new ItemStack((IItemProvider)ModItems.MAGMITE);
        EResearch.CRYSTAL_TOOLS.display = new ItemStack((IItemProvider)ModItems.PICKAXE_BASIC);
        EResearch.BLOCK_TRANSMUTATION.display = new ItemStack((IItemProvider)ModBlocks.BLOCK_TRANSMUTER);
        EResearch.WATER_ARTIFACT.display = new ItemStack((IItemProvider)ModItems.ARTIFACT_WATER);
        EResearch.EARTH_ARTIFACT.display = new ItemStack((IItemProvider)ModItems.ARTIFACT_EARTH);
        EResearch.FIRE_ARTIFACT.display = new ItemStack((IItemProvider)ModItems.ARTIFACT_FIRE);
        EResearch.AIR_ARTIFACT.display = new ItemStack((IItemProvider)ModItems.ARTIFACT_AIR);
        EResearch.LIGHT_ARTIFACT.display = new ItemStack((IItemProvider)ModItems.ARTIFACT_LIGHT);
        EResearch.DARK_ARTIFACT.display = new ItemStack((IItemProvider)ModItems.ARTIFACT_DARK);
        EResearch.MANA_RITUAL_I.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_BASIC);
        EResearch.MANA_RITUAL_II.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_PURE);
        EResearch.WATER_PASSIVE_I.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_WATER);
        EResearch.EARTH_PASSIVE_I.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_EARTH);
        EResearch.FIRE_PASSIVE_I.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_FIRE);
        EResearch.AIR_PASSIVE_I.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_AIR);
        EResearch.LIGHT_PASSIVE_I.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_LIGHT);
        EResearch.DARK_PASSIVE_I.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_DARK);
        EResearch.WATER_PASSIVE_II.display = new ItemStack((IItemProvider)ModBlocks.RITUAL_CIRCLE);
        EResearch.EARTH_PASSIVE_II.display = new ItemStack((IItemProvider)ModBlocks.RITUAL_CIRCLE);
        EResearch.FIRE_PASSIVE_II.display = new ItemStack((IItemProvider)ModBlocks.RITUAL_CIRCLE);
        EResearch.AIR_PASSIVE_II.display = new ItemStack((IItemProvider)ModBlocks.RITUAL_CIRCLE);
        EResearch.LIGHT_PASSIVE_II.display = new ItemStack((IItemProvider)ModBlocks.RITUAL_CIRCLE);
        EResearch.DARK_PASSIVE_II.display = new ItemStack((IItemProvider)ModBlocks.RITUAL_CIRCLE);
        EResearch.ARCANE_FURNACE.display = new ItemStack((IItemProvider)ModBlocks.FURNACE);
        EResearch.ORE_PROCESSING.display = new ItemStack((IItemProvider)Blocks.field_150352_o);
        EResearch.FOOD_COOKER.display = new ItemStack((IItemProvider)Items.field_151025_P);
        EResearch.ARCANE_FORGE.display = new ItemStack((IItemProvider)ModBlocks.FORGE);
        EResearch.WATER_MASTERY.display = new ItemStack((IItemProvider)ModBlocks.CRYSTAL_WATER);
        EResearch.EARTH_MASTERY.display = new ItemStack((IItemProvider)ModBlocks.CRYSTAL_EARTH);
        EResearch.FIRE_MASTERY.display = new ItemStack((IItemProvider)ModBlocks.CRYSTAL_FIRE);
        EResearch.AIR_MASTERY.display = new ItemStack((IItemProvider)ModBlocks.CRYSTAL_AIR);
        EResearch.LIGHT_MASTERY.display = new ItemStack((IItemProvider)ModBlocks.CRYSTAL_LIGHT);
        EResearch.DARK_MASTERY.display = new ItemStack((IItemProvider)ModBlocks.CRYSTAL_DARK);
        EResearch.THELOS.display = new ItemStack((IItemProvider)ModBlocks.CRYSTAL_PURE);
        EResearch.FAST_VOID_CRYSTALS.display = new ItemStack((IItemProvider)ModItems.VOID_CRYSTAL);
        EResearch.VOID_WORKBENCH.display = new ItemStack((IItemProvider)ModBlocks.WORKBENCH_VOID);
        EResearch.TRANSLOCATION_MATRIX.display = new ItemStack((IItemProvider)ModBlocks.TRANSLOCATOR);
        EResearch.PLATE_CHANGE.display = new ItemStack((IItemProvider)ModItems.PLATE_PURE);
        EResearch.ARCANE_PLATES.display = new ItemStack((IItemProvider)ModItems.PLATE_BASIC);
        EResearch.WATER_PASSIVE_III.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_WATER);
        EResearch.EARTH_PASSIVE_III.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_EARTH);
        EResearch.FIRE_PASSIVE_III.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_FIRE);
        EResearch.AIR_PASSIVE_III.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_AIR);
        EResearch.LIGHT_PASSIVE_III.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_LIGHT);
        EResearch.DARK_PASSIVE_III.display = new ItemStack((IItemProvider)ModItems.CRYSTAL_DARK);
        EResearch.FORGE_BASIN_I.display = new ItemStack((IItemProvider)ModBlocks.ARCANE_BASIN);
        EResearch.ARCANE_BOW.display = new ItemStack((IItemProvider)ModItems.ARCANE_BOW);
        EResearch.PLAYER_INTERFACE.display = new ItemStack((IItemProvider)ModBlocks.PLAYER_INTERFACE);
    }

    public ResearchInstance getInstance() {
        return this.instance;
    }

    public boolean hasInstance() {
        return this.instance != null;
    }

    public void onUnlock(PlayerEntity player) {
        if (this.unlock != null) {
            this.unlock.run(player);
        }
    }

    public static EResearch getResearch(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        for (EResearch research : EResearch.values()) {
            if (!research.name().toLowerCase().equals(name)) continue;
            return research;
        }
        return null;
    }
}

