/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Spells;

import com.cobbs.lordcraft.Spells.Spell;
import com.cobbs.lordcraft.Spells.SpellTypes.BlindSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.BlinkSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.BoltSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.DarkDamageSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.DigSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.FlameSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.FlashSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.FreezeSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.GravityWellSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.HealSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.ImpulseSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.KrondasSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.LiftSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.RegenSpell;
import com.cobbs.lordcraft.Spells.SpellTypes.SparksSpell;
import com.cobbs.lordcraft.Util.EElement;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.util.function.Supplier;

public enum ESpell {
    HEAL(HealSpell::new, EElement.WATER),
    FREEZE(FreezeSpell::new, EElement.WATER),
    DIG(DigSpell::new, EElement.EARTH),
    GRAVITY_WELL(GravityWellSpell::new, EElement.EARTH),
    REGEN(RegenSpell::new, EElement.FIRE),
    FLAME(FlameSpell::new, EElement.FIRE),
    IMPULSE(ImpulseSpell::new, EElement.AIR),
    LIFT(LiftSpell::new, EElement.AIR),
    BLIND(BlindSpell::new, EElement.LIGHT),
    FLASH(FlashSpell::new, EElement.LIGHT),
    BLINK(BlinkSpell::new, EElement.DARK),
    DARK_DAMAGE(DarkDamageSpell::new, EElement.DARK),
    SPARKS(SparksSpell::new, EElement.ENERGY),
    BOLT(BoltSpell::new, EElement.ENERGY),
    KRONDAS(KrondasSpell::new, null);

    private Supplier<Spell> spell;
    public final EElement element;

    private ESpell(Supplier<Spell> spell, EElement element) {
        this.spell = spell;
        this.element = element;
    }

    public Spell getSpell() {
        return Spell.getSpell(this);
    }

    public String getUnlocalName() {
        return ModHelper.concat("lordcraft.spell.type.", this.getSpell().name);
    }

    public static void init() {
        for (ESpell e : ESpell.values()) {
            e.spell.get();
        }
    }
}

