/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Spells;

import com.cobbs.lordcraft.Spells.FocusTypes.AOEFocus;
import com.cobbs.lordcraft.Spells.FocusTypes.ArcFocus;
import com.cobbs.lordcraft.Spells.FocusTypes.ArrowFocus;
import com.cobbs.lordcraft.Spells.FocusTypes.CascadeFocus;
import com.cobbs.lordcraft.Spells.FocusTypes.ChannelingFocus;
import com.cobbs.lordcraft.Spells.FocusTypes.ConeFocus;
import com.cobbs.lordcraft.Spells.FocusTypes.ProjectileFocus;
import com.cobbs.lordcraft.Spells.FocusTypes.ScatterFocus;
import com.cobbs.lordcraft.Spells.FocusTypes.SelfFocus;
import com.cobbs.lordcraft.Spells.FocusTypes.TouchFocus;
import com.cobbs.lordcraft.Spells.FocusTypes.TrinityFocus;
import com.cobbs.lordcraft.Spells.SpellFocus;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.util.function.Supplier;

public enum ESpellFocus {
    PROJECTILE(ProjectileFocus::new),
    TOUCH(TouchFocus::new),
    TRINITY(TrinityFocus::new),
    ARC(ArcFocus::new),
    SCATTER(ScatterFocus::new),
    CONE(ConeFocus::new),
    SELF(SelfFocus::new),
    AOE(AOEFocus::new),
    CHANNELING(ChannelingFocus::new),
    CASCADE(CascadeFocus::new),
    ARROW(ArrowFocus::new);

    private Supplier<SpellFocus> focus;

    private ESpellFocus(Supplier<SpellFocus> focus) {
        this.focus = focus;
    }

    public SpellFocus getFocus() {
        return SpellFocus.getFocus(this);
    }

    public String getUnlocalName() {
        return ModHelper.concat("lordcraft.spell.focus.", this.getFocus().name);
    }

    public static void init() {
        for (ESpellFocus e : ESpellFocus.values()) {
            e.focus.get();
        }
    }
}

