/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Spells;

import com.cobbs.lordcraft.Spells.ESpell;
import com.cobbs.lordcraft.Spells.ESpellFocus;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;

public abstract class Spell {
    public static List<Spell> spells = new ArrayList<Spell>();
    private static int cIndex = 0;
    public final String name;
    public final int indexX;
    public final int indexY;
    public final int baseCost;
    public final int basePips;
    public final int index;
    public final Color color;
    public final boolean changePotency;
    public final boolean spellMod;
    public final boolean frugal;
    public final List<ESpellFocus> blockedFoci;

    public Spell(String name, int indexX, int indexY, Color color, int baseCost, int basePips, boolean changePotency, boolean spellMod, boolean frugal, ESpellFocus ... blockedFoci) {
        this.name = name;
        this.indexX = indexX;
        this.indexY = indexY;
        this.color = color;
        this.baseCost = baseCost;
        this.basePips = basePips;
        this.changePotency = changePotency;
        this.spellMod = spellMod;
        this.frugal = frugal;
        this.blockedFoci = ModHelper.wrapLinked(blockedFoci);
        this.index = cIndex++;
        spells.add(this);
    }

    public Spell(String name, int indexX, int indexY, Color color, int baseCost, int basePips) {
        this(name, indexX, indexY, color, baseCost, basePips, false, false, false, new ESpellFocus[0]);
    }

    public String getTranslationName() {
        return ModHelper.concat("lordcraft.spell.", this.name);
    }

    public String getLocalName() {
        return I18n.func_135052_a((String)this.getTranslationName(), (Object[])new Object[0]);
    }

    public boolean cast(PlayerEntity caster, Object target, boolean modifier, double potency) {
        return this.cast(caster, target, null, modifier, potency);
    }

    public abstract boolean cast(PlayerEntity var1, Object var2, Direction var3, boolean var4, double var5);

    public static Spell getSpell(ESpell spell) {
        return spells.get(spell.ordinal());
    }

    public boolean canChangePotency() {
        return this.changePotency;
    }

    public boolean canBeFrugal() {
        return this.frugal;
    }

    public boolean canSpellMod() {
        return this.spellMod;
    }

    public double getCostModifier() {
        return 1.0;
    }

    public int getManaCost(double potency, boolean frugal, boolean spellMod) {
        int val = this.baseCost;
        val = (int)((double)val * potency);
        if (spellMod) {
            val *= this.getModifierCostMultiplier();
        }
        if (frugal) {
            val = (int)((double)val * 0.5);
        }
        return val;
    }

    public int getPipCost(double potency, boolean frugal, boolean spellMod) {
        int val = this.basePips;
        val = (int)((double)val * potency);
        if (spellMod) {
            val *= this.getModifierCostMultiplier();
        }
        if (frugal) {
            val = (int)((double)val * 0.5);
        }
        return val;
    }

    public boolean notOnEntity() {
        return false;
    }

    public boolean canUseSpell(PlayerEntity player, ESpellFocus focus) {
        return !this.blockedFoci.contains((Object)focus);
    }

    public String getModifierName() {
        return "";
    }

    public int getModifierCostMultiplier() {
        return 1;
    }

    public boolean attemptCast(PlayerEntity player) {
        ModHelper.missingResearch(player);
        return false;
    }
}

