/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Spells;

import com.cobbs.lordcraft.Spells.ESpell;
import com.cobbs.lordcraft.Spells.ESpellFocus;
import com.cobbs.lordcraft.Spells.Spell;
import com.cobbs.lordcraft.Spells.SpellFocus;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaCollection;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaData;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.EObjective;
import com.cobbs.lordcraft.Util.EShadowKey;
import com.cobbs.lordcraft.Util.Entities.SpellProjectile;
import com.cobbs.lordcraft.Util.Helpers.DataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.InputHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.NetworkHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class SpellContainer {
    public static final int max_charge = 50;
    public String name;
    public ESpellFocus focus;
    public ESpell spell;
    public boolean modifier;
    public boolean frugal;
    public boolean spellMod;
    public boolean charging;
    public double sliderVal;
    public double potency;

    public SpellContainer(String name, ESpellFocus focus, ESpell spell, double sliderVal, boolean modifier, boolean charging, boolean frugal, boolean spellMod, double potency) {
        this.name = name;
        this.focus = focus;
        this.spell = spell;
        this.sliderVal = sliderVal;
        this.modifier = modifier;
        this.potency = potency;
        this.frugal = frugal;
        this.spellMod = spellMod;
        this.charging = charging;
    }

    public boolean rodPowerfulEnough(int rodLevel, int cost) {
        switch (rodLevel) {
            case 1: {
                return cost <= 2000;
            }
            case 2: {
                return cost <= 4000;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public Spell getSpell() {
        return this.spell.getSpell();
    }

    public SpellFocus getFocus() {
        return this.focus.getFocus();
    }

    public boolean airCast(PlayerEntity entity, boolean wand, boolean pips, int rodLevel) {
        return this.airCast(entity, 0, wand, pips, rodLevel);
    }

    public boolean airCast(PlayerEntity player, int chargeTime, boolean wand, boolean pips, int rodLevel) {
        if (ModHelper.isServerWorld(player.func_130014_f_())) {
            boolean flag;
            int cost = 0;
            if (!pips) {
                cost = DataStorageHelper.getManaCost(this.manaCost(), this.spell.element, player);
            }
            boolean bl = flag = player.func_184812_l_() || this.rodPowerfulEnough(rodLevel, cost) && this.canCastPreCalc(player, pips, cost) && this.spell.getSpell().attemptCast(player) && this.focus.getFocus().attemptCast(player);
            if (flag) {
                boolean cast = false;
                double effectivePotency = this.effectivePotency(chargeTime, wand);
                switch (this.focus) {
                    case CASCADE: 
                    case PROJECTILE: {
                        SpellProjectile projectile = new SpellProjectile(player.field_70170_p, (LivingEntity)player, this, effectivePotency);
                        projectile.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, (float)this.sliderVal, 0.0f);
                        player.field_70170_p.func_217376_c((Entity)projectile);
                        cast = true;
                        break;
                    }
                    case TRINITY: {
                        double useAngle = 16.0 * this.sliderVal;
                        if (EShadowKey.ALTERNATE_EFFECT.holdingKey(player)) {
                            for (int i = -1; i < 2; ++i) {
                                SpellProjectile p = new SpellProjectile(player.field_70170_p, (LivingEntity)player, this, effectivePotency);
                                p.func_234612_a_((Entity)player, player.field_70125_A + (float)(useAngle * (double)i), player.field_70177_z, 0.0f, 1.0f, 0.0f);
                                player.field_70170_p.func_217376_c((Entity)p);
                            }
                        } else {
                            for (int i = -1; i < 2; ++i) {
                                SpellProjectile p = new SpellProjectile(player.field_70170_p, (LivingEntity)player, this, effectivePotency);
                                p.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z + (float)(useAngle * (double)i), 0.0f, 1.0f, 0.0f);
                                player.field_70170_p.func_217376_c((Entity)p);
                            }
                        }
                        cast = true;
                        break;
                    }
                    case ARC: {
                        double useAngleArc = 6.0 * this.sliderVal;
                        if (EShadowKey.ALTERNATE_EFFECT.holdingKey(player)) {
                            for (int i = -5; i < 6; ++i) {
                                SpellProjectile p = new SpellProjectile(player.field_70170_p, (LivingEntity)player, this, effectivePotency);
                                p.func_234612_a_((Entity)player, player.field_70125_A + (float)(useAngleArc * (double)i), player.field_70177_z, 0.0f, 1.0f, 0.0f);
                                player.field_70170_p.func_217376_c((Entity)p);
                            }
                        } else {
                            for (int i = -5; i < 6; ++i) {
                                SpellProjectile p = new SpellProjectile(player.field_70170_p, (LivingEntity)player, this, effectivePotency);
                                p.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z + (float)(useAngleArc * (double)i), 0.0f, 1.0f, 0.0f);
                                player.field_70170_p.func_217376_c((Entity)p);
                            }
                        }
                        cast = true;
                        break;
                    }
                    case SCATTER: {
                        double useAngleScatter = 6.0 * this.sliderVal;
                        for (int i = -3; i < 4; ++i) {
                            for (int j = -3; j < 4; ++j) {
                                SpellProjectile p = new SpellProjectile(player.field_70170_p, (LivingEntity)player, this, effectivePotency);
                                p.func_234612_a_((Entity)player, player.field_70125_A + (float)(useAngleScatter * (double)j), player.field_70177_z + (float)(useAngleScatter * (double)i), 0.0f, 1.0f, 0.0f);
                                player.field_70170_p.func_217376_c((Entity)p);
                            }
                        }
                        cast = true;
                        break;
                    }
                    case CONE: {
                        double coneAngle = ModHelper.toRadian(24.0 * this.sliderVal);
                        int coneRange = 24;
                        AxisAlignedBB coneBox = new AxisAlignedBB(player.func_233580_cy_().func_177981_b(coneRange).func_177965_g(coneRange).func_177970_e(coneRange), player.func_233580_cy_().func_177979_c(coneRange).func_177985_f(coneRange).func_177964_d(coneRange));
                        Vector3d playerPos = player.func_213303_ch();
                        Vector3d playerLook = player.func_70040_Z();
                        player.field_70170_p.func_175674_a((Entity)player, coneBox, e -> e instanceof LivingEntity).forEach(e -> {
                            Vector3d eVec;
                            double dot;
                            double angle;
                            Vector3d ePos = e.func_213303_ch();
                            if (ePos.func_72438_d(playerPos) <= (double)coneRange && coneAngle >= (angle = Math.acos((dot = (eVec = ePos.func_178788_d(playerPos)).func_72430_b(playerLook)) / (playerLook.func_72433_c() * eVec.func_72433_c())))) {
                                this.spell.getSpell().cast(player, e, this.spellMod, effectivePotency);
                            }
                        });
                        cast = true;
                        NetworkHelper.dataToPlayer((ServerPlayerEntity)player, "scc", this.spell.ordinal());
                        break;
                    }
                    case SELF: {
                        cast = this.spell.getSpell().cast(player, player, this.spellMod, effectivePotency);
                        NetworkHelper.dataToPlayer((ServerPlayerEntity)player, "scs", this.spell.ordinal());
                        break;
                    }
                    case AOE: {
                        double aoeR = 4.0 * this.sliderVal;
                        AxisAlignedBB bb = new AxisAlignedBB(-aoeR, -aoeR, -aoeR, aoeR, aoeR, aoeR);
                        player.field_70170_p.func_175674_a((Entity)player, bb.func_186670_a(player.func_233580_cy_()), e -> e instanceof LivingEntity).forEach(e -> this.spell.getSpell().cast(player, e, this.spellMod, effectivePotency));
                        cast = true;
                        NetworkHelper.dataToPlayer((ServerPlayerEntity)player, "sca", this.spell.ordinal());
                        break;
                    }
                    case CHANNELING: {
                        RayTraceResult channelResult = InputHelper.getMouseOver(player, 18.0 * this.sliderVal, 0.0f);
                        if (channelResult == null) break;
                        if (channelResult instanceof EntityRayTraceResult) {
                            EntityRayTraceResult eResult = (EntityRayTraceResult)channelResult;
                            cast = this.spell.getSpell().cast(player, eResult.func_216348_a(), this.spellMod, effectivePotency);
                            if (!this.modifier) break;
                            for (Entity e2 : player.field_70170_p.func_72839_b(eResult.func_216348_a(), new AxisAlignedBB(-8.0, -8.0, -8.0, 8.0, 8.0, 8.0).func_191194_a(eResult.func_216347_e()))) {
                                if (e2.equals((Object)player) || !(e2 instanceof LivingEntity)) continue;
                                this.spell.getSpell().cast(player, e2, this.spellMod, effectivePotency);
                            }
                            break;
                        }
                        BlockRayTraceResult bResult = (BlockRayTraceResult)channelResult;
                        cast = this.spell.getSpell().cast(player, bResult.func_216350_a(), bResult.func_216354_b(), this.spellMod, effectivePotency);
                        break;
                    }
                }
                if (cast) {
                    DataStorageHelper.incrementObjective(player, EObjective.CAST_SPELLS_FOR_COMPLEX);
                    if (cost > 2000) {
                        DataStorageHelper.incrementObjective(player, EObjective.CAST_SPELLS_FOR_ULTIMATE);
                    }
                    this.drainCostPreCalc(player, pips, cost);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean blockCast(PlayerEntity player, BlockPos pos, Direction dir, boolean wand, boolean pips, int rodLevel) {
        if (ModHelper.isServerWorld(player.func_130014_f_())) {
            boolean flag;
            int cost = 0;
            if (!pips) {
                cost = DataStorageHelper.getManaCost(this.manaCost(), this.spell.element, player);
            }
            boolean bl = flag = player.func_184812_l_() || this.rodPowerfulEnough(rodLevel, cost) && this.canCastPreCalc(player, pips, cost) && this.spell.getSpell().attemptCast(player) && this.focus.getFocus().attemptCast(player);
            if (flag) {
                boolean cast = false;
                double effectivePotency = this.effectivePotency(0, wand);
                switch (this.focus) {
                    case TOUCH: {
                        cast = this.spell.getSpell().cast(player, pos, dir, this.spellMod, effectivePotency);
                        break;
                    }
                }
                if (cast) {
                    DataStorageHelper.incrementObjective(player, EObjective.CAST_SPELLS_FOR_COMPLEX);
                    if (cost > 2000) {
                        DataStorageHelper.incrementObjective(player, EObjective.CAST_SPELLS_FOR_ULTIMATE);
                    }
                    this.drainCostPreCalc(player, pips, cost);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean entityCast(PlayerEntity player, LivingEntity target, boolean wand, boolean pips, int rodLevel) {
        if (ModHelper.isServerWorld(player.func_130014_f_())) {
            boolean flag;
            int cost = 0;
            if (!pips) {
                cost = DataStorageHelper.getManaCost(this.manaCost(), this.spell.element, player);
            }
            boolean bl = flag = player.func_184812_l_() || this.rodPowerfulEnough(rodLevel, cost) && this.canCastPreCalc(player, pips, cost) && this.spell.getSpell().attemptCast(player) && this.focus.getFocus().attemptCast(player);
            if (flag) {
                boolean cast = false;
                double effectivePotency = this.effectivePotency(0, wand);
                switch (this.focus) {
                    case TOUCH: {
                        cast = this.spell.getSpell().cast(player, target, this.spellMod, effectivePotency);
                        break;
                    }
                }
                if (cast) {
                    DataStorageHelper.incrementObjective(player, EObjective.CAST_SPELLS_FOR_COMPLEX);
                    if (cost > 2000) {
                        DataStorageHelper.incrementObjective(player, EObjective.CAST_SPELLS_FOR_ULTIMATE);
                    }
                    this.drainCostPreCalc(player, pips, cost);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canCast(PlayerEntity player, boolean pips) {
        if (player.func_184812_l_()) {
            return true;
        }
        return pips ? this.drainPips(player, true) : this.drainMana(player, true);
    }

    public boolean canCastPreCalc(PlayerEntity player, boolean pips, int cost) {
        if (player.func_184812_l_()) {
            return true;
        }
        return pips ? this.drainPips(player, true) : this.drainManaPreCalc(player, true, cost);
    }

    public void drainCostPreCalc(PlayerEntity player, boolean pips, int cost) {
        if (player.func_184812_l_()) {
            return;
        }
        if (pips) {
            this.drainPips(player, false);
        } else {
            this.drainManaPreCalc(player, false, cost);
        }
    }

    public void drainCost(PlayerEntity player, boolean pips) {
        if (player.func_184812_l_()) {
            return;
        }
        if (pips) {
            this.drainPips(player, false);
        } else {
            this.drainMana(player, false);
        }
    }

    public boolean drainMana(PlayerEntity player, boolean simulate) {
        return this.drainManaPreCalc(player, simulate, DataStorageHelper.getManaCost(this.manaCost(), this.spell.element, player));
    }

    public boolean drainManaPreCalc(PlayerEntity player, boolean simulate, int manaCost) {
        ManaSavedData savedData = ManaSavedData.get(player);
        ManaData data = (ManaData)((ManaCollection)savedData.data).get(player);
        if (data.mana >= manaCost) {
            if (!simulate) {
                data.mana -= manaCost;
                savedData.func_76185_a();
                ((ManaCollection)savedData.data).syncToClient((ServerPlayerEntity)player);
            }
            return true;
        }
        ModHelper.insufficientMana(player);
        return false;
    }

    public boolean drainPips(PlayerEntity player, boolean simulate) {
        return DataStorageHelper.drainPips(player, this.pipCost(), simulate);
    }

    public double effectivePotency(int chargeTime, boolean wand) {
        SpellFocus f = this.getFocus();
        double val = this.potency;
        if (wand) {
            val -= 1.0;
        }
        return (val += (double)chargeTime / 50.0) * f.potencyModifier();
    }

    public int manaCost() {
        Spell s = this.getSpell();
        SpellFocus f = this.getFocus();
        int val = s.getManaCost(this.potency, this.frugal, this.spellMod) + f.getManaCost(this.sliderVal, this.modifier);
        val = (int)((double)val * s.getCostModifier());
        val = (int)((double)val * f.getCostModifier());
        return val;
    }

    public int pipCost() {
        Spell s = this.getSpell();
        SpellFocus f = this.getFocus();
        int val = s.getPipCost(this.potency, this.frugal, this.spellMod) + f.getPipCost(this.sliderVal, this.modifier);
        val = (int)((double)val * s.getCostModifier());
        val = (int)((double)val * f.getCostModifier());
        return val;
    }

    public CompoundNBT serialise() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("spell", this.spell.ordinal());
        nbt.func_74768_a("focus", this.focus.ordinal());
        nbt.func_74780_a("potency", this.potency);
        nbt.func_74780_a("slider", this.sliderVal);
        nbt.func_74757_a("modifier", this.modifier);
        nbt.func_74757_a("frugal", this.frugal);
        nbt.func_74757_a("spellMod", this.spellMod);
        nbt.func_74757_a("charging", this.charging);
        return nbt;
    }

    public static SpellContainer createFromNbt(CompoundNBT nbt) {
        String name = nbt.func_74779_i("name");
        ESpell spell = ESpell.values()[nbt.func_74762_e("spell")];
        ESpellFocus focus = ESpellFocus.values()[nbt.func_74762_e("focus")];
        double potency = nbt.func_74769_h("potency");
        double slider = nbt.func_74769_h("slider");
        boolean modifier = nbt.func_74767_n("modifier");
        boolean frugal = nbt.func_74767_n("frugal");
        boolean spellMod = nbt.func_74767_n("spellMod");
        boolean charging = nbt.func_74767_n("charging");
        return new SpellContainer(name, focus, spell, slider, modifier, charging, frugal, spellMod, potency);
    }
}

