/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Spells;

import com.cobbs.lordcraft.Spells.ESpellFocus;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;

public abstract class SpellFocus {
    public static List<SpellFocus> foci = new ArrayList<SpellFocus>();
    private static int cIndex = 0;
    public final String name;
    public final int indexX;
    public final int indexY;
    public final int baseCost;
    public final int basePips;
    public final boolean sliderModifier;
    public final boolean checkModifier;
    public final boolean charging;
    public final int index;

    public SpellFocus(String name, int indexX, int indexY, int baseCost, int basePips, boolean sliderModifier, boolean checkModifier, boolean charging) {
        this.name = name;
        this.indexX = indexX;
        this.indexY = indexY;
        this.baseCost = baseCost;
        this.basePips = basePips;
        this.sliderModifier = sliderModifier;
        this.checkModifier = checkModifier;
        this.charging = charging;
        this.index = cIndex++;
        foci.add(this);
    }

    public String getTranslationName() {
        return ModHelper.concat("lordcraft.focus.", this.name);
    }

    public String getLocalName() {
        return I18n.func_135052_a((String)this.getTranslationName(), (Object[])new Object[0]);
    }

    public double getCostModifier() {
        return 1.0;
    }

    public double potencyModifier() {
        return 1.0;
    }

    public int getManaCost(double sliderVal, boolean checkModifier) {
        double val = this.baseCost;
        val *= sliderVal;
        if (checkModifier) {
            val *= this.getModifierCostMultiplier();
        }
        return (int)val;
    }

    public int getPipCost(double sliderVal, boolean checkModifier) {
        double val = this.basePips;
        val *= sliderVal;
        if (checkModifier) {
            val *= this.getModifierCostMultiplier();
        }
        return (int)val;
    }

    public static SpellFocus getFocus(ESpellFocus focus) {
        return foci.get(focus.ordinal());
    }

    public String getModifierName() {
        return "";
    }

    public String getSliderName() {
        return "lordcraft.spell.tooltip_range";
    }

    public double getSliderMultiplier() {
        return 1.0;
    }

    public double getModifierCostMultiplier() {
        return 1.0;
    }

    public abstract boolean attemptCast(PlayerEntity var1);
}

