/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements.BookElements;

import com.cobbs.lordcraft.Items.Book.BookScreen;
import com.cobbs.lordcraft.Items.Book.EBookMode;
import com.cobbs.lordcraft.UI.Elements.Buttons.SheetButton;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.RenderHelper;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class BookMenuButton
extends SheetButton {
    private EBookMode mode;

    public BookMenuButton(BookScreen container, int x, int y, EBookMode mode) {
        super(container, x, y, 26, 26, 0, 138, 0);
        this.mode = mode;
    }

    @Override
    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        super.draw(stack, currentSheet, mouseX, mouseY);
        this.drawFront(stack, currentSheet, mouseX, mouseY);
        return this.setupSpriteSheet();
    }

    public void drawFront(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        ItemStack stack1 = this.mode.display;
        RenderHelper.renderItemIntoGui(stack1, this.x + 5, this.y + 5);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int mouseButton) {
        BookScreen screen = (BookScreen)this.container;
        screen.setMode(this.mode);
        SoundHelper.page_turn();
    }

    @Override
    public boolean canDraw() {
        BookScreen screen = (BookScreen)this.container;
        return super.canDraw() && screen.getMode() == EBookMode.MAIN;
    }

    @Override
    public List<IReorderingProcessor> getTooltip() {
        return ModHelper.wrap(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)ModHelper.concat("lordcraft.book_mode.", this.mode.toString().toLowerCase()), (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240712_a_(TextFormatting.AQUA)));
    }
}

