/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements.BookElements;

import com.cobbs.lordcraft.Items.Book.BookScreen;
import com.cobbs.lordcraft.Items.Book.EBookMode;
import com.cobbs.lordcraft.UI.Elements.GuiElement;
import com.cobbs.lordcraft.UI.Elements.IClickable;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.RenderHelper;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.Style;

public class LookupButton
extends GuiElement
implements IClickable {
    private int index = 0;

    public LookupButton(BookScreen container, int x, int y, int index) {
        super(container, x, y);
        this.index = index;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int mouseButton) {
        BookScreen screen = (BookScreen)this.container;
        screen.lookupStack = this.getItemStack();
        screen.displayTextPage(0);
        SoundHelper.page_turn();
    }

    @Override
    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        super.draw(stack, currentSheet, mouseX, mouseY);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_227740_m_();
        this.container.getGui().func_238474_b_(stack, this.x, this.y, this.hovering(mouseX, mouseY) ? 26 : 0, 138, 26, 26);
        RenderHelper.renderItemIntoGui(this.getItemStack(), this.x + 5, this.y + 5);
        return this.setupSpriteSheet();
    }

    @Override
    public int getHeight() {
        return 26;
    }

    @Override
    public int getWidth() {
        return 26;
    }

    @Override
    public List<IReorderingProcessor> getTooltip() {
        return ModHelper.wrap(IReorderingProcessor.func_242239_a((String)this.getItemStack().func_200301_q().getString(), (Style)Style.field_240709_b_));
    }

    public ItemStack getItemStack() {
        BookScreen screen = (BookScreen)this.container;
        int effectiveIndex = this.index + screen.lookupPage * 56;
        NonNullList<ItemStack> list = screen.lookupOptions;
        if (effectiveIndex < list.size()) {
            return (ItemStack)list.get(effectiveIndex);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean canDraw() {
        BookScreen screen = (BookScreen)this.container;
        return super.canDraw() && screen.getMode() == EBookMode.SEARCH && !this.getItemStack().func_190926_b();
    }
}

