/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements.BookElements;

import com.cobbs.lordcraft.Items.Book.BookScreen;
import com.cobbs.lordcraft.Items.Book.EBookMode;
import com.cobbs.lordcraft.Passives.EPassive;
import com.cobbs.lordcraft.UI.Elements.Buttons.SheetButton;
import com.cobbs.lordcraft.Util.Client.ClientData;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.NetworkHelper;
import com.cobbs.lordcraft.Util.Helpers.RenderHelper;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class PassiveButton
extends SheetButton {
    private String[] states = new String[]{"lordcraft.book.unavailable", "lordcraft.book.disabled", "lordcraft.book.enabled"};
    private TextFormatting[] statesF = new TextFormatting[]{TextFormatting.DARK_RED, TextFormatting.YELLOW, TextFormatting.AQUA};
    private EPassive passive;

    public PassiveButton(BookScreen container, int x, int y, EPassive passive) {
        super(container, x, y, 26, 26, 0, 138, 0);
        this.passive = passive;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            NetworkHelper.dataToServer("pb", this.passive.ordinal());
        } else {
            BookScreen screen = (BookScreen)this.container;
            screen.passiveTarget = this.passive;
            screen.displayTextPage(this.passive.ordinal());
            SoundHelper.page_turn();
        }
    }

    @Override
    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        super.draw(stack, currentSheet, mouseX, mouseY);
        RenderHelper.renderItemIntoGui(this.passive.stack, this.x + 5, this.y + 5);
        GlStateManager.func_227740_m_();
        return this.setupSpriteSheet();
    }

    @Override
    public int getU() {
        int val = ClientData.passiveData.getState(this.passive);
        int pips = ClientData.manaData.maxPips;
        if (val == 1) {
            if (pips < this.passive.pipCost) {
                val = 0;
            }
            if (!this.passive.getPassive().canEnable(ClientData.passiveData)) {
                val = 0;
            }
        }
        int offset = 0;
        switch (val) {
            case 0: {
                offset = 52;
                break;
            }
            case 2: {
                offset = 104;
            }
        }
        return super.getU() + offset;
    }

    @Override
    public boolean canDraw() {
        BookScreen screen = (BookScreen)this.container;
        return super.canDraw() && screen.getMode() == EBookMode.ABILITY && ClientData.passiveData.getState(this.passive) != 3;
    }

    @Override
    public List<IReorderingProcessor> getTooltip() {
        int val = ClientData.passiveData.getState(this.passive);
        int pips = ClientData.manaData.maxPips;
        if (val == 1) {
            if (pips < this.passive.pipCost) {
                val = 0;
            }
            if (!this.passive.getPassive().canEnable(ClientData.passiveData)) {
                val = 0;
            }
        }
        LinkedList<IReorderingProcessor> tooltip = new LinkedList<IReorderingProcessor>();
        tooltip.add(ModHelper.makeProcessor(ModHelper.concat(I18n.func_135052_a((String)this.passive.unlocalname(), (Object[])new Object[0]), ": "), TextFormatting.WHITE, I18n.func_135052_a((String)this.states[val], (Object[])new Object[0]), this.statesF[val]));
        if (this.passive.pipCost > 0) {
            tooltip.add(ModHelper.makeProcessor(ModHelper.concat(I18n.func_135052_a((String)"lordcraft.tooltip.mana_cost", (Object[])new Object[0]), " "), TextFormatting.WHITE, "" + this.passive.pipCost, TextFormatting.AQUA));
        }
        tooltip.add(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.right_click_info", (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)));
        return tooltip;
    }
}

