/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements.BookElements;

import com.cobbs.lordcraft.Items.Book.BookScreen;
import com.cobbs.lordcraft.Items.Book.EBookMode;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Research.EResearchState;
import com.cobbs.lordcraft.Research.ResearchInstance;
import com.cobbs.lordcraft.UI.Elements.GuiElement;
import com.cobbs.lordcraft.UI.Elements.IClickable;
import com.cobbs.lordcraft.Util.Client.ClientData;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.RenderHelper;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class ResearchButton
extends GuiElement
implements IClickable {
    private static final Style title = Style.field_240709_b_.func_240721_b_(TextFormatting.AQUA);
    private static final Style normal = Style.field_240709_b_.func_240721_b_(TextFormatting.DARK_AQUA);
    private static final Style requires = Style.field_240709_b_.func_240721_b_(TextFormatting.YELLOW);
    private static final Style complete = Style.field_240709_b_.func_240721_b_(TextFormatting.DARK_GREEN);
    private static final Style locked = Style.field_240709_b_.func_240721_b_(TextFormatting.RED);
    private static final Style req = Style.field_240709_b_.func_240721_b_(TextFormatting.GOLD);
    public EResearch research;
    public int element = -1;

    public ResearchButton(BookScreen container, int x, int y, EResearch research) {
        super(container, x, y);
        this.research = research;
        container.resButtons.put(research, this);
    }

    public ResearchButton(BookScreen container, int x, int y, int element, EResearch research) {
        this(container, x, y, research);
        this.element = element;
        container.resButtons.put(research, this);
    }

    @Override
    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        super.draw(stack, currentSheet, mouseX, mouseY);
        EResearchState state = ClientData.researchData.getState(this.research);
        int dX = 0;
        int dY = 138;
        switch (state) {
            case LOCKED: {
                dX = 52;
                break;
            }
            case COMPLETE: {
                dX = 104;
                break;
            }
            case REQUIRES: {
                dX = 156;
            }
        }
        this.container.getGui().func_238474_b_(stack, this.x, this.y, dX + (this.hovering(mouseX, mouseY) ? 26 : 0), dY, 26, 26);
        this.drawFront(stack, currentSheet, mouseX, mouseY);
        return this.setupSpriteSheet();
    }

    public void drawFront(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        RenderHelper.renderItemIntoGui(this.research.display, this.x + 5, this.y + 5);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int mouseButton) {
        BookScreen screen = (BookScreen)this.container;
        EResearchState state = ClientData.researchData.getState(this.research);
        if (state == EResearchState.COMPLETE) {
            screen.target = this.research;
            screen.displayTextPage(this.research.ordinal());
        } else if (state == EResearchState.NORMAL) {
            screen.target = this.research;
            if (this.research.getInstance().normal) {
                screen.setMode(EBookMode.RESEARCHING);
            } else {
                screen.displaying_objective = true;
                screen.displayTextPage(this.research.ordinal());
            }
        }
        SoundHelper.page_turn();
    }

    @Override
    public int getHeight() {
        return 26;
    }

    @Override
    public int getWidth() {
        return 26;
    }

    @Override
    public List<IReorderingProcessor> getTooltip() {
        EResearchState state = ClientData.researchData.getState(this.research);
        Style s = normal;
        String text = "lordcraft.res_state.normal";
        switch (state) {
            case REQUIRES: {
                text = "lordcraft.res_state.requires";
                s = requires;
                break;
            }
            case LOCKED: {
                text = "lordcraft.res_state.locked";
                s = locked;
                break;
            }
            case COMPLETE: {
                text = "lordcraft.res_state.complete";
                s = complete;
            }
        }
        ArrayList<IReorderingProcessor> list = new ArrayList<IReorderingProcessor>();
        list.add(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)this.research.unlocalname(), (Object[])new Object[0]), (Style)title));
        list.add(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)text, (Object[])new Object[0]), (Style)s));
        ResearchInstance instance = this.research.instance;
        if (state.equals((Object)EResearchState.COMPLETE)) {
            list.add(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.res_entry", (Object[])new Object[0]), (Style)requires));
        } else {
            if (state.equals((Object)EResearchState.REQUIRES) && !instance.requirements.isEmpty()) {
                list.add(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.req_res_book", (Object[])new Object[0]), (Style)req));
                for (EResearch r : instance.requirements) {
                    String did = "\u2716";
                    EResearchState rState = ClientData.researchData.getState(r);
                    Style style = locked;
                    switch (rState) {
                        case COMPLETE: {
                            style = complete;
                            did = "\u2714";
                        }
                    }
                    list.add(IReorderingProcessor.func_242239_a((String)ModHelper.concat(" -", I18n.func_135052_a((String)r.unlocalname(), (Object[])new Object[0]), ": ", did), (Style)style));
                }
            }
            if (!instance.locked.isEmpty()) {
                list.add(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.lock_res_book", (Object[])new Object[0]), (Style)req));
                for (EResearch r : instance.locked) {
                    list.add(IReorderingProcessor.func_242239_a((String)ModHelper.concat(" -", I18n.func_135052_a((String)r.unlocalname(), (Object[])new Object[0])), (Style)requires));
                }
            }
        }
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            list.add(IReorderingProcessor.func_242239_a((String)this.research.name().toLowerCase(), (Style)Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)));
        }
        return list;
    }

    @Override
    public boolean canDraw() {
        BookScreen screen = (BookScreen)this.container;
        EResearchState state = ClientData.researchData.getState(this.research);
        return super.canDraw() && screen.getMode() == EBookMode.RESEARCH && ClientData.lordicData.primaryElement != -1 && !screen.transition && screen.selectedConstellation == this.element && screen.res_tab == this.research.tab && state != EResearchState.HIDDEN && state != EResearchState.VERY_HIDDEN;
    }
}

