/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements.BookElements;

import com.cobbs.lordcraft.Items.Book.BookScreen;
import com.cobbs.lordcraft.Items.Book.EBookMode;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Research.EResearchTab;
import com.cobbs.lordcraft.UI.Elements.GuiElement;
import com.cobbs.lordcraft.UI.Elements.IClickable;
import com.cobbs.lordcraft.Util.Client.ClientData;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.RenderCore;
import com.cobbs.lordcraft.Util.Helpers.RenderHelper;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.Style;

public class ResearchTab
extends GuiElement
implements IClickable {
    private EResearchTab tab;

    public ResearchTab(BookScreen container, int x, int y, EResearchTab tab) {
        super(container, x, y);
        this.tab = tab;
    }

    @Override
    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        super.draw(stack, currentSheet, mouseX, mouseY);
        RenderCore.enableBlend();
        float[] color = ColorHelper.tabColors[this.tab.ordinal()];
        BookScreen screen = (BookScreen)this.container;
        boolean val = screen.res_tab == this.tab;
        GlStateManager.func_227702_d_((float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        this.container.getGui().func_238474_b_(stack, this.x, this.y, 216 + (this.hovering(mouseX, mouseY) ? 20 : 0), 124 + (val ? 24 : 0), 20, val ? 22 : 24);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.renderItemIntoGui(this.tab.display, this.x + 2, this.y);
        return this.setupSpriteSheet();
    }

    @Override
    public void onClick(double mouseX, double mouseY, int mouseButton) {
        BookScreen screen = (BookScreen)this.container;
        if (screen.res_tab != this.tab) {
            screen.cancelTransition();
            screen.setResearchTab(this.tab);
        }
        SoundHelper.page_turn();
    }

    @Override
    public int getHeight() {
        return 24;
    }

    @Override
    public int getWidth() {
        return 20;
    }

    @Override
    public List<IReorderingProcessor> getTooltip() {
        return ModHelper.wrap(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)this.tab.unlocalname(), (Object[])new Object[0]), (Style)this.tab.textStyle));
    }

    @Override
    public boolean canDraw() {
        boolean check1;
        BookScreen screen = (BookScreen)this.container;
        boolean bl = check1 = super.canDraw() && screen.getMode() == EBookMode.RESEARCH && ClientData.lordicData.hasElement();
        if (check1) {
            boolean shouldShow = false;
            for (EResearch r : EResearch.values()) {
                if (r.tab != this.tab || ClientData.researchData.getState(r).ordinal() <= 0) continue;
                shouldShow = true;
                break;
            }
            return shouldShow;
        }
        return false;
    }
}

