/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements.BookElements.ResearchingGrid;

import com.cobbs.lordcraft.Items.Book.BookScreen;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchingGrid.Laser;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchingGrid.ResearchingGrid;
import com.cobbs.lordcraft.Util.Helpers.InputHelper;
import com.cobbs.lordcraft.Util.Helpers.RenderHelper;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;

public class GridTile {
    private ResearchingGrid grid;
    public static final int gridOffset = 38;
    private int indexX;
    private int indexY;
    private int mirror = -1;
    private int mirrorAngle = 0;
    public boolean hasLaser;

    public GridTile(ResearchingGrid grid, int indexX, int indexY) {
        this.grid = grid;
        this.indexX = indexX;
        this.indexY = indexY;
        this.hasLaser = false;
    }

    public void draw(MatrixStack stack, int mouseX, int mouseY, boolean drawGrid) {
        GlStateManager.func_227702_d_((float)ResearchingGrid.gridColor[0], (float)ResearchingGrid.gridColor[1], (float)ResearchingGrid.gridColor[2], (float)1.0f);
        int x = this.grid.getX() + 38 + this.indexX * 18;
        int y = this.grid.getY() + 38 + this.indexY * 18;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(BookScreen.common0);
        if (drawGrid) {
            this.grid.container.getGui().func_238474_b_(stack, x, y, 0, 66, 18, 18);
        }
        if (this.hasLaser) {
            if (this.grid.solved) {
                GlStateManager.func_227702_d_((float)1.0f, (float)0.75f, (float)0.0f, (float)1.0f);
                this.grid.container.getGui().func_238474_b_(stack, x + 1, y + 1, 240, 206, 16, 16);
                GlStateManager.func_227702_d_((float)ResearchingGrid.gridColor[0], (float)ResearchingGrid.gridColor[1], (float)ResearchingGrid.gridColor[2], (float)1.0f);
            } else {
                this.grid.container.getGui().func_238474_b_(stack, x + 1, y + 1, 240, 206, 16, 16);
            }
        }
        if (this.mouseInArea(mouseX, mouseY)) {
            int offsetU = 18;
            if (this.mirror == -1) {
                this.grid.container.getGui().func_238474_b_(stack, x, y, offsetU, 66, 18, 18);
                RenderHelper.renderItemIntoGui(this.grid.mirrorStack[this.grid.mirrorAngle], x + 1, y + 1);
            } else {
                GlStateManager.func_227702_d_((float)1.0f, (float)0.75f, (float)0.0f, (float)1.0f);
                this.grid.container.getGui().func_238474_b_(stack, x, y, offsetU, 66, 18, 18);
            }
        }
        if (this.mirror != -1) {
            RenderHelper.renderItemIntoGui(ResearchingGrid.mirrorStacks[this.mirror][this.mirrorAngle], x + 1, y + 1);
        }
    }

    public boolean onClick(double mouseX, double mouseY, int mouseButton) {
        if (this.mouseInArea((int)mouseX, (int)mouseY)) {
            if (mouseButton == 0) {
                this.placeMirror();
                return true;
            }
            this.pickupMirror();
            return true;
        }
        return false;
    }

    public boolean mouseInArea(int mouseX, int mouseY) {
        int x = this.grid.getX() + 38 + this.indexX * 18;
        int y = this.grid.getY() + 38 + this.indexY * 18;
        return InputHelper.mouseInArea(mouseX, mouseY, x, y, x + 18, y + 18);
    }

    public void placeMirror() {
        if (this.mirror < 3 && this.grid.mirrorCounts[this.grid.mirrorSelect] > 0) {
            this.clearMirror();
            this.mirror = this.grid.mirrorSelect;
            this.mirrorAngle = this.grid.mirrorAngle;
            int n = this.grid.mirrorSelect;
            this.grid.mirrorCounts[n] = this.grid.mirrorCounts[n] - 1;
            this.grid.update();
            SoundHelper.bong((PlayerEntity)Minecraft.func_71410_x().field_71439_g, 0.25f);
        }
    }

    public boolean clearMirror() {
        if (this.mirror != -1 && this.mirror < 3) {
            int n = this.mirror;
            this.grid.mirrorCounts[n] = this.grid.mirrorCounts[n] + 1;
            this.forceRemoveMirror();
            return true;
        }
        return false;
    }

    public void forceRemoveMirror() {
        this.mirror = -1;
    }

    public void setMirror(int val, int dir) {
        this.mirror = val;
        this.mirrorAngle = dir;
    }

    public void pickupMirror() {
        if (this.clearMirror()) {
            this.grid.update();
            SoundHelper.fwoop((PlayerEntity)Minecraft.func_71410_x().field_71439_g, 0.25f);
        }
    }

    public void rotateMirrorFwd() {
        if (this.mirror < 3) {
            int val = this.mirrorAngle;
            if (++val == ResearchingGrid.mirrorStacks[this.mirror].length) {
                val = 0;
            }
            this.mirrorAngle = val;
        }
    }

    public void rotateMirrorBck() {
        if (this.mirror < 3) {
            int val = this.mirrorAngle;
            if (--val == -1) {
                val += ResearchingGrid.mirrorStacks[this.mirror].length;
            }
            this.mirrorAngle = val;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double direction) {
        if (this.mirror != -1 && this.mouseInArea((int)mouseX, (int)mouseY)) {
            if (direction < 0.0) {
                this.rotateMirrorBck();
            } else {
                this.rotateMirrorFwd();
            }
            return true;
        }
        return false;
    }

    public boolean isClear() {
        return this.mirror == -1;
    }

    public int getMirror() {
        return this.mirror;
    }

    public int getMirrorAngle() {
        return this.mirrorAngle;
    }

    public boolean laserInteract(Laser l) {
        int i = 0;
        int nDir = -1;
        switch (this.mirror) {
            case 0: {
                i = l.dir;
                nDir = this.intractionMirror(this.mirrorAngle, i);
                if (nDir != -1) {
                    Laser las = new Laser(this.grid, this.indexX, this.indexY, nDir);
                    las.calculateLength();
                }
                return false;
            }
            case 1: {
                i = l.dir;
                int[] out = this.interactionSplitter(this.mirrorAngle, i);
                if (out != null) {
                    int max = out.length;
                    for (int j = 0; j < max; ++j) {
                        Laser las = new Laser(this.grid, this.indexX, this.indexY, out[j]);
                        las.calculateLength();
                    }
                }
                return false;
            }
            case 2: {
                i = l.dir;
                nDir = this.interactionDualMirror(this.mirrorAngle, i);
                if (nDir != -1) {
                    Laser las = new Laser(this.grid, this.indexX, this.indexY, nDir);
                    las.calculateLength();
                }
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                if (!this.hasLaser) {
                    this.hasLaser = true;
                    ++this.grid.hasLasers;
                }
                return false;
            }
        }
        return true;
    }

    public int intractionMirror(int state, int dir) {
        int nDir = -1;
        block0 : switch (state) {
            case 0: {
                switch (dir) {
                    case 2: {
                        nDir = 3;
                        break;
                    }
                    case 1: {
                        nDir = 0;
                    }
                }
                break;
            }
            case 3: {
                switch (dir) {
                    case 0: {
                        nDir = 3;
                        break;
                    }
                    case 1: {
                        nDir = 2;
                    }
                }
                break;
            }
            case 2: {
                switch (dir) {
                    case 3: {
                        nDir = 2;
                        break;
                    }
                    case 0: {
                        nDir = 1;
                    }
                }
                break;
            }
            case 1: {
                switch (dir) {
                    case 3: {
                        nDir = 0;
                        break block0;
                    }
                    case 2: {
                        nDir = 1;
                    }
                }
            }
        }
        return nDir;
    }

    public int interactionDualMirror(int state, int dir) {
        int nDir = -1;
        block0 : switch (state) {
            case 0: {
                switch (dir) {
                    case 3: {
                        nDir = 2;
                        break;
                    }
                    case 0: {
                        nDir = 1;
                        break;
                    }
                    case 1: {
                        nDir = 0;
                        break;
                    }
                    case 2: {
                        nDir = 3;
                    }
                }
                break;
            }
            case 1: {
                switch (dir) {
                    case 3: {
                        nDir = 0;
                        break block0;
                    }
                    case 0: {
                        nDir = 3;
                        break block0;
                    }
                    case 1: {
                        nDir = 2;
                        break block0;
                    }
                    case 2: {
                        nDir = 1;
                    }
                }
            }
        }
        return nDir;
    }

    public int[] interactionSplitter(int state, int dir) {
        int[] nDir = null;
        switch (state) {
            case 0: {
                if (dir != 2) break;
                nDir = new int[]{1, 3};
                break;
            }
            case 1: {
                if (dir != 3) break;
                nDir = new int[]{0, 2};
                break;
            }
            case 2: {
                if (dir != 0) break;
                nDir = new int[]{1, 3};
                break;
            }
            case 3: {
                if (dir != 1) break;
                nDir = new int[]{0, 2};
            }
        }
        return nDir;
    }
}

