/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements.BookElements.ResearchingGrid;

import com.cobbs.lordcraft.Entries.ModBlocks;
import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Items.Book.BookScreen;
import com.cobbs.lordcraft.Items.Book.EBookMode;
import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchingGrid.GridTile;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchingGrid.Laser;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchingGrid.ResearchCompletionButton;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchingGrid.ResearchForceCompletionButton;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchingGrid.ResearchGridButton;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchingGrid.ResearchGridMirrorButton;
import com.cobbs.lordcraft.UI.Elements.BookElements.ResearchingGrid.ResearchHelpButton;
import com.cobbs.lordcraft.UI.Elements.GuiElement;
import com.cobbs.lordcraft.UI.Elements.IClickable;
import com.cobbs.lordcraft.UI.Elements.IScrollHandler;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class ResearchingGrid
extends GuiElement
implements IClickable,
IScrollHandler {
    public static final int gridSize = 10;
    private boolean grid = false;
    public GridTile[][] tiles = new GridTile[10][10];
    private ResearchGridMirrorButton[] mirrorButtons = new ResearchGridMirrorButton[3];
    private ResearchGridButton forceCompletionButton;
    private ResearchGridButton completionButton;
    private ResearchGridButton helpButton;
    protected List<Laser> lasers = new ArrayList<Laser>();
    private static ResourceLocation border = new ResourceLocation("lordcraft", "textures/gui/constellation/research_border.png");
    public static ResourceLocation[] laserTex = new ResourceLocation[]{new ResourceLocation("lordcraft", "textures/effect/laser1.png"), new ResourceLocation("lordcraft", "textures/effect/laser2.png")};
    public static float[] gridColor = ColorHelper.rgbTo3f(new Color(0, 160, 160).getRGB());
    private static float[] borderColor = ColorHelper.rgbTo3f(new Color(0, 128, 0).getRGB());
    public static ItemStack[][] mirrorStacks;
    public static ItemStack imbuedStack;
    public int mirrorSelect = 0;
    public int mirrorAngle = 0;
    public boolean solved = false;
    public int hadLasers = 0;
    public int hasLasers = 0;
    public ItemStack[] mirrorStack = mirrorStacks[0];
    public int[] mirrorCounts = new int[]{0, 0, 0};
    public int startX;
    public int startY;
    public int startDir;
    public List<Point> ends;

    public ResearchingGrid(BookScreen container, int x, int y) {
        super(container, x, y);
        int i;
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                this.tiles[i][j] = new GridTile(this, i, j);
            }
        }
        for (i = 0; i < 3; ++i) {
            this.mirrorButtons[i] = new ResearchGridMirrorButton(this, i);
        }
        this.forceCompletionButton = new ResearchForceCompletionButton(this);
        this.completionButton = new ResearchCompletionButton(this);
        this.helpButton = new ResearchHelpButton(this);
        this.ends = new LinkedList<Point>();
    }

    @Override
    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        super.draw(stack, currentSheet, mouseX, mouseY);
        for (ResearchGridMirrorButton button : this.mirrorButtons) {
            button.draw(stack, mouseX, mouseY);
            this.setupSpriteSheet();
        }
        this.completionButton.draw(stack, mouseX, mouseY);
        this.helpButton.draw(stack, mouseX, mouseY);
        this.forceCompletionButton.draw(stack, mouseX, mouseY);
        this.setupSpriteSheet();
        ResearchGridMirrorButton[] researchGridMirrorButtonArray = this.tiles;
        int n = researchGridMirrorButtonArray.length;
        for (int i = 0; i < n; ++i) {
            ResearchGridMirrorButton gTiles;
            for (ResearchGridMirrorButton tile : gTiles = researchGridMirrorButtonArray[i]) {
                GlStateManager.func_227740_m_();
                ((GridTile)((Object)tile)).draw(stack, mouseX, mouseY, this.grid);
            }
        }
        GlStateManager.func_227740_m_();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(border);
        GlStateManager.func_227702_d_((float)borderColor[0], (float)borderColor[1], (float)borderColor[2], (float)1.0f);
        this.container.getGui().func_238474_b_(stack, this.x, this.y, 0, 0, 256, 256);
        this.renderLasers();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return this.setupSpriteSheet();
    }

    @Override
    public void onClick(double mouseX, double mouseY, int mouseButton) {
        boolean click = false;
        for (ResearchGridMirrorButton researchGridMirrorButton : this.mirrorButtons) {
            if (!researchGridMirrorButton.onClick(mouseX, mouseY, mouseButton)) continue;
            click = true;
            break;
        }
        this.forceCompletionButton.onClick(mouseX, mouseY, mouseButton);
        this.completionButton.onClick(mouseX, mouseY, mouseButton);
        this.helpButton.onClick(mouseX, mouseY, mouseButton);
        if (!click) {
            for (ResearchGridMirrorButton researchGridMirrorButton : this.tiles) {
                boolean did = false;
                for (ResearchGridMirrorButton tile : researchGridMirrorButton) {
                    if (!((GridTile)((Object)tile)).onClick(mouseX, mouseY, mouseButton)) continue;
                    did = true;
                    break;
                }
                if (did) break;
            }
        }
    }

    @Override
    public int getHeight() {
        return 256;
    }

    @Override
    public int getWidth() {
        return 256;
    }

    @Override
    public List<IReorderingProcessor> getTooltip() {
        if (this.forceCompletionButton.isHovering) {
            return ModHelper.wrap(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.res_force", (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)));
        }
        if (this.completionButton.isHovering) {
            return ModHelper.wrap(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.res_attempt", (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)));
        }
        if (this.helpButton.isHovering) {
            return ModHelper.wrap(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.res_help", (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)));
        }
        return new ArrayList<IReorderingProcessor>();
    }

    @Override
    public boolean canDraw() {
        return super.canDraw() && ((BookScreen)this.container).getMode() == EBookMode.RESEARCHING;
    }

    public static void initClient() {
        mirrorStacks = new ItemStack[][]{{new ItemStack((IItemProvider)ModBlocks.MIRROR), new ItemStack((IItemProvider)ModItems.MIRROR1), new ItemStack((IItemProvider)ModItems.MIRROR2), new ItemStack((IItemProvider)ModItems.MIRROR3)}, {new ItemStack((IItemProvider)ModBlocks.SPLITTER), new ItemStack((IItemProvider)ModItems.SPLITTER1), new ItemStack((IItemProvider)ModItems.SPLITTER2), new ItemStack((IItemProvider)ModItems.SPLITTER3)}, {new ItemStack((IItemProvider)ModBlocks.DUAL_MIRROR), new ItemStack((IItemProvider)ModItems.DUAL_MIRROR1)}, {new ItemStack((IItemProvider)ModBlocks.START), new ItemStack((IItemProvider)ModItems.START1), new ItemStack((IItemProvider)ModItems.START2), new ItemStack((IItemProvider)ModItems.START3)}, {new ItemStack((IItemProvider)ModBlocks.END)}};
        imbuedStack = new ItemStack((IItemProvider)ModItems.INSCRIPTION_TILE);
    }

    public void setup(EResearch research) {
        this.hadLasers = 0;
        this.ends.clear();
        this.setMirrorStack(0);
        this.placeStart();
        this.placeEnds(research.difficulty);
        this.mirrorCounts[0] = research.difficulty;
        this.mirrorCounts[1] = research.difficulty - 1;
        this.mirrorCounts[2] = research.difficulty / 2;
        this.update();
    }

    public void placeStart() {
        this.startX = ModHelper.rand.nextInt(8) + 1;
        this.startY = ModHelper.rand.nextInt(8) + 1;
        this.startDir = ModHelper.rand.nextInt(4);
        this.tiles[this.startX][this.startY].setMirror(3, this.startDir);
    }

    public void placeEnds(int count) {
        for (int i = 0; i < count; ++i) {
            int tempX = 0;
            int tempY = 0;
            while (true) {
                tempX = ModHelper.rand.nextInt(10);
                tempY = ModHelper.rand.nextInt(10);
                int distanceX = Math.abs(this.startX - tempX);
                int distanceY = Math.abs(this.startY - tempY);
                if (distanceX < 2 && distanceY < 2) continue;
                boolean worked = true;
                for (Point p : this.ends) {
                    distanceX = Math.abs(p.x - tempX);
                    distanceY = Math.abs(p.y - tempY);
                    if (distanceX >= 2 || distanceY >= 2) continue;
                    worked = false;
                    break;
                }
                if (worked) break;
            }
            this.ends.add(new Point(tempX, tempY));
            this.tiles[tempX][tempY].setMirror(4, 0);
        }
    }

    public void renderLasers() {
        GlStateManager.func_227702_d_((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Laser las : this.lasers) {
            las.draw();
        }
    }

    public void update() {
        this.hadLasers = this.hasLasers;
        this.hasLasers = 0;
        int max = this.ends.size();
        for (int i = 0; i < max; ++i) {
            this.tiles[this.ends.get((int)i).x][this.ends.get((int)i).y].hasLaser = false;
        }
        this.lasers.clear();
        Laser l = new Laser(this, this.startX, this.startY, this.startDir);
        l.calculateLength();
        this.tiles[this.startX][this.startY].hasLaser = this.solved = this.solved();
        if (this.hasLasers > this.hadLasers) {
            if (this.solved) {
                SoundHelper.glow_ready();
            } else {
                SoundHelper.glow_complete();
            }
        }
    }

    public boolean solved() {
        boolean val = true;
        for (Point p : this.ends) {
            val = this.tiles[p.x][p.y].hasLaser;
            if (val) continue;
            break;
        }
        return val;
    }

    public void exit() {
        GridTile[][] gridTileArray = this.tiles;
        int n = gridTileArray.length;
        for (int i = 0; i < n; ++i) {
            GridTile[] gTiles;
            for (GridTile t : gTiles = gridTileArray[i]) {
                t.forceRemoveMirror();
                t.hasLaser = false;
            }
        }
    }

    public void setMirrorStack(int index) {
        this.mirrorAngle = 0;
        this.mirrorSelect = index;
        this.mirrorStack = mirrorStacks[index];
    }

    public void nextMirrorStack() {
        int val = this.mirrorSelect;
        val = val == 2 ? 0 : ++val;
        this.setMirrorStack(val);
    }

    public void prevMirrorStack() {
        int val = this.mirrorSelect;
        val = val == 0 ? 2 : --val;
        this.setMirrorStack(val);
    }

    public void rotateStackFwd() {
        int val = this.mirrorAngle;
        if (++val == this.mirrorStack.length) {
            val = 0;
        }
        this.mirrorAngle = val;
    }

    public void rotateStackBck() {
        int val = this.mirrorAngle;
        if (--val == -1) {
            val += this.mirrorStack.length;
        }
        this.mirrorAngle = val;
    }

    @Override
    public void mouseScrolled(double mouseX, double mouseY, double direction) {
        boolean scroll = false;
        if (Screen.func_231173_s_()) {
            if (direction < 0.0) {
                this.nextMirrorStack();
            } else {
                this.prevMirrorStack();
            }
        } else {
            for (GridTile[] gTiles : this.tiles) {
                boolean did = false;
                for (GridTile tile : gTiles) {
                    if (!tile.mouseScrolled(mouseX, mouseY, direction)) continue;
                    this.update();
                    did = true;
                    break;
                }
                if (!did) continue;
                scroll = true;
                break;
            }
            if (!scroll) {
                if (direction < 0.0) {
                    this.rotateStackBck();
                } else {
                    this.rotateStackFwd();
                }
            }
        }
    }

    public int getRequiredTiles() {
        BookScreen screen = (BookScreen)this.container;
        return screen.target.difficulty;
    }
}

