/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements.Buttons;

import com.cobbs.lordcraft.Items.Book.BookScreen;
import com.cobbs.lordcraft.Items.Book.EBookMode;
import com.cobbs.lordcraft.Research.EResearchTab;
import com.cobbs.lordcraft.UI.Elements.GuiElement;
import com.cobbs.lordcraft.UI.Elements.IClickable;
import com.cobbs.lordcraft.UI.IGui;
import com.cobbs.lordcraft.Util.Client.ClientData;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.NetworkHelper;
import com.cobbs.lordcraft.Util.Helpers.RenderCore;
import com.cobbs.lordcraft.Util.Helpers.SoundHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class LegacySelectButton
extends GuiElement
implements IClickable {
    private int index = 0;

    public LegacySelectButton(BookScreen container, int index) {
        super((IGui)container, 48, 44 + 44 * index, 0);
        this.index = index;
    }

    @Override
    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        int leg;
        int toReturn = super.draw(stack, currentSheet, mouseX, mouseY);
        int u = 0;
        if (this.hovering(mouseX, mouseY)) {
            u += 64;
            RenderCore.color3f((float)1.0f, (float)1.0f, (float)0.0f);
            this.container.getGui().func_238474_b_(stack, this.x, this.y, 96, 0, 32, 32);
        }
        if ((leg = ClientData.lordicData.legacy) == this.index) {
            u = 32;
        }
        RenderCore.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.container.getGui().func_238474_b_(stack, this.x, this.y, u, 0, 32, 32);
        this.container.getGui().func_238474_b_(stack, this.x, this.y, this.index * 32, 32, 32, 32);
        return toReturn;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int mouseButton) {
        BookScreen screen = (BookScreen)this.container;
        if (mouseButton != 0) {
            screen.displayTextPage(this.index);
            SoundHelper.page_turn();
        } else if (this.index != ClientData.lordicData.legacy) {
            if (ClientData.lordicData.legacy == -1) {
                NetworkHelper.dataToServer("bsl", this.index);
                if (!ClientData.lordicData.hasElement()) {
                    screen.setMode(EBookMode.RESEARCH);
                    screen.previous_mode = EBookMode.MAIN;
                    screen.setResearchTab(EResearchTab.ELEMENTAL);
                } else {
                    screen.setMode(EBookMode.MAIN);
                }
            } else {
                NetworkHelper.dataToServer("bsl2", this.index);
            }
            SoundHelper.sparkle_noise();
        } else {
            SoundHelper.button_click();
        }
    }

    @Override
    public int getHeight() {
        return 32;
    }

    @Override
    public int getWidth() {
        return 32;
    }

    @Override
    public List<IReorderingProcessor> getTooltip() {
        Color[] color = new Color[]{Color.func_240745_a_((String)"#00ff00"), Color.func_240745_a_((String)"#ff0000")};
        List<IReorderingProcessor> list = ModHelper.wrap(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)ModHelper.concat("lordcraft.legacy.", this.index), (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)"#00ffff"))), IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)ModHelper.concat("lordcraft.legacy_bonus"), (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)"#ffff00"))), IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)ModHelper.concat("lordcraft.legacy_bonus0.", this.index), (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240718_a_(color[0])), IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)ModHelper.concat("lordcraft.legacy_bonus1.", this.index), (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240718_a_(ClientData.lordicData.legacyLevel > 0 ? color[0] : color[1])), IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)ModHelper.concat("lordcraft.legacy_bonus2.", this.index), (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240718_a_(ClientData.lordicData.legacyLevel > 1 ? color[0] : color[1])), IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)ModHelper.concat("lordcraft.right_click_info"), (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240718_a_(Color.func_240745_a_((String)"#ffff00"))));
        int leg = ClientData.lordicData.legacy;
        if (leg != -1 && leg != this.index) {
            int val = Minecraft.func_71410_x().field_71439_g.func_184812_l_() ? 0 : 20;
            list.add(IReorderingProcessor.func_242234_a((IReorderingProcessor)ModHelper.makeProcessor(I18n.func_135052_a((String)"lordcraft.legacy.cost", (Object[])new Object[0]), TextFormatting.WHITE, "" + val, TextFormatting.DARK_GREEN), (IReorderingProcessor)IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.levels", (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240712_a_(TextFormatting.WHITE))));
        }
        return list;
    }

    @Override
    public boolean canDraw() {
        return super.canDraw() && ((BookScreen)this.container).getMode() == EBookMode.LEGACY;
    }
}

