/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements.Buttons;

import com.cobbs.lordcraft.UI.Elements.GuiElement;
import com.cobbs.lordcraft.UI.Elements.IClickable;
import com.cobbs.lordcraft.UI.Elements.IHoverRender;
import com.cobbs.lordcraft.UI.IGui;
import com.cobbs.lordcraft.UI.Screens.StandardScreen;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.IReorderingProcessor;

public class SpecialButton
extends GuiElement
implements IClickable {
    protected Consumer<Integer> click;
    private int height = 18;
    private int width = 18;
    protected Supplier<List<IReorderingProcessor>> tooltip;
    private IHoverRender render;

    public SpecialButton(StandardScreen container, int x, int y, int spriteSheet, Supplier<List<IReorderingProcessor>> tooltip, Consumer<Integer> click, IHoverRender render) {
        super((IGui)container, x, y, spriteSheet);
        this.tooltip = tooltip;
        this.click = click;
        this.render = render;
        this.visible = true;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int mouseButton) {
        this.click.accept(mouseButton);
    }

    @Override
    @Nonnull
    public List<IReorderingProcessor> getTooltip() {
        return this.tooltip.get();
    }

    @Override
    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        int ret = super.draw(stack, currentSheet, mouseX, mouseY);
        this.render.render(stack, this.x, this.y, mouseX, mouseY);
        this.setupSpriteSheet();
        return ret;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }
}

