/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements;

import com.cobbs.lordcraft.Items.Book.BookScreen;
import com.cobbs.lordcraft.Items.Book.EBookMode;
import com.cobbs.lordcraft.Research.EResearchTab;
import com.cobbs.lordcraft.UI.Elements.IClickable;
import com.cobbs.lordcraft.UI.Elements.StandardElement;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.RenderCore;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;

public class Constellation
extends StandardElement
implements IClickable {
    private int index;
    public static ResourceLocation[] constellations = new ResourceLocation[]{new ResourceLocation("lordcraft", "textures/gui/constellation/water.png"), new ResourceLocation("lordcraft", "textures/gui/constellation/earth.png"), new ResourceLocation("lordcraft", "textures/gui/constellation/fire.png"), new ResourceLocation("lordcraft", "textures/gui/constellation/air.png"), new ResourceLocation("lordcraft", "textures/gui/constellation/light.png"), new ResourceLocation("lordcraft", "textures/gui/constellation/dark.png"), new ResourceLocation("lordcraft", "textures/gui/constellation/pure.png")};
    public static ResourceLocation[] constellations_stars = new ResourceLocation[]{new ResourceLocation("lordcraft", "textures/gui/constellation/water_stars.png"), new ResourceLocation("lordcraft", "textures/gui/constellation/earth_stars.png"), new ResourceLocation("lordcraft", "textures/gui/constellation/fire_stars.png"), new ResourceLocation("lordcraft", "textures/gui/constellation/air_stars.png"), new ResourceLocation("lordcraft", "textures/gui/constellation/light_stars.png"), new ResourceLocation("lordcraft", "textures/gui/constellation/dark_stars.png"), new ResourceLocation("lordcraft", "textures/gui/constellation/pure_stars.png")};
    public static float[][] constellation_colors = new float[][]{ColorHelper.rgbTo3f(ColorHelper.ELEMENTALCOLOURS[1]), ColorHelper.rgbTo3f(ColorHelper.ELEMENTALCOLOURS[2]), ColorHelper.rgbTo3f(ColorHelper.ELEMENTALCOLOURS[3]), ColorHelper.rgbTo3f(ColorHelper.ELEMENTALCOLOURS[4]), {0.65f, 0.65f, 0.65f}, {0.5f, 0.0f, 0.5f}, {0.0f, 0.5f, 0.5f}};
    public static float[][] constellation_star_colors = new float[][]{ColorHelper.rgbTo3f(ColorHelper.CONSTELLATION_COLORS[1]), ColorHelper.rgbTo3f(ColorHelper.CONSTELLATION_COLORS[2]), ColorHelper.rgbTo3f(ColorHelper.CONSTELLATION_COLORS[3]), ColorHelper.rgbTo3f(ColorHelper.CONSTELLATION_COLORS[4]), ColorHelper.rgbTo3f(ColorHelper.CONSTELLATION_COLORS[5]), ColorHelper.rgbTo3f(ColorHelper.CONSTELLATION_COLORS[6]), ColorHelper.rgbTo3f(ColorHelper.CONSTELLATION_COLORS[7])};
    public static int[][] positions = new int[][]{{24, 96}, {136, 24}, {56, 168}, {56, 24}, {136, 168}, {168, 96}, {104, 104}};

    public Constellation(BookScreen container, int index) {
        super(container, positions[index][0], positions[index][1]);
        this.index = index;
    }

    @Override
    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        BookScreen screen = (BookScreen)this.container;
        float alpha = 1.0f;
        if (screen.transition) {
            float f = screen.maxTransition - screen.transitionTime;
            screen.getClass();
            alpha = f / 20.0f;
        }
        int shiftX = mouseX - this.container.getScreenX();
        int shiftY = mouseY - this.container.getScreenY();
        float[] color = constellation_colors[this.index];
        float[] star_color = constellation_star_colors[this.index];
        if (!screen.transition && this.hovering(mouseX, mouseY)) {
            RenderCore.color4f((float)star_color[0], (float)star_color[1], (float)star_color[2], (float)alpha);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(constellations[this.index]);
            this.container.drawScaledRect(this.x + shiftX / 56 - 8, this.y + shiftY / 56 - 8, 64.0, 64.0);
        }
        RenderCore.color4f((float)color[0], (float)color[1], (float)color[2], (float)alpha);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(constellations[this.index]);
        this.container.drawScaledRect(this.x + shiftX / 56, this.y + shiftY / 56, 48.0, 48.0);
        RenderCore.color4f((float)star_color[0], (float)star_color[1], (float)star_color[2], (float)alpha);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(constellations_stars[this.index]);
        this.container.drawScaledRect(this.x + shiftX / 56, this.y + shiftY / 56, 48.0, 48.0);
        RenderCore.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return -1;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int mouseButton) {
        BookScreen screen = (BookScreen)this.container;
        if (!screen.transition) {
            screen.setFocusedElement(this.index);
        }
    }

    @Override
    public int getHeight() {
        return 48;
    }

    @Override
    public int getWidth() {
        return 48;
    }

    @Override
    public List<IReorderingProcessor> getTooltip() {
        return new ArrayList<IReorderingProcessor>();
    }

    @Override
    public boolean canDraw() {
        BookScreen screen = (BookScreen)this.container;
        if (this.index == 6) {
            return screen.isThelos() && super.canDraw() && screen.getMode() == EBookMode.RESEARCH && !screen.finishedSelectingElement && screen.selectedConstellation != this.index && screen.res_tab == EResearchTab.ELEMENTAL;
        }
        return super.canDraw() && screen.getMode() == EBookMode.RESEARCH && !screen.finishedSelectingElement && screen.selectedConstellation != this.index && screen.res_tab == EResearchTab.ELEMENTAL;
    }
}

