/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements;

import com.cobbs.lordcraft.Passives.Abilities.Dash.DashData;
import com.cobbs.lordcraft.Passives.EPassive;
import com.cobbs.lordcraft.UI.Elements.Constellation;
import com.cobbs.lordcraft.UI.Elements.GuiElement;
import com.cobbs.lordcraft.UI.IGui;
import com.cobbs.lordcraft.Util.Client.ClientData;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveData;
import com.cobbs.lordcraft.Util.Helpers.RenderCore;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;

public class DashElement
extends GuiElement {
    private Runnable animation;
    public boolean glowing = false;
    private int count = 0;
    private int startTime = 0;
    private static final int animTime = 20;
    private int lastDash = 0;

    public DashElement(IGui container, int x, int y) {
        super(container, x, y);
    }

    @Override
    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        int val = super.draw(stack, currentSheet, mouseX, mouseY);
        PassiveData pData = ClientData.passiveData;
        if (pData.getState(EPassive.DASH) == 2) {
            DashData dd = (DashData)pData.linkedData.get((Object)EPassive.DASH);
            if (this.lastDash > dd.dash) {
                this.commenceGlowAnim();
            }
            this.lastDash = dd.dash;
            AbstractGui gui = this.container.getGui();
            gui.func_238474_b_(stack, this.x, this.y, 240, 222, 16, 16);
            float transparency = 0.0f;
            transparency = dd.dash == 0 ? 1.0f : (float)dd.charge / (float)dd.maxCharge;
            int colorV = ClientData.lordicData.hud_color;
            float[] color = Constellation.constellation_colors[colorV];
            RenderCore.color4f((float)color[0], (float)color[1], (float)color[2], (float)transparency);
            gui.func_238474_b_(stack, this.x + 2, this.y + 2, 240, 238, 12, 12);
            if (this.glowing) {
                RenderCore.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - (float)this.count / 20.0f));
                gui.func_238474_b_(stack, this.x + 3, this.y + 5, 240, 250, 10, 6);
            }
            Minecraft.func_71410_x().field_71466_p.func_238405_a_(stack, "" + (dd.dashCount - dd.dash), (float)(this.x + 12), (float)(this.y + 10), Color.GREEN.getRGB());
        }
        return val;
    }

    public void commenceGlowAnim() {
        this.count = 0;
        this.startTime = this.container.getTime();
        this.glowing = true;
        this.setAnimation(this::procGlow);
    }

    public void procGlow() {
        if (this.startTime + 20 < this.container.getTime()) {
            this.glowing = false;
            this.cancelAnimation();
        } else {
            ++this.count;
        }
    }

    public void setAnimation(Runnable animation) {
        this.cancelAnimation();
        this.animation = animation;
        this.container.addAnimation(this.animation);
    }

    public void cancelAnimation() {
        this.container.cancelAnimation(this.animation);
        this.animation = null;
    }
}

