/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements.ManaBar;

import com.cobbs.lordcraft.UI.Elements.Constellation;
import com.cobbs.lordcraft.UI.Elements.GuiElement;
import com.cobbs.lordcraft.UI.Elements.ManaBar.ManaPip;
import com.cobbs.lordcraft.UI.IGui;
import com.cobbs.lordcraft.Util.Client.ClientData;
import com.cobbs.lordcraft.Util.Helpers.RenderCore;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.Style;

public class ManaBar
extends GuiElement {
    private int maxPips = -1;
    public List<ManaPip> manaPips;
    private int primalCharge = 0;
    private int mana;
    private int maxMana;

    public ManaBar(IGui container, int x, int y) {
        super(container, x, y);
    }

    public void loadValues(int mana, int maxMana, int maxPips, int pips, int chargeMana, int primalCharge) {
        int i;
        if (maxPips != this.maxPips) {
            this.maxPips = maxPips;
            this.manaPips = new ArrayList<ManaPip>(maxPips);
            int mCount = 0;
            for (int i2 = 0; i2 < maxPips; ++i2) {
                this.manaPips.add(new ManaPip(this, mCount, maxPips < 9, 1000));
                ++mCount;
            }
        }
        for (i = 0; i < pips; ++i) {
            this.manaPips.get(i).setChargeValue(1000);
        }
        if (pips < maxPips) {
            this.manaPips.get(pips).setChargeValue(chargeMana);
            for (i = pips + 1; i < maxPips; ++i) {
                this.manaPips.get(i).setChargeValue(0);
            }
        }
        this.primalCharge = primalCharge;
        this.mana = mana;
        this.maxMana = maxMana;
    }

    @Override
    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        super.draw(stack, currentSheet, mouseX, mouseY);
        boolean pipsDraw = ClientData.lordicData.hud_visibility[0];
        boolean manaDraw = ClientData.lordicData.hud_visibility[1];
        boolean primalDraw = ClientData.lordicData.hud_visibility[2];
        int primaryElement = ClientData.lordicData.hud_color;
        int offset = 0;
        if (primalDraw) {
            offset = 23;
            this.container.getGui().func_238474_b_(stack, this.x, this.y, 132, 0, 26, 26);
        }
        if (manaDraw) {
            this.container.getGui().func_238474_b_(stack, this.x + offset, this.y + 13, 133, 74, 123, 10);
            if (ClientData.lordicData.hud_visibility[3]) {
                if (offset > 0) {
                    this.container.getGui().func_238474_b_(stack, this.x + offset - 8, this.y + 23, 216, 113, 8, 11);
                }
                this.container.getGui().func_238474_b_(stack, this.x + offset, this.y + 23, 162, 170, 94, 11);
                this.container.getGui().func_238474_b_(stack, this.x + offset + 94, this.y + 23, 224, 113, 8, 11);
            }
        }
        if (pipsDraw) {
            for (ManaPip pip : this.manaPips) {
                pip.renderBack(stack);
            }
        }
        float temp = (float)Math.abs(Math.sin((float)this.container.getTime() / 60.0f)) * 0.2f + 0.8f;
        float[] color = Constellation.constellation_colors[primaryElement];
        float[] color2 = Constellation.constellation_star_colors[primaryElement];
        RenderCore.color4f((float)color[0], (float)color[1], (float)color[2], (float)temp);
        int value = (int)Math.floor((double)this.primalCharge / 1000.0 * 20.0);
        if (primalDraw) {
            this.container.getGui().func_238474_b_(stack, this.x + 3, this.y + 3 + 20 - value, 184, 20 - value, 20, value);
        }
        value = this.maxMana > 0 ? (int)Math.floor((double)this.mana / (double)this.maxMana * 115.0) : 0;
        if (manaDraw) {
            this.container.getGui().func_238474_b_(stack, this.x + offset + 4, this.y + 16, 141, 70, value, 4);
        }
        if (pipsDraw) {
            for (ManaPip pip : this.manaPips) {
                pip.renderFront(stack);
            }
            for (ManaPip pip : this.manaPips) {
                pip.renderOverdraft(stack);
            }
        }
        GlStateManager.func_227740_m_();
        GlStateManager.func_227702_d_((float)color2[0], (float)color2[1], (float)color2[2], (float)1.0f);
        if (primalDraw && ClientData.lordicData.primaryElement != -1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(Constellation.constellations[ClientData.lordicData.primaryElement]);
            this.container.drawScaledRect(this.x + 3, this.y + 3, 20.0, 20.0);
            this.container.drawScaledRect(this.x + 3, this.y + 3, 20.0, 20.0);
        }
        this.setupSpriteSheet();
        return this.setupSpriteSheet();
    }

    public void draw2(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        boolean manaDraw = ClientData.lordicData.hud_visibility[1];
        int offset = 0;
        if (ClientData.lordicData.hud_visibility[2]) {
            offset = 23;
        }
        if (manaDraw && ClientData.lordicData.hud_visibility[3]) {
            int primaryElement = ClientData.lordicData.hud_color;
            float[] colors = Constellation.constellation_colors[primaryElement];
            int color = new Color(colors[0], colors[1], colors[2]).getRGB();
            Minecraft.func_71410_x().field_71466_p.func_238422_b_(stack, IReorderingProcessor.func_242239_a((String)("" + ClientData.manaData.mana), (Style)Style.field_240709_b_), (float)(this.x + offset + 2), (float)(this.y + 25), color);
        }
    }
}

