/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements;

import com.cobbs.lordcraft.UI.Elements.GuiElement;
import com.cobbs.lordcraft.UI.Elements.IMouseHandler;
import com.cobbs.lordcraft.UI.IGui;
import com.cobbs.lordcraft.Util.Helpers.InputHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class Slider
extends GuiElement
implements IMouseHandler {
    private boolean holding;
    protected double min;
    protected double max;
    private int sliderX;
    private int initSliderX;
    private String title;

    public Slider(IGui container, int x, int y, String title, double min, double max, double init) {
        super(container, x, y);
        this.title = title;
        this.min = min;
        this.max = max;
        double val = (init - min) * 102.0 / (max - min);
        this.sliderX = this.initSliderX = (int)val;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton != 0) {
            this.reset();
        } else if (this.hoveringSlider(mouseX, mouseY)) {
            this.holding = true;
        } else {
            this.setSliderX(mouseX - 5.0);
            this.holding = true;
        }
    }

    public void reset() {
        this.sliderX = this.initSliderX;
    }

    @Override
    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        int val = super.draw(stack, currentSheet, mouseX, mouseY);
        GlStateManager.func_227740_m_();
        this.drawBack(stack, currentSheet, mouseX, mouseY);
        this.drawFill(stack, currentSheet, mouseX, mouseY);
        this.drawSlider(stack, currentSheet, mouseX, mouseY);
        return val;
    }

    public void drawBack(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        this.container.getGui().func_238474_b_(stack, this.x, this.y + 2, 144, 62, 112, 8);
    }

    public void drawFill(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        this.container.getGui().func_238474_b_(stack, this.x, this.y, 144, 50, this.sliderX + 5, 12);
    }

    public void drawSlider(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        this.container.getGui().func_238474_b_(stack, this.x + this.sliderX, this.y + 1, 145 + (this.holding || this.hoveringSlider(mouseX, mouseY) ? 12 : 0), 39, 10, 10);
    }

    @Override
    public int getHeight() {
        return 12;
    }

    @Override
    public int getWidth() {
        return 112;
    }

    public double getValue() {
        return this.min + (double)this.sliderX / 102.0 * (this.max - this.min);
    }

    public void setValue(double value) {
        double val = (value - this.min) * 102.0 / (this.max - this.min);
        this.sliderX = (int)val;
    }

    public boolean hoveringSlider(double mouseX, double mouseY) {
        return InputHelper.mouseInArea(mouseX, mouseY, this.x + this.sliderX, this.getY() + 1, this.x + this.sliderX + 10, this.getY() + 11);
    }

    @Override
    public List<IReorderingProcessor> getTooltip() {
        String formattedDecimal = String.format("%.2f", ModHelper.round(this.getValue(), 2));
        return ModHelper.wrap(IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)this.title, (Object[])new Object[0]), (Style)Style.field_240709_b_.func_240712_a_(TextFormatting.AQUA)), IReorderingProcessor.func_242239_a((String)ModHelper.concat(this.min, " : ", formattedDecimal, " : ", this.max), (Style)Style.field_240709_b_.func_240712_a_(TextFormatting.WHITE)));
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.holding) {
            this.setSliderX(mouseX - 5.0);
        }
        return false;
    }

    public void setSliderX(double mouseX) {
        this.sliderX = (int)mouseX - this.x;
        if (this.sliderX > 102) {
            this.sliderX = 102;
        } else if (this.sliderX < 0) {
            this.sliderX = 0;
        }
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.holding = false;
        return false;
    }
}

