/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements;

import com.cobbs.lordcraft.UI.Elements.Tab;
import com.cobbs.lordcraft.UI.IGui;
import com.mojang.blaze3d.matrix.MatrixStack;

public abstract class StandardElement {
    protected int x;
    protected int y;
    protected int xFix;
    protected int yFix;
    public IGui container;
    protected boolean visible;
    private Tab tab = null;

    public StandardElement(IGui container, int x, int y) {
        this(container, x, y, null);
    }

    public StandardElement(IGui container, int x, int y, Tab tab) {
        this.container = container;
        this.xFix = x;
        this.yFix = y;
        this.setTab(tab);
        this.visible = true;
        container.addElement(this);
    }

    public void setTab(Tab tab) {
        this.tab = tab;
        this.x = this.xFix + this.relX();
        this.y = this.yFix + this.relY();
    }

    public boolean canDraw() {
        return this.visible && (this.tab == null || this.tab.isOpen());
    }

    public int draw(MatrixStack stack, int currentSheet, int mouseX, int mouseY) {
        return -1;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int relX() {
        if (this.tab != null) {
            return this.tab.x - this.tab.getMaxWidth();
        }
        return this.container.getScreenX();
    }

    public int relY() {
        if (this.tab != null) {
            return this.tab.y;
        }
        return this.container.getScreenY();
    }
}

