/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Elements;

import com.cobbs.lordcraft.UI.Elements.GuiElement;
import com.cobbs.lordcraft.UI.Elements.IClickable;
import com.cobbs.lordcraft.UI.IGui;
import com.cobbs.lordcraft.Util.Helpers.InputHelper;
import com.cobbs.lordcraft.Util.Helpers.RenderHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;

public class Tab
extends GuiElement
implements IClickable {
    private ResourceLocation id;
    private int width;
    private int height;
    private int renderWidth;
    private int renderHeight;
    private int maxWidth;
    private int maxHeight;
    private boolean open;
    private int startTime = 0;
    private ArrayList<IReorderingProcessor> text;
    private int index = 0;
    private final int widthAdj;
    private final int heightAdj;
    private static int animTime = 6;
    private Runnable animation = null;

    public Tab(IGui container, int maxWidth, int maxHeight, String text, ResourceLocation id) {
        super(container, 0, 0);
        this.id = id;
        this.index = container.getTabs().size();
        this.y += this.index * 18;
        this.width = 18;
        this.height = 18;
        this.renderWidth = this.width;
        this.renderHeight = this.height;
        this.maxHeight = maxHeight;
        this.maxWidth = maxWidth;
        this.text = new ArrayList();
        this.text.add(IReorderingProcessor.func_242239_a((String)text, (Style)Style.field_240709_b_));
        this.open = false;
        this.widthAdj = (this.maxWidth - this.width) / animTime;
        this.heightAdj = (this.maxHeight - this.height) / animTime;
        container.getTabs().add(this);
    }

    @Override
    public int getX() {
        return super.getX() - this.width;
    }

    @Override
    public void onClick(double mouseX, double mouseY, int mouseButton) {
        if (this.hovering(mouseX, mouseY)) {
            this.cancelAnimation();
            if (this.open) {
                this.setupClose();
            } else {
                List<Tab> tabs = this.container.getTabs();
                for (Tab t : tabs) {
                    t.setupClose();
                }
                this.setupOpen();
            }
        }
    }

    @Override
    public int draw(MatrixStack matrixStack, int currentSheet, int mouseX, int mouseY) {
        int val = super.draw(matrixStack, currentSheet, mouseX, mouseY);
        int left = this.x - (this.renderWidth - 1);
        int bottom = this.y + (this.renderHeight - 1);
        int texY = 0;
        AbstractGui cont = this.container.getGui();
        cont.func_238474_b_(matrixStack, this.x, this.y, 51, texY, 1, 1);
        cont.func_238474_b_(matrixStack, left, this.y, 34, texY, 1, 1);
        cont.func_238474_b_(matrixStack, left, bottom, 34, texY + 17, 1, 1);
        cont.func_238474_b_(matrixStack, this.x, bottom, 51, texY + 17, 1, 1);
        RenderHelper.drawScaledRect(left + 1, this.y, this.renderWidth - 2, 1, this.container.getZLevel(), 35, texY, 16, 1);
        RenderHelper.drawScaledRect(left + 1, bottom, this.renderWidth - 2, 1, this.container.getZLevel(), 35, texY + 17, 16, 1);
        RenderHelper.drawScaledRect(this.x, this.y + 1, 1, this.renderHeight - 2, this.container.getZLevel(), 51, texY + 1, 1, 16);
        RenderHelper.drawScaledRect(left, this.y + 1, 1, this.renderHeight - 2, this.container.getZLevel(), 34, texY + 1, 1, 16);
        int xi = 0;
        while (true) {
            int yi = 0;
            while (true) {
                int widX = Math.min(16, this.renderWidth - 2 - xi);
                int widY = Math.min(16, this.renderHeight - 2 - yi);
                cont.func_238474_b_(matrixStack, left + xi + 1, this.y + 1 + yi, 35, texY + 1, widX, widY);
                if (yi > this.renderHeight - 18) break;
                yi += 16;
            }
            if (xi > this.renderWidth - 18) break;
            xi += 16;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.id);
        this.container.drawScaledRect(this.x - 16, this.y + 1, 16.0, 16.0);
        this.setupSpriteSheet();
        return val;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public List<IReorderingProcessor> getTooltip() {
        return this.text;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setupOpen() {
        this.startTime = this.container.getTime();
        this.setAnimation(this::open);
    }

    public void setupClose() {
        this.startTime = this.container.getTime();
        this.open = false;
        this.setAnimation(this::close);
    }

    public void open() {
        if (this.container.getTime() >= this.startTime + animTime || this.renderWidth >= this.maxWidth && this.renderHeight >= this.maxHeight) {
            this.setSize(this.maxWidth, this.maxHeight);
            this.open = true;
            this.cancelAnimation();
        } else {
            this.setSize(this.renderWidth + this.widthAdj, this.renderHeight + this.heightAdj);
        }
    }

    public void close() {
        if (this.container.getTime() >= this.startTime + animTime || this.renderWidth <= this.width && this.renderHeight <= this.height) {
            this.setSize(this.width, this.height);
            this.cancelAnimation();
        } else {
            this.setSize(this.renderWidth - this.widthAdj, this.renderHeight - this.heightAdj);
        }
    }

    public void setSize(int width, int height) {
        this.renderWidth = width;
        this.renderHeight = height;
        this.adjustTabPositions();
    }

    public void adjustTabPositions() {
        List<Tab> tabList = this.container.getTabs();
        if (this.index + 1 < tabList.size()) {
            Tab t = tabList.get(this.index + 1);
            t.setY(this.y + this.renderHeight);
            t.adjustTabPositions();
        }
    }

    public void setAnimation(Runnable animation) {
        this.cancelAnimation();
        this.animation = animation;
        this.container.addAnimation(this.animation);
    }

    public void cancelAnimation() {
        this.container.cancelAnimation(this.animation);
        this.animation = null;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public boolean openHover(double mouseX, double mouseY) {
        return this.open && InputHelper.mouseInArea(mouseX, mouseY, this.x - (this.renderWidth - 1), this.y, this.x, this.y + (this.renderHeight - 1));
    }
}

