/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.HUD;

import com.cobbs.lordcraft.Blocks.Basin.BasinTE;
import com.cobbs.lordcraft.Blocks.PlayerInterface.PlayerInterfaceTE;
import com.cobbs.lordcraft.Blocks.TranslocationMatrix.TranslocationTE;
import com.cobbs.lordcraft.Entries.ModBlocks;
import com.cobbs.lordcraft.Entries.ModItems;
import com.cobbs.lordcraft.Items.Book.BookScreen;
import com.cobbs.lordcraft.UI.Elements.ChargeBar;
import com.cobbs.lordcraft.UI.Elements.DashElement;
import com.cobbs.lordcraft.UI.Elements.IForegroundRenderer;
import com.cobbs.lordcraft.UI.Elements.IMouseHandler;
import com.cobbs.lordcraft.UI.Elements.ManaBar.ManaBar;
import com.cobbs.lordcraft.UI.Elements.StandardElement;
import com.cobbs.lordcraft.UI.Elements.Tab;
import com.cobbs.lordcraft.UI.IGui;
import com.cobbs.lordcraft.Util.Client.ClientData;
import com.cobbs.lordcraft.Util.ClientInit;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaData;
import com.cobbs.lordcraft.Util.Helpers.ColorHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.cobbs.lordcraft.Util.Helpers.RenderCore;
import com.cobbs.lordcraft.Util.Helpers.RenderHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.Style;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class ModHud
extends AbstractGui
implements IGui {
    public List<StandardElement> elements;
    public List<Tab> tabs;
    public int currentSheet;
    public int x;
    public int y;
    public int time = 0;
    public List<Runnable> animations = new ArrayList<Runnable>();
    private Minecraft minecraft;
    private ManaBar manaBar;
    private DashElement dashElement;
    private ChargeBar chargeBar;
    private int overdraftPips = 0;
    public boolean pipsChanged = false;

    public ModHud(Minecraft minecraft, int x, int y) {
        this.minecraft = minecraft;
        this.x = x;
        this.y = y;
        this.constructIGui();
        this.manaBar = new ManaBar(this, 1, 1);
        this.dashElement = new DashElement(this, 1, 29);
        this.chargeBar = new ChargeBar(this, -56, -80);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(RenderGameOverlayEvent.Post event) {
        RayTraceResult result;
        if (!this.shouldRender(event)) {
            return;
        }
        this.incrementTime();
        List<Runnable> list = this.animations;
        synchronized (list) {
            for (int i = 0; i < this.animations.size(); ++i) {
                this.animations.get(i).run();
            }
        }
        MatrixStack stack = event.getMatrixStack();
        ManaData data = ClientData.manaData;
        this.manaBar.loadValues(data.mana, data.maxMana, data.maxPips, data.pips, data.pipCharge, data.primalCharge);
        if (ClientData.lordicData.hud_visibility[4] && ClientInit.charge > 0) {
            this.chargeBar.draw(stack, this.currentSheet, 0, 0, event);
        }
        if (this.pipsChanged) {
            try {
                this.manaBar.manaPips.get(data.pips - 1).commenceGlowAnim();
                this.pipsChanged = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.overdraftPips > 0) {
            int max = Math.min(this.overdraftPips, data.maxPips);
            for (int i = 0; i < max; ++i) {
                this.manaBar.manaPips.get(i).commenceGlowAnim2();
            }
            this.overdraftPips = 0;
        }
        RenderCore.enableBlend();
        int dashElementHeight = 28;
        if (this.manaBar.canDraw()) {
            this.manaBar.draw(stack, this.getSpriteSheet(), 0, 0);
        }
        if (!(ClientData.lordicData.hud_visibility[0] || ClientData.lordicData.hud_visibility[1] || ClientData.lordicData.hud_visibility[2])) {
            dashElementHeight = 1;
        } else if (ClientData.lordicData.hud_visibility[3] && !ClientData.lordicData.hud_visibility[2]) {
            dashElementHeight += 11;
        }
        this.dashElement.setY(dashElementHeight);
        if (ClientData.lordicData.hud_visibility[4] && ClientInit.charge > 0) {
            this.chargeBar.drawFrontBit(stack, this.currentSheet, 0, 0, event);
        }
        RenderCore.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.dashElement.draw(stack, this.getSpriteSheet(), 0, 0);
        if (this.manaBar.canDraw()) {
            this.manaBar.draw2(stack, this.getSpriteSheet(), 0, 0);
        }
        if ((result = Minecraft.func_71410_x().field_71476_x) != null && result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = (BlockRayTraceResult)result;
            BlockPos pos = blockTrace.func_216350_a();
            TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(pos);
            if (tile instanceof BasinTE) {
                BasinTE te = (BasinTE)tile;
                int posX = event.getWindow().func_198107_o() / 2 + 4;
                int posY = event.getWindow().func_198087_p() / 2 - 16;
                if (te.fluidHeight > 0) {
                    this.minecraft.field_71466_p.func_238422_b_(stack, IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.basin_empty", (Object[])new Object[0]), (Style)Style.field_240709_b_), (float)posX, (float)(posY + 18), ColorHelper.ELEMENTALCOLOURS[7]);
                    FontRenderer fontRenderer = this.minecraft.field_71466_p;
                    IReorderingProcessor iReorderingProcessor = IReorderingProcessor.func_242239_a((String)ModHelper.concat(te.fluidHeight, " / ", 64), (Style)Style.field_240709_b_);
                    float f = posX;
                    this.minecraft.field_71466_p.getClass();
                    fontRenderer.func_238422_b_(stack, iReorderingProcessor, f, (float)(posY + 18 + 9 + 1), ColorHelper.ELEMENTALCOLOURS[7]);
                }
                if (!te.stacks.isEmpty()) {
                    int i = 0;
                    for (ItemStack stack1 : te.stacks) {
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(BookScreen.common0);
                        RenderCore.enableBlend();
                        RenderCore.color4f((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.func_238474_b_(stack, posX + i * 18, posY, 240, 206, 16, 16);
                        RenderHelper.renderItemIntoGui(stack1, posX + i * 18, posY);
                        ++i;
                    }
                }
            } else if (Minecraft.func_71410_x().field_71441_e.func_180495_p(pos).func_177230_c().equals(ModBlocks.VOID_INTERFACE)) {
                ClientPlayerEntity p = Minecraft.func_71410_x().field_71439_g;
                int posX = event.getWindow().func_198107_o() / 2 + 4;
                int posY = event.getWindow().func_198087_p() / 2 - 16;
                int increaseManaAmount = 0;
                int increaseMaxAmount = 0;
                for (Hand h : Hand.values()) {
                    ItemStack heldItem = p.func_184586_b(h);
                    if (heldItem.func_190926_b()) continue;
                    if (heldItem.func_77973_b().equals(ModItems.MANA_SIPHON)) {
                        increaseMaxAmount += 1000;
                        continue;
                    }
                    if (heldItem.func_77973_b().equals(ModItems.CRYSTAL_WATER)) {
                        increaseManaAmount = Math.min(1000, ClientData.manaData.maxMana - ClientData.manaData.mana);
                        continue;
                    }
                    if (heldItem.func_77973_b().equals(ModItems.CRYSTAL_EARTH)) {
                        increaseManaAmount = Math.min(1000, ClientData.manaData.maxMana - ClientData.manaData.mana);
                        continue;
                    }
                    if (heldItem.func_77973_b().equals(ModItems.CRYSTAL_FIRE)) {
                        increaseManaAmount = Math.min(1000, ClientData.manaData.maxMana - ClientData.manaData.mana);
                        continue;
                    }
                    if (heldItem.func_77973_b().equals(ModItems.CRYSTAL_AIR)) {
                        increaseManaAmount = Math.min(1000, ClientData.manaData.maxMana - ClientData.manaData.mana);
                        continue;
                    }
                    if (heldItem.func_77973_b().equals(ModItems.CRYSTAL_LIGHT)) {
                        increaseManaAmount = Math.min(1000, ClientData.manaData.maxMana - ClientData.manaData.mana);
                        continue;
                    }
                    if (heldItem.func_77973_b().equals(ModItems.CRYSTAL_DARK)) {
                        increaseManaAmount = Math.min(1000, ClientData.manaData.maxMana - ClientData.manaData.mana);
                        continue;
                    }
                    if (!heldItem.func_77973_b().equals(ModItems.CRYSTAL_PURE)) continue;
                    increaseManaAmount = Math.min(9000, ClientData.manaData.maxMana - ClientData.manaData.mana);
                }
                this.minecraft.field_71466_p.func_238422_b_(stack, IReorderingProcessor.func_242239_a((String)I18n.func_135052_a((String)"lordcraft.global_mana", (Object[])new Object[0]), (Style)Style.field_240709_b_), (float)posX, (float)(posY + 18), ColorHelper.ELEMENTALCOLOURS[7]);
                FontRenderer fontRenderer = this.minecraft.field_71466_p;
                IReorderingProcessor iReorderingProcessor = IReorderingProcessor.func_242239_a((String)ModHelper.concat(ClientData.manaData.mana, increaseManaAmount > 0 ? " + " + increaseManaAmount : "", " / ", ClientData.manaData.maxMana, increaseMaxAmount > 0 ? " + " + increaseMaxAmount : ""), (Style)Style.field_240709_b_);
                float f = posX;
                this.minecraft.field_71466_p.getClass();
                fontRenderer.func_238422_b_(stack, iReorderingProcessor, f, (float)(posY + 18 + 9 + 1), ColorHelper.ELEMENTALCOLOURS[7]);
            } else if (tile instanceof TranslocationTE) {
                TranslocationTE te = (TranslocationTE)tile;
                if (te.link != null) {
                    int posX = event.getWindow().func_198107_o() / 2 + 4;
                    int posY = event.getWindow().func_198087_p() / 2 - 16;
                    this.minecraft.field_71466_p.func_238422_b_(stack, IReorderingProcessor.func_242239_a((String)ModHelper.concat("X: ", te.link.func_177958_n()), (Style)Style.field_240709_b_), (float)posX, (float)(posY + 18), ColorHelper.ELEMENTALCOLOURS[7]);
                    FontRenderer fontRenderer = this.minecraft.field_71466_p;
                    IReorderingProcessor iReorderingProcessor = IReorderingProcessor.func_242239_a((String)ModHelper.concat("Y: ", te.link.func_177956_o()), (Style)Style.field_240709_b_);
                    float f = posX;
                    this.minecraft.field_71466_p.getClass();
                    fontRenderer.func_238422_b_(stack, iReorderingProcessor, f, (float)(posY + 18 + 9 + 1), ColorHelper.ELEMENTALCOLOURS[7]);
                    FontRenderer fontRenderer2 = this.minecraft.field_71466_p;
                    IReorderingProcessor iReorderingProcessor2 = IReorderingProcessor.func_242239_a((String)ModHelper.concat("Z: ", te.link.func_177952_p()), (Style)Style.field_240709_b_);
                    float f2 = posX;
                    this.minecraft.field_71466_p.getClass();
                    fontRenderer2.func_238422_b_(stack, iReorderingProcessor2, f2, (float)(posY + 18 + (9 + 1) * 2), ColorHelper.ELEMENTALCOLOURS[7]);
                    FontRenderer fontRenderer3 = this.minecraft.field_71466_p;
                    IReorderingProcessor iReorderingProcessor3 = IReorderingProcessor.func_242239_a((String)ModHelper.concat("DIM: ", te.linkWorld), (Style)Style.field_240709_b_);
                    float f3 = posX;
                    this.minecraft.field_71466_p.getClass();
                    fontRenderer3.func_238422_b_(stack, iReorderingProcessor3, f3, (float)(posY + 18 + (9 + 1) * 3), ColorHelper.ELEMENTALCOLOURS[7]);
                }
            } else if (tile instanceof PlayerInterfaceTE) {
                PlayerInterfaceTE te = (PlayerInterfaceTE)tile;
                if (te.placer_name != null) {
                    int posX = event.getWindow().func_198107_o() / 2 + 4;
                    int posY = event.getWindow().func_198087_p() / 2 - 16;
                    this.minecraft.field_71466_p.func_238422_b_(stack, IReorderingProcessor.func_242239_a((String)ModHelper.concat(I18n.func_135052_a((String)"lordcraft.interface.owner", (Object[])new Object[0]), ": ", te.placer_name), (Style)Style.field_240709_b_), (float)posX, (float)(posY + 18), ColorHelper.ELEMENTALCOLOURS[7]);
                }
            }
        }
        RenderCore.disableBlend();
        RenderCore.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void overDraft(int mana) {
        this.overdraftPips = mana;
    }

    public boolean shouldRender(RenderGameOverlayEvent.Post event) {
        return event.getType() == this.getType();
    }

    public RenderGameOverlayEvent.ElementType getType() {
        return RenderGameOverlayEvent.ElementType.HOTBAR;
    }

    @Override
    public int getSpriteSheet() {
        return this.currentSheet;
    }

    @Override
    public void setSpriteSheet(int value) {
        this.currentSheet = value;
    }

    @Override
    public List<StandardElement> getElements() {
        return this.elements;
    }

    @Override
    public List<IForegroundRenderer> getForegroundRenderers() {
        return null;
    }

    @Override
    public List<IMouseHandler> getMouseHandlers() {
        return null;
    }

    @Override
    public void setElements(List<StandardElement> elements) {
        this.elements = elements;
    }

    @Override
    public List<Tab> getTabs() {
        return this.tabs;
    }

    @Override
    public void setTabs(List<Tab> tabs) {
        this.tabs = tabs;
    }

    @Override
    public List<Runnable> getAnims() {
        return this.animations;
    }

    @Override
    public void setAnims(List<Runnable> anims) {
        this.animations = anims;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int val) {
        this.time = val;
    }

    @Override
    public Minecraft getMinecraftInstance() {
        return this.minecraft;
    }

    @Override
    public int getScreenX() {
        return this.x;
    }

    @Override
    public int getScreenY() {
        return this.y;
    }
}

