/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI;

import com.cobbs.lordcraft.Blocks.TEModules.ITickingModule;
import com.cobbs.lordcraft.UI.Elements.IForegroundRenderer;
import com.cobbs.lordcraft.UI.Elements.IMouseHandler;
import com.cobbs.lordcraft.UI.Elements.StandardElement;
import com.cobbs.lordcraft.UI.Elements.Tab;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public interface IGui {
    public int getSpriteSheet();

    public void setSpriteSheet(int var1);

    default public AbstractGui getGui() {
        return (AbstractGui)this;
    }

    public List<StandardElement> getElements();

    public List<IForegroundRenderer> getForegroundRenderers();

    public List<IMouseHandler> getMouseHandlers();

    public void setElements(List<StandardElement> var1);

    public List<Tab> getTabs();

    public void setTabs(List<Tab> var1);

    public List<Runnable> getAnims();

    public void setAnims(List<Runnable> var1);

    default public void addAnimation(Runnable r) {
        this.getAnims().add(r);
    }

    default public void cancelAnimation(Runnable r) {
        if (r == null) {
            return;
        }
        this.getAnims().remove(r);
    }

    default public void constructIGui() {
        this.setElements(new ArrayList<StandardElement>());
        this.setTabs(new ArrayList<Tab>());
        this.setSpriteSheet(-1);
    }

    default public void addElement(StandardElement e) {
        this.getElements().add(e);
        if (e instanceof IForegroundRenderer) {
            this.getForegroundRenderers().add((IForegroundRenderer)((Object)e));
        }
        if (e instanceof IMouseHandler) {
            this.getMouseHandlers().add((IMouseHandler)((Object)e));
        }
    }

    default public void drawElements(MatrixStack stack, int mouseX, int mouseY) {
        for (StandardElement g : this.getElements()) {
            if (g instanceof ITickingModule) {
                ((ITickingModule)((Object)g)).onTick();
            }
            if (!g.canDraw()) continue;
            this.setSpriteSheet(g.draw(stack, this.getSpriteSheet(), mouseX, mouseY));
        }
    }

    public int getTime();

    public void setTime(int var1);

    default public void incrementTime() {
        this.setTime(this.getTime() + 1);
    }

    public Minecraft getMinecraftInstance();

    public int getScreenX();

    public int getScreenY();

    default public double getZLevel() {
        return 0.0;
    }

    default public void drawScaledRect(double x, double y, double width, double height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(x, y + height, this.getZLevel()).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(x + width, y + height, this.getZLevel()).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(x + width, y, this.getZLevel()).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(x, y, this.getZLevel()).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    default public void drawRotatedScaledRect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(x1, y1, this.getZLevel()).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(x2, y2, this.getZLevel()).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(x3, y3, this.getZLevel()).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(x4, y4, this.getZLevel()).func_225583_a_(0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    default public void drawPartialRect(int x, int y, int textureX, int textureY, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)(x + 0), (double)(y + height), this.getZLevel()).func_225583_a_((float)textureX * 0.00390625f + 0.25f, (float)(textureY + height) * 0.00390625f - 0.25f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), this.getZLevel()).func_225583_a_((float)(textureX + width) * 0.00390625f - 0.25f, (float)(textureY + height) * 0.00390625f - 0.25f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + 0), this.getZLevel()).func_225583_a_((float)(textureX + width) * 0.00390625f - 0.25f, (float)textureY * 0.00390625f + 0.25f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + 0), (double)(y + 0), this.getZLevel()).func_225583_a_((float)textureX * 0.00390625f + 0.25f, (float)textureY * 0.00390625f + 0.25f).func_181675_d();
        tessellator.func_78381_a();
    }

    default public void drawPartialRectScaled(int x, int y, float textureX, float textureY, float maxX, float maxY, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)x, (double)(y + height), this.getZLevel()).func_225583_a_(textureX / 256.0f, (textureY + maxY) / 256.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), this.getZLevel()).func_225583_a_((textureX + maxX) / 256.0f, (textureY + maxY) / 256.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)y, this.getZLevel()).func_225583_a_((textureX + maxX) / 256.0f, textureY / 256.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, this.getZLevel()).func_225583_a_(textureX / 256.0f, textureY / 256.0f).func_181675_d();
        tessellator.func_78381_a();
    }
}

