/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.UI.Screens;

import com.cobbs.lordcraft.UI.Containers.StandardContainer;
import com.cobbs.lordcraft.UI.Elements.IClickable;
import com.cobbs.lordcraft.UI.Elements.IForegroundRenderer;
import com.cobbs.lordcraft.UI.Elements.IHoverable;
import com.cobbs.lordcraft.UI.Elements.IMouseHandler;
import com.cobbs.lordcraft.UI.Elements.IScrollHandler;
import com.cobbs.lordcraft.UI.Elements.StandardElement;
import com.cobbs.lordcraft.UI.Elements.Tab;
import com.cobbs.lordcraft.UI.IGui;
import com.cobbs.lordcraft.Util.Helpers.RenderCore;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class StandardScreen<T extends StandardContainer>
extends ContainerScreen<T>
implements IGui {
    public T field_147002_h;
    public List<StandardElement> elements;
    public List<Tab> tabs;
    public int currentSheet;
    public int x;
    public int y;
    public int time = 0;
    public List<Runnable> animations = new LinkedList<Runnable>();
    private List<IForegroundRenderer> foregroundDrawing = new LinkedList<IForegroundRenderer>();
    private List<IMouseHandler> mouseHandlers = new LinkedList<IMouseHandler>();

    public StandardScreen(T container, int width, int height) {
        super(container, ((StandardContainer)((Object)container)).playerInventory, (ITextComponent)new StringTextComponent(""));
        this.field_146999_f = width;
        this.field_147000_g = height;
        this.field_147002_h = container;
        this.constructIGui();
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.x = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.elements.clear();
        this.tabs.clear();
        this.animations.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.incrementTime();
        List<Runnable> list = this.animations;
        synchronized (list) {
            for (Runnable animation : this.animations) {
                animation.run();
            }
        }
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
        this.currentSheet = -1;
    }

    public void drawTooltips(MatrixStack matrixStack, int mouseX, int mouseY) {
        for (IForegroundRenderer f : this.foregroundDrawing) {
            if (!((StandardElement)((Object)f)).canDraw()) continue;
            f.drawForeground(matrixStack, mouseX, mouseY);
        }
        ArrayList<IReorderingProcessor> lines = new ArrayList<IReorderingProcessor>();
        for (StandardElement g : this.elements) {
            List<IReorderingProcessor> list;
            if (!(g instanceof IHoverable) || !((IHoverable)((Object)g)).hovering(mouseX, mouseY) || (list = ((IHoverable)((Object)g)).getTooltip()) == null || list.isEmpty()) continue;
            lines.addAll(list);
        }
        if (!lines.isEmpty()) {
            this.func_238654_b_(matrixStack, lines, mouseX - this.x - 4, mouseY - this.y);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        for (StandardElement g : this.elements) {
            if (!(g instanceof IClickable) || !((IClickable)((Object)g)).hovering(mouseX, mouseY)) continue;
            ((IClickable)((Object)g)).onClick(mouseX, mouseY, mouseButton);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (IMouseHandler h : this.mouseHandlers) {
            h.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        for (IMouseHandler h : this.mouseHandlers) {
            h.mouseReleased(mouseX, mouseY, button);
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double direction) {
        for (StandardElement g : this.elements) {
            if (!(g instanceof IScrollHandler) || !((IScrollHandler)((Object)g)).hovering(mouseX, mouseY)) continue;
            ((IScrollHandler)((Object)g)).mouseScrolled(mouseX, mouseY, direction);
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, direction);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawFront(matrixStack, mouseX, mouseY);
        this.drawTooltips(matrixStack, mouseX, mouseY);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderCore.enableBlend();
        this.drawBack(matrixStack, partialTicks, mouseX, mouseY);
        this.drawElements(matrixStack, mouseX, mouseY);
    }

    @Override
    public int getSpriteSheet() {
        return this.currentSheet;
    }

    @Override
    public void setSpriteSheet(int value) {
        this.currentSheet = value;
    }

    @Override
    public List<StandardElement> getElements() {
        return this.elements;
    }

    @Override
    public List<IForegroundRenderer> getForegroundRenderers() {
        return this.foregroundDrawing;
    }

    @Override
    public List<IMouseHandler> getMouseHandlers() {
        return this.mouseHandlers;
    }

    @Override
    public void setElements(List<StandardElement> elements) {
        this.elements = elements;
    }

    @Override
    public List<Tab> getTabs() {
        return this.tabs;
    }

    @Override
    public void setTabs(List<Tab> tabs) {
        this.tabs = tabs;
    }

    @Override
    public List<Runnable> getAnims() {
        return this.animations;
    }

    @Override
    public void setAnims(List<Runnable> anims) {
        this.animations = anims;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int time) {
        this.time = time;
    }

    @Override
    public Minecraft getMinecraftInstance() {
        return this.getMinecraft();
    }

    @Override
    public int getScreenX() {
        return this.x;
    }

    @Override
    public int getScreenY() {
        return this.y;
    }

    public void drawBack(MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
    }

    public void drawFront(MatrixStack stack, int mouseX, int mouseY) {
    }
}

