/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Commands;

import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaCollection;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaData;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaSavedData;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public class PipCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"lordcraft:pips").requires(p_198485_0_ -> p_198485_0_.func_197034_c(2))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(p_198445_0_ -> PipCommand.addPips((CommandSource)p_198445_0_.getSource(), EntityArgument.func_197090_e((CommandContext)p_198445_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198445_0_, (String)"amount"))))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(p_198445_0_ -> PipCommand.setPips((CommandSource)p_198445_0_.getSource(), EntityArgument.func_197090_e((CommandContext)p_198445_0_, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)p_198445_0_, (String)"amount")))))));
    }

    public static int addPips(CommandSource source, Collection<? extends ServerPlayerEntity> targets, int amount) {
        int i = 0;
        for (ServerPlayerEntity serverPlayerEntity : targets) {
            if (!ModHelper.isPlayerReal((PlayerEntity)serverPlayerEntity)) continue;
            ++i;
            ManaSavedData savedData = ManaSavedData.get((PlayerEntity)serverPlayerEntity);
            ManaData data = (ManaData)((ManaCollection)savedData.data).get((PlayerEntity)serverPlayerEntity);
            data.maxPips = Math.max(0, data.maxPips + amount);
            data.pips = Math.min(data.maxPips, data.pips);
            savedData.func_76185_a();
            ((ManaCollection)savedData.data).syncToClient(serverPlayerEntity);
        }
        return i;
    }

    public static int setPips(CommandSource source, Collection<? extends ServerPlayerEntity> targets, int amount) {
        if (amount < 0) {
            return 0;
        }
        int i = 0;
        for (ServerPlayerEntity serverPlayerEntity : targets) {
            if (!ModHelper.isPlayerReal((PlayerEntity)serverPlayerEntity)) continue;
            ++i;
            ManaSavedData savedData = ManaSavedData.get((PlayerEntity)serverPlayerEntity);
            ManaData data = (ManaData)((ManaCollection)savedData.data).get((PlayerEntity)serverPlayerEntity);
            data.maxPips = amount;
            data.pips = Math.min(data.maxPips, data.pips);
            savedData.func_76185_a();
            ((ManaCollection)savedData.data).syncToClient(serverPlayerEntity);
        }
        return i;
    }
}

