/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Commands;

import com.cobbs.lordcraft.Research.EResearch;
import com.cobbs.lordcraft.Research.EResearchState;
import com.cobbs.lordcraft.Research.ResearchInstance;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.EObjective;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.ObjectivesCollection;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.ObjectivesData;
import com.cobbs.lordcraft.Util.DataStorage.Objectives.ObjectivesSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Research.ResearchCollection;
import com.cobbs.lordcraft.Util.DataStorage.Research.ResearchData;
import com.cobbs.lordcraft.Util.DataStorage.Research.ResearchSavedData;
import com.cobbs.lordcraft.Util.Helpers.DataStorageHelper;
import com.cobbs.lordcraft.Util.Helpers.ModHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.util.FakePlayer;

public class ResearchCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        SuggestionProvider suggestions = (commandContext, suggestionsBuilder) -> {
            CommandSource source = (CommandSource)commandContext.getSource();
            try {
                ServerPlayerEntity p = source.func_197035_h();
                ResearchSavedData savedData = ResearchSavedData.get((PlayerEntity)p);
                ResearchData data = (ResearchData)((ResearchCollection)savedData.data).get((PlayerEntity)p);
                block5: for (EResearch r : EResearch.values()) {
                    switch (r) {
                        case WATER: 
                        case EARTH: 
                        case FIRE: 
                        case AIR: 
                        case LIGHT: 
                        case DARK: {
                            continue block5;
                        }
                        default: {
                            if (data.getState(r) != EResearchState.NORMAL) continue block5;
                            suggestionsBuilder.suggest(r.toString().toLowerCase());
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return suggestionsBuilder.buildFuture();
        };
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"lordcraft:research").requires(p_198485_0_ -> p_198485_0_.func_197034_c(2))).then(Commands.func_197057_a((String)"unlock").then(Commands.func_197056_a((String)"research", (ArgumentType)StringArgumentType.string()).suggests(suggestions).executes(p_198445_0_ -> ResearchCommand.unlockResearch((CommandSource)p_198445_0_.getSource(), StringArgumentType.getString((CommandContext)p_198445_0_, (String)"research"))))));
    }

    public static int unlockResearch(CommandSource source, String research) {
        EResearch res = EResearch.getResearch(research);
        if (res == null) {
            return 0;
        }
        int i = 0;
        try {
            ServerPlayerEntity p = source.func_197035_h();
            if (!(p instanceof FakePlayer)) {
                switch (res) {
                    case WATER: 
                    case EARTH: 
                    case FIRE: 
                    case AIR: 
                    case LIGHT: 
                    case DARK: {
                        ModHelper.actionBarMessage((PlayerEntity)p, "lordcraft.command.not_allowed");
                        return 0;
                    }
                }
                ResearchSavedData savedData = ResearchSavedData.get((PlayerEntity)p);
                ResearchData data = (ResearchData)((ResearchCollection)savedData.data).get((PlayerEntity)p);
                if (data.getState(res) == EResearchState.NORMAL) {
                    ResearchInstance instance = res.getInstance();
                    if (instance.objective != null) {
                        EObjective objective = instance.objective;
                        ObjectivesSavedData osavedData = ObjectivesSavedData.get((PlayerEntity)p);
                        ObjectivesData odata = (ObjectivesData)((ObjectivesCollection)osavedData.data).get((PlayerEntity)p);
                        int val = objective.max;
                        odata.objectives.set(objective.ordinal(), val);
                        osavedData.cleanupAndSync((PlayerEntity)p);
                        DataStorageHelper.processObjective(objective, (PlayerEntity)p, val);
                    } else {
                        data.setState(res, EResearchState.COMPLETE);
                        res.onUnlock((PlayerEntity)p);
                        savedData.cleanupAndSync((PlayerEntity)p);
                        ModHelper.unlockResearchFeedbackMessage((PlayerEntity)p);
                    }
                    ++i;
                } else {
                    ModHelper.missingResearch((PlayerEntity)p);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }
}

