/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.Config;

import com.cobbs.lordcraft.Util.WorldGen.OreEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class MainConfig {
    private static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final MainCfgFile MAIN = new MainCfgFile(builder);
    public static final ForgeConfigSpec spec = builder.build();
    private static boolean loaded = false;
    private static List<Runnable> loadActions = new ArrayList<Runnable>();

    public static void setLoaded() {
        if (!loaded) {
            loadActions.forEach(Runnable::run);
        }
        loaded = true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void onLoad(Runnable action) {
        if (loaded) {
            action.run();
        } else {
            loadActions.add(action);
        }
    }

    public static class MainCfgFile {
        public final List<ForgeConfigSpec.ConfigValue<Boolean>> enabled;
        public final List<ForgeConfigSpec.ConfigValue<Integer>> perChunks;
        public final List<ForgeConfigSpec.ConfigValue<Integer>> perClusters;
        public final List<ForgeConfigSpec.ConfigValue<Integer>> maxs;

        public MainCfgFile(ForgeConfigSpec.Builder builder) {
            builder.push("World Gen");
            this.enabled = new ArrayList<ForgeConfigSpec.ConfigValue<Boolean>>();
            this.perChunks = new ArrayList<ForgeConfigSpec.ConfigValue<Integer>>();
            this.perClusters = new ArrayList<ForgeConfigSpec.ConfigValue<Integer>>();
            this.maxs = new ArrayList<ForgeConfigSpec.ConfigValue<Integer>>();
            for (OreEntry o : OreEntry.ores) {
                builder.push(o.name);
                this.enabled.add((ForgeConfigSpec.ConfigValue<Boolean>)builder.define("Generation Enabled", o.enabled));
                this.perChunks.add((ForgeConfigSpec.ConfigValue<Integer>)builder.define("Clusters per Chunk", (Object)o.perChunk));
                this.perClusters.add((ForgeConfigSpec.ConfigValue<Integer>)builder.define("Blocks per Cluster", (Object)o.perCluster));
                this.maxs.add((ForgeConfigSpec.ConfigValue<Integer>)builder.define("Max Y for spawn", (Object)o.max));
                builder.pop();
            }
            builder.pop();
        }
    }
}

