/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.DataStorage;

import com.cobbs.lordcraft.Util.DataStorage.BasicData;
import com.cobbs.lordcraft.Util.DataStorage.BasicSavedData;
import com.cobbs.lordcraft.Util.Helpers.NetworkHelper;
import java.util.HashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public abstract class DataCollection<T extends BasicData> {
    private BasicSavedData storage;
    private HashMap<String, T> data = new HashMap();

    public DataCollection(BasicSavedData store) {
        this.storage = store;
    }

    public CompoundNBT serialize() {
        CompoundNBT nbt = new CompoundNBT();
        int i = 0;
        for (String s : this.data.keySet()) {
            nbt.func_74778_a("id" + i, s);
            nbt.func_218657_a("" + i, (INBT)((BasicData)this.data.get(s)).serialize());
            ++i;
        }
        return nbt;
    }

    public void deserialize(CompoundNBT nbt) {
        int i = 0;
        while (nbt.func_74764_b("" + i)) {
            this.data.put(nbt.func_74779_i("id" + i), this.createData(nbt.func_74775_l("" + i)));
            ++i;
        }
    }

    public abstract T createData();

    public abstract T createData(CompoundNBT var1);

    public abstract int handleID();

    public void syncToClient(ServerPlayerEntity player) {
        NetworkHelper.syncDataToPlayer(player, this.handleID(), this.get(player.func_110124_au().toString()));
    }

    public T get(String id) {
        BasicData toReturn = (BasicData)this.data.get(id);
        if (toReturn == null) {
            toReturn = this.createData();
            this.put(id, toReturn);
        }
        return (T)toReturn;
    }

    public void put(String id, T data) {
        this.data.put(id, data);
        this.storage.func_76185_a();
    }

    public T get(PlayerEntity player) {
        return this.get(player.func_110124_au().toString());
    }

    public void put(PlayerEntity player, T data) {
        this.put(player.func_110124_au().toString(), data);
    }
}

