/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.DataStorage.Mana;

import com.cobbs.lordcraft.Util.DataStorage.BasicSavedData;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaCollection;
import com.cobbs.lordcraft.Util.DataStorage.Mana.ManaData;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveCollection;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveData;
import com.cobbs.lordcraft.Util.DataStorage.Passives.PassiveSavedData;
import com.cobbs.lordcraft.Util.Helpers.NetworkHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraftforge.event.TickEvent;

public class ManaSavedData
extends BasicSavedData<ManaCollection> {
    private static final String NAME = "lordcraft:mana";

    public ManaSavedData() {
        super(NAME);
    }

    public static ManaSavedData get(ServerWorld world) {
        ServerWorld w = world.func_73046_m().func_71218_a(World.field_234918_g_);
        DimensionSavedDataManager storage = w.func_217481_x();
        return (ManaSavedData)storage.func_215752_a(ManaSavedData::new, NAME);
    }

    public static ManaSavedData get(PlayerEntity player) {
        return ManaSavedData.get((ServerWorld)player.func_130014_f_());
    }

    @Override
    public ManaCollection createCollection(BasicSavedData store) {
        return new ManaCollection(store);
    }

    public void tick(TickEvent.PlayerTickEvent event) {
        boolean change = false;
        PlayerEntity p = event.player;
        String id = p.func_110124_au().toString();
        PassiveSavedData data = PassiveSavedData.get(p);
        PassiveData pData = (PassiveData)((PassiveCollection)data.data).get(id);
        ManaData d = (ManaData)((ManaCollection)this.data).get(id);
        int incrementChargeMana = 10;
        if (d.pips < d.maxPips) {
            d.pipCharge += incrementChargeMana;
            if (d.pipCharge >= 1000) {
                d.pipCharge -= 1000;
                ++d.pips;
            }
            change = true;
        }
        if (d.primalCharge < 1000) {
            d.primalCharge = Math.min(d.primalCharge + 5, 1000);
            change = true;
        }
        if (change) {
            this.func_76185_a();
            ((ManaCollection)this.data).syncToClient((ServerPlayerEntity)p);
        }
    }

    public boolean drainPips(PlayerEntity p, int amount) {
        ManaData d = (ManaData)((ManaCollection)this.data).get(p.func_110124_au().toString());
        if (amount <= d.pips) {
            d.pips -= amount;
            this.func_76185_a();
            ((ManaCollection)this.data).syncToClient((ServerPlayerEntity)p);
            return true;
        }
        NetworkHelper.dataToPlayer((ServerPlayerEntity)p, "moc", amount);
        return false;
    }
}

