/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.lordcraft.Util.DataStorage.Passives;

import com.cobbs.lordcraft.Passives.EPassive;
import com.cobbs.lordcraft.Passives.IHasLinkedData;
import com.cobbs.lordcraft.Passives.Passive;
import com.cobbs.lordcraft.Util.DataStorage.BasicData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class PassiveData
extends BasicData {
    public Map<EPassive, Integer> states;
    public Map<EPassive, BasicData> linkedData;
    public int ticker = 0;

    public PassiveData() {
        this.states = new HashMap<EPassive, Integer>();
        this.linkedData = new HashMap<EPassive, BasicData>();
    }

    public PassiveData(CompoundNBT nbt) {
        super(nbt);
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT nbt = new CompoundNBT();
        for (EPassive p : this.states.keySet()) {
            nbt.func_74768_a("" + p.ordinal(), this.states.get((Object)p).intValue());
        }
        for (EPassive p : this.linkedData.keySet()) {
            nbt.func_218657_a("data" + p.ordinal(), (INBT)this.linkedData.get((Object)p).serialize());
        }
        return nbt;
    }

    @Override
    public void deserialize(CompoundNBT nbt) {
        this.states = new HashMap<EPassive, Integer>();
        this.linkedData = new HashMap<EPassive, BasicData>();
        for (EPassive p : EPassive.values()) {
            String key = "" + p.ordinal();
            String key2 = "data" + p.ordinal();
            if (!nbt.func_74764_b(key)) continue;
            this.states.put(p, nbt.func_74762_e(key));
            if (!nbt.func_74764_b(key2)) continue;
            if (this.linkedData.containsKey((Object)p)) {
                this.linkedData.get((Object)p).deserialize(nbt.func_74775_l(key2));
                continue;
            }
            this.linkedData.put(p, (BasicData)((IHasLinkedData)((Object)p.getPassive())).data(nbt.func_74775_l(key2)));
        }
    }

    public int getState(EPassive passive) {
        if (this.states.containsKey((Object)passive)) {
            return this.states.get((Object)passive);
        }
        return 3;
    }

    public boolean has(EPassive passive) {
        return this.getState(passive) == 2;
    }

    public void setState(EPassive passive, int val) {
        Passive p;
        if (!this.states.containsKey((Object)passive) && (p = passive.getPassive()) instanceof IHasLinkedData) {
            this.linkedData.put(passive, (BasicData)((IHasLinkedData)((Object)p)).data());
        }
        this.states.put(passive, val);
    }

    public BasicData getData(EPassive passive) {
        return this.linkedData.get((Object)passive);
    }
}

